/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.notification.internal.type;

import com.liferay.notification.context.NotificationContext;
import com.liferay.notification.internal.type.users.provider.UsersProvider;
import com.liferay.notification.model.NotificationQueueEntry;
import com.liferay.notification.model.NotificationRecipient;
import com.liferay.notification.model.NotificationRecipientSetting;
import com.liferay.notification.model.NotificationTemplate;
import com.liferay.notification.type.BaseNotificationType;
import com.liferay.notification.type.NotificationType;
import com.liferay.object.service.ObjectEntryService;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserNotificationEventLocalService;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.ArrayList;
import java.util.HashMap;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={NotificationType.class})
public class UserNotificationType
extends BaseNotificationType {
    @Reference
    private ObjectEntryService _objectEntryService;
    private ServiceTrackerMap<String, UsersProvider> _serviceTrackerMap;
    @Reference
    private UserNotificationEventLocalService _userNotificationEventLocalService;

    public NotificationQueueEntry createNotificationQueueEntry(User user, String body, NotificationContext notificationContext, String subject) {
        NotificationQueueEntry notificationQueueEntry = super.createNotificationQueueEntry(user, body, notificationContext, subject);
        notificationQueueEntry.setStatus(1);
        return notificationQueueEntry;
    }

    public String getRecipientSummary(NotificationQueueEntry notificationQueueEntry) {
        NotificationRecipient notificationRecipient = notificationQueueEntry.getNotificationRecipient();
        ArrayList<String> values = new ArrayList<String>();
        for (NotificationRecipientSetting notificationRecipientSetting : notificationRecipient.getNotificationRecipientSettings()) {
            values.add(notificationRecipientSetting.getValue());
        }
        return ListUtil.toString(values, (String)null, (String)", ");
    }

    public String getType() {
        return "userNotification";
    }

    public String getTypeLanguageKey() {
        return "user-notification";
    }

    public void sendNotification(NotificationContext notificationContext) throws PortalException {
        ArrayList<HashMap> notificationRecipientSettings = new ArrayList<HashMap>();
        NotificationTemplate notificationTemplate = notificationContext.getNotificationTemplate();
        UsersProvider usersProvider = (UsersProvider)this._serviceTrackerMap.getService((Object)notificationTemplate.getRecipientType());
        for (User user : usersProvider.provide(notificationContext)) {
            if (!this._objectEntryService.hasModelResourcePermission(user, notificationContext.getClassPK(), "VIEW")) continue;
            this.siteDefaultLocale = this.portal.getSiteDefaultLocale(user.getGroupId());
            this.userLocale = user.getLocale();
            this._userNotificationEventLocalService.sendUserNotificationEvents(user.getUserId(), notificationContext.getPortletId(), 10002, JSONUtil.put((String)"className", (Object)notificationContext.getClassName()).put("classPK", notificationContext.getClassPK()).put("externalReferenceCode", notificationContext.getExternalReferenceCode()).put("notificationMessage", this.formatLocalizedContent(notificationTemplate.getSubjectMap(), notificationContext)).put("portletId", notificationContext.getPortletId()));
            notificationRecipientSettings.add(HashMapBuilder.put((Object)"userFullName", (Object)user.getFullName()).build());
        }
        User user = this.userLocalService.getUser(notificationContext.getUserId());
        this.siteDefaultLocale = this.portal.getSiteDefaultLocale(user.getGroupId());
        this.userLocale = user.getLocale();
        this.prepareNotificationContext(user, null, notificationContext, notificationRecipientSettings, this.formatLocalizedContent(notificationTemplate.getSubjectMap(), notificationContext));
        this.notificationQueueEntryLocalService.addNotificationQueueEntry(notificationContext);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, UsersProvider.class, (String)"recipient.type");
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }
}

