/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.notification.internal.type;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.info.field.InfoField;
import com.liferay.info.field.InfoFieldValue;
import com.liferay.info.item.InfoItemFieldValues;
import com.liferay.info.item.InfoItemServiceRegistry;
import com.liferay.info.item.provider.InfoItemFieldValuesProvider;
import com.liferay.mail.kernel.model.MailMessage;
import com.liferay.mail.kernel.service.MailService;
import com.liferay.notification.context.NotificationContext;
import com.liferay.notification.exception.NotificationRecipientSettingValueException;
import com.liferay.notification.model.NotificationQueueEntry;
import com.liferay.notification.model.NotificationQueueEntryAttachment;
import com.liferay.notification.model.NotificationRecipient;
import com.liferay.notification.model.NotificationRecipientSetting;
import com.liferay.notification.model.NotificationTemplate;
import com.liferay.notification.model.NotificationTemplateAttachment;
import com.liferay.notification.service.NotificationQueueEntryAttachmentLocalService;
import com.liferay.notification.service.NotificationTemplateAttachmentLocalService;
import com.liferay.notification.type.BaseNotificationType;
import com.liferay.notification.type.NotificationType;
import com.liferay.notification.util.NotificationRecipientSettingUtil;
import com.liferay.object.model.ObjectField;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepository;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.auth.EmailAddressValidator;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.template.StringTemplateResource;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.templateparser.TemplateNode;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.EmailAddressValidatorFactory;
import com.liferay.portal.service.PersistedModelLocalServiceRegistryUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.template.transformer.TemplateNodeFactory;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.internet.InternetAddress;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={NotificationType.class})
public class EmailNotificationType
extends BaseNotificationType {
    private static final Log _log = LogFactoryUtil.getLog(EmailNotificationType.class);
    private static final Pattern _emailAddressPattern = Pattern.compile("[\\w!#$%&'*+/=?^_`{|}~-]+(?:\\.[\\w!#$%&'*+/=?^_`{|}~-]+)*@(?:\\w(?:[\\w-]*\\w)?\\.)+(\\w(?:[\\w-]*\\w))");
    @Reference
    private DLFileEntryLocalService _dlFileEntryLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private InfoItemServiceRegistry _infoItemServiceRegistry;
    @Reference
    private MailService _mailService;
    @Reference
    private NotificationQueueEntryAttachmentLocalService _notificationQueueEntryAttachmentLocalService;
    @Reference
    private NotificationTemplateAttachmentLocalService _notificationTemplateAttachmentLocalService;
    @Reference
    private ObjectFieldLocalService _objectFieldLocalService;
    @Reference
    private PortletFileRepository _portletFileRepository;
    @Reference
    private TemplateNodeFactory _templateNodeFactory;

    public String getFromName(NotificationQueueEntry notificationQueueEntry) {
        Map notificationRecipientSettingsMap = NotificationRecipientSettingUtil.getNotificationRecipientSettingsMap((NotificationQueueEntry)notificationQueueEntry);
        return String.valueOf(notificationRecipientSettingsMap.get("fromName"));
    }

    public String getRecipientSummary(NotificationQueueEntry notificationQueueEntry) {
        Map notificationRecipientSettingsMap = NotificationRecipientSettingUtil.getNotificationRecipientSettingsMap((NotificationQueueEntry)notificationQueueEntry);
        return String.valueOf(notificationRecipientSettingsMap.get("to"));
    }

    public String getType() {
        return "email";
    }

    public String getTypeLanguageKey() {
        return "email";
    }

    public void resendNotification(NotificationQueueEntry notificationQueueEntry) throws PortalException {
        if (notificationQueueEntry.getStatus() != 2) {
            notificationQueueEntry = this.notificationQueueEntryLocalService.updateStatus(notificationQueueEntry.getNotificationQueueEntryId(), 2);
        }
        this.sendNotification(notificationQueueEntry);
    }

    public void resendNotifications(int status, String type) throws PortalException {
        for (NotificationQueueEntry notificationQueueEntry : this.notificationQueueEntryLocalService.getNotificationEntries(type, status)) {
            this.resendNotification(notificationQueueEntry);
        }
    }

    public void sendNotification(NotificationContext notificationContext) throws PortalException {
        long groupId = 0L;
        User user = this.userLocalService.getUser(notificationContext.getUserId());
        Group userGroup = user.getGroup();
        if (userGroup != null) {
            groupId = userGroup.getGroupId();
        }
        this.siteDefaultLocale = this.portal.getSiteDefaultLocale(groupId);
        this.userLocale = user.getLocale();
        notificationContext.setFileEntryIds(this._getFileEntryIds(user.getCompanyId(), notificationContext));
        NotificationTemplate notificationTemplate = notificationContext.getNotificationTemplate();
        String body = this._formatBody(notificationTemplate.getBodyMap(), notificationContext);
        NotificationRecipient notificationRecipient = notificationTemplate.getNotificationRecipient();
        String subject = this.formatLocalizedContent(notificationTemplate.getSubjectMap(), notificationContext);
        HashMap evaluatedNotificationRecipientSettings = HashMapBuilder.put((Object)"bcc", (Object)this.formatContent("bcc", notificationContext, notificationRecipient.getNotificationRecipientId())).put((Object)"cc", (Object)this.formatContent("cc", notificationContext, notificationRecipient.getNotificationRecipientId())).put((Object)"from", (Object)this.formatContent("from", notificationContext, notificationRecipient.getNotificationRecipientId())).put((Object)"fromName", () -> {
            NotificationRecipientSetting notificationRecipientSetting = this.notificationRecipientSettingLocalService.fetchNotificationRecipientSetting(notificationRecipient.getNotificationRecipientId(), "fromName");
            return this.formatLocalizedContent(notificationRecipientSetting.getValueMap(), notificationContext);
        }).put((Object)"singleRecipient", () -> {
            NotificationRecipientSetting notificationRecipientSetting = this.notificationRecipientSettingLocalService.fetchNotificationRecipientSetting(notificationRecipient.getNotificationRecipientId(), "singleRecipient");
            if (notificationRecipientSetting == null) {
                return Boolean.TRUE.toString();
            }
            return notificationRecipientSetting.getValue();
        }).put((Object)"to", () -> {
            NotificationRecipientSetting notificationRecipientSetting = this.notificationRecipientSettingLocalService.fetchNotificationRecipientSetting(notificationRecipient.getNotificationRecipientId(), "to");
            String to = notificationRecipientSetting.getValue(user.getLocale());
            if (Validator.isNull((String)to)) {
                to = notificationRecipientSetting.getValue(this.siteDefaultLocale);
            }
            return this._formatTo(this.formatLocalizedContent(to, notificationContext));
        }).build();
        String validEmailAddresses = this._getValidEmailAddresses(user.getCompanyId(), (String)evaluatedNotificationRecipientSettings.get("to"));
        if (!GetterUtil.getBoolean((String)((String)evaluatedNotificationRecipientSettings.get("singleRecipient")))) {
            this.prepareNotificationContext(user, body, notificationContext, HashMapBuilder.putAll((Map)evaluatedNotificationRecipientSettings).put((Object)"to", (Object)validEmailAddresses).build(), subject);
            this.sendNotification(this.notificationQueueEntryLocalService.addNotificationQueueEntry(notificationContext));
            return;
        }
        for (String emailAddress : StringUtil.split((String)validEmailAddresses)) {
            User emailAddressUser = this.userLocalService.fetchUserByEmailAddress(user.getCompanyId(), emailAddress);
            if (emailAddressUser == null) {
                emailAddressUser = this.userLocalService.getGuestUser(CompanyThreadLocal.getCompanyId().longValue());
            }
            this.prepareNotificationContext(emailAddressUser, body, notificationContext, HashMapBuilder.putAll((Map)evaluatedNotificationRecipientSettings).put((Object)"to", (Object)emailAddress).build(), subject);
            this.sendNotification(this.notificationQueueEntryLocalService.addNotificationQueueEntry(notificationContext));
        }
    }

    public void sendNotification(NotificationQueueEntry notificationQueueEntry) {
        TransactionCommitCallbackUtil.registerCallback(() -> {
            block3: {
                try {
                    Map notificationRecipientSettingsMap = NotificationRecipientSettingUtil.getNotificationRecipientSettingsMap((NotificationQueueEntry)notificationQueueEntry);
                    MailMessage mailMessage = new MailMessage(new InternetAddress(String.valueOf(notificationRecipientSettingsMap.get("from")), String.valueOf(notificationRecipientSettingsMap.get("fromName"))), notificationQueueEntry.getSubject(), notificationQueueEntry.getBody(), true);
                    this._addFileAttachments(mailMessage, notificationQueueEntry.getNotificationQueueEntryId());
                    mailMessage.setBCC(this._toInternetAddresses(String.valueOf(notificationRecipientSettingsMap.get("bcc"))));
                    mailMessage.setCC(this._toInternetAddresses(String.valueOf(notificationRecipientSettingsMap.get("cc"))));
                    mailMessage.setTo(this._toInternetAddresses(String.valueOf(notificationRecipientSettingsMap.get("to"))));
                    MessageBusUtil.sendMessage((String)"liferay/mail", (Object)mailMessage);
                    this.notificationQueueEntryLocalService.updateStatus(notificationQueueEntry.getNotificationQueueEntryId(), 1);
                }
                catch (Exception exception) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Throwable)exception);
                    }
                    if (notificationQueueEntry.getStatus() == 0) break block3;
                    this.notificationQueueEntryLocalService.updateStatus(notificationQueueEntry.getNotificationQueueEntryId(), 0);
                }
            }
            return null;
        });
    }

    public Object[] toRecipients(List<NotificationRecipientSetting> notificationRecipientSettings) {
        return new Object[]{NotificationRecipientSettingUtil.toMap(notificationRecipientSettings)};
    }

    public void validateNotificationQueueEntry(NotificationContext notificationContext) throws PortalException {
        super.validateNotificationQueueEntry(notificationContext);
        this._validateNotificationRecipientSettings(NotificationRecipientSettingUtil.toMap((List)notificationContext.getNotificationRecipientSettings()));
    }

    public void validateNotificationTemplate(NotificationContext notificationContext) throws PortalException {
        super.validateNotificationTemplate(notificationContext);
        this._validateNotificationRecipientSettings(NotificationRecipientSettingUtil.toMap((List)notificationContext.getNotificationRecipientSettings()));
    }

    private void _addFileAttachments(MailMessage mailMessage, long notificationQueueEntryId) {
        for (NotificationQueueEntryAttachment notificationQueueEntryAttachment : this._notificationQueueEntryAttachmentLocalService.getNotificationQueueEntryNotificationQueueEntryAttachments(notificationQueueEntryId)) {
            try {
                FileEntry fileEntry = this._portletFileRepository.getPortletFileEntry(notificationQueueEntryAttachment.getFileEntryId());
                mailMessage.addFileAttachment(FileUtil.createTempFile((InputStream)fileEntry.getContentStream()), fileEntry.getFileName());
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Throwable)exception);
            }
        }
    }

    private String _formatBody(Map<Locale, String> bodyMap, NotificationContext notificationContext) throws PortalException {
        NotificationTemplate notificationTemplate = notificationContext.getNotificationTemplate();
        if (Objects.equals("richText", notificationTemplate.getEditorType())) {
            return this.formatLocalizedContent(bodyMap, notificationContext);
        }
        StringWriter stringWriter = new StringWriter();
        String body = notificationTemplate.getBody(this.userLocale);
        if (Validator.isNull((String)body)) {
            body = notificationTemplate.getBody(this.siteDefaultLocale);
        }
        Template template = TemplateManagerUtil.getTemplate((String)"ftl", (TemplateResource)new StringTemplateResource(NotificationTemplate.class.getName() + "#" + notificationTemplate.getNotificationTemplateId(), body), (!PropsValues.NOTIFICATION_EMAIL_TEMPLATE_ENABLED ? 1 : 0) != 0);
        ThemeDisplay themeDisplay = new ThemeDisplay();
        themeDisplay.setLocale(this.siteDefaultLocale);
        InfoItemFieldValuesProvider infoItemFieldValuesProvider = (InfoItemFieldValuesProvider)this._infoItemServiceRegistry.getFirstInfoItemService(InfoItemFieldValuesProvider.class, notificationContext.getClassName());
        PersistedModelLocalService persistedModelLocalService = PersistedModelLocalServiceRegistryUtil.getPersistedModelLocalService((String)notificationContext.getClassName());
        InfoItemFieldValues infoItemFieldValues = infoItemFieldValuesProvider.getInfoItemFieldValues((Object)persistedModelLocalService.getPersistedModel((Serializable)Long.valueOf(notificationContext.getClassPK())));
        for (InfoFieldValue infoFieldValue : infoItemFieldValues.getInfoFieldValues()) {
            InfoField infoField = infoFieldValue.getInfoField();
            if (StringUtil.startsWith((String)infoField.getName(), (String)"ddmTemplate_")) continue;
            TemplateNode templateNode = this._templateNodeFactory.createTemplateNode(infoFieldValue, themeDisplay);
            template.put((Object)infoField.getName(), (Object)templateNode);
            template.put((Object)infoField.getUniqueId(), (Object)templateNode);
        }
        template.processTemplate((Writer)stringWriter);
        return stringWriter.toString();
    }

    private String _formatTo(String to) {
        if (Validator.isNull((String)to)) {
            return "";
        }
        HashSet<String> emailAddresses = new HashSet<String>();
        Matcher matcher = _emailAddressPattern.matcher(to);
        while (matcher.find()) {
            emailAddresses.add(matcher.group());
        }
        return StringUtil.merge(emailAddresses);
    }

    private List<Long> _getFileEntryIds(long companyId, NotificationContext notificationContext) throws PortalException {
        Group group = this._groupLocalService.getCompanyGroup(companyId);
        Repository repository = this._getRepository(group.getGroupId());
        if (repository == null) {
            return new ArrayList<Long>();
        }
        ArrayList<Long> fileEntryIds = new ArrayList<Long>();
        NotificationTemplate notificationTemplate = notificationContext.getNotificationTemplate();
        for (NotificationTemplateAttachment notificationTemplateAttachment : this._notificationTemplateAttachmentLocalService.getNotificationTemplateAttachments(notificationTemplate.getNotificationTemplateId())) {
            ObjectField objectField = this._objectFieldLocalService.fetchObjectField(notificationTemplateAttachment.getObjectFieldId());
            DLFileEntry dlFileEntry = this._dlFileEntryLocalService.fetchDLFileEntry(MapUtil.getLong((Map)notificationContext.getTermValues(), (String)objectField.getName()));
            if (dlFileEntry == null) continue;
            FileEntry fileEntry = this._portletFileRepository.addPortletFileEntry(null, repository.getGroupId(), this.userLocalService.getGuestUserId(companyId), NotificationTemplate.class.getName(), 0L, "com_liferay_notification_web_internal_portlet_NotificationTemplatesPortlet", repository.getDlFolderId(), dlFileEntry.getContentStream(), this._portletFileRepository.getUniqueFileName(group.getGroupId(), repository.getDlFolderId(), dlFileEntry.getFileName()), dlFileEntry.getMimeType(), false);
            fileEntryIds.add(fileEntry.getFileEntryId());
        }
        return fileEntryIds;
    }

    private Repository _getRepository(long groupId) {
        Repository repository = this._portletFileRepository.fetchPortletRepository(groupId, "com_liferay_notification_web_internal_portlet_NotificationTemplatesPortlet");
        if (repository != null) {
            return repository;
        }
        try {
            return this._portletFileRepository.addPortletRepository(groupId, "com_liferay_notification_web_internal_portlet_NotificationTemplatesPortlet", new ServiceContext());
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)portalException);
            }
            return null;
        }
    }

    private String _getValidEmailAddresses(long companyId, String emailAddresses) {
        StringBundler sb = new StringBundler();
        for (String emailAddress : StringUtil.split((String)emailAddresses)) {
            EmailAddressValidator emailAddressValidator = EmailAddressValidatorFactory.getInstance();
            if (!emailAddressValidator.validate(companyId, emailAddress)) {
                if (!_log.isInfoEnabled()) continue;
                _log.info((Object)("Invalid email address " + emailAddress));
                continue;
            }
            if (sb.index() > 0) {
                sb.append(",");
            }
            sb.append(emailAddress);
        }
        return sb.toString();
    }

    private InternetAddress[] _toInternetAddresses(String string) throws Exception {
        ArrayList<InternetAddress> internetAddresses = new ArrayList<InternetAddress>();
        for (String internetAddressString : StringUtil.split((String)string)) {
            internetAddresses.add(new InternetAddress(internetAddressString));
        }
        return internetAddresses.toArray(new InternetAddress[0]);
    }

    private void _validateNotificationRecipientSettings(Map<String, Object> notificationRecipientSettingsMap) throws PortalException {
        if (Validator.isNull((Object)notificationRecipientSettingsMap.get("from"))) {
            throw new NotificationRecipientSettingValueException.FromMustNotBeNull();
        }
        if (Validator.isNull((Object)notificationRecipientSettingsMap.get("fromName"))) {
            throw new NotificationRecipientSettingValueException.FromNameMustNotBeNull();
        }
        if (Validator.isNull((Object)notificationRecipientSettingsMap.get("to"))) {
            throw new NotificationRecipientSettingValueException.ToMustNotBeNull();
        }
    }
}

