/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.notification.internal.security.permission.resource;

import com.liferay.notification.model.NotificationTemplate;
import com.liferay.notification.service.NotificationTemplateLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.notification.model.NotificationTemplate"}, service={ModelResourcePermission.class})
public class NotificationTemplateModelResourcePermission
implements ModelResourcePermission<NotificationTemplate> {
    @Reference
    private NotificationTemplateLocalService _notificationTemplateLocalService;
    @Reference(target="(resource.name=com.liferay.notification.template)")
    private PortletResourcePermission _portletResourcePermission;

    public void check(PermissionChecker permissionChecker, long notificationTemplateId, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, notificationTemplateId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, NotificationTemplate.class.getName(), notificationTemplateId, new String[]{actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, NotificationTemplate notificationTemplate, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, notificationTemplate, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, NotificationTemplate.class.getName(), notificationTemplate.getPrimaryKey(), new String[]{actionId});
        }
    }

    public boolean contains(PermissionChecker permissionChecker, long notificationTemplateId, String actionId) throws PortalException {
        return this.contains(permissionChecker, this._notificationTemplateLocalService.getNotificationTemplate(notificationTemplateId), actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, NotificationTemplate notificationTemplate, String actionId) throws PortalException {
        return permissionChecker.hasOwnerPermission(permissionChecker.getCompanyId(), NotificationTemplate.class.getName(), notificationTemplate.getNotificationTemplateId(), notificationTemplate.getUserId(), actionId) || permissionChecker.hasPermission(null, NotificationTemplate.class.getName(), notificationTemplate.getPrimaryKey(), actionId);
    }

    public String getModelName() {
        return NotificationTemplate.class.getName();
    }

    public PortletResourcePermission getPortletResourcePermission() {
        return this._portletResourcePermission;
    }
}

