/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.multi.factor.authentication.fido2.credential.model.impl;

import com.liferay.multi.factor.authentication.fido2.credential.model.MFAFIDO2CredentialEntry;
import com.liferay.multi.factor.authentication.fido2.credential.service.MFAFIDO2CredentialEntryLocalServiceUtil;

/**
 * The extended model base implementation for the MFAFIDO2CredentialEntry service. Represents a row in the &quot;MFAFIDO2CredentialEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link MFAFIDO2CredentialEntryImpl}.
 * </p>
 *
 * @author Arthur Chan
 * @see MFAFIDO2CredentialEntryImpl
 * @see MFAFIDO2CredentialEntry
 * @generated
 */
public abstract class MFAFIDO2CredentialEntryBaseImpl
	extends MFAFIDO2CredentialEntryModelImpl
	implements MFAFIDO2CredentialEntry {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a mfafido2 credential entry model instance should use the <code>MFAFIDO2CredentialEntry</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			MFAFIDO2CredentialEntryLocalServiceUtil.addMFAFIDO2CredentialEntry(
				this);
		}
		else {
			MFAFIDO2CredentialEntryLocalServiceUtil.
				updateMFAFIDO2CredentialEntry(this);
		}
	}

}