/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.device.rules.service.impl;

import com.liferay.mobile.device.rules.model.MDRAction;
import com.liferay.mobile.device.rules.model.MDRRuleGroupInstance;
import com.liferay.mobile.device.rules.service.base.MDRActionServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.UnicodeProperties;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=mdr", "json.web.service.context.path=MDRAction"}, service={AopService.class})
public class MDRActionServiceImpl
extends MDRActionServiceBaseImpl {
    @Reference(target="(model.class.name=com.liferay.mobile.device.rules.model.MDRRuleGroupInstance)")
    private ModelResourcePermission<MDRRuleGroupInstance> _mdrRuleGroupInstanceModelResourcePermission;

    public MDRAction addAction(long ruleGroupInstanceId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String type, String typeSettings, ServiceContext serviceContext) throws PortalException {
        this._mdrRuleGroupInstanceModelResourcePermission.check(this.getPermissionChecker(), ruleGroupInstanceId, "UPDATE");
        return this.mdrActionLocalService.addAction(ruleGroupInstanceId, nameMap, descriptionMap, type, typeSettings, serviceContext);
    }

    public MDRAction addAction(long ruleGroupInstanceId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String type, UnicodeProperties typeSettingsUnicodeProperties, ServiceContext serviceContext) throws PortalException {
        this._mdrRuleGroupInstanceModelResourcePermission.check(this.getPermissionChecker(), ruleGroupInstanceId, "UPDATE");
        return this.mdrActionLocalService.addAction(ruleGroupInstanceId, nameMap, descriptionMap, type, typeSettingsUnicodeProperties, serviceContext);
    }

    public void deleteAction(long actionId) throws PortalException {
        MDRAction action = this.mdrActionPersistence.findByPrimaryKey(actionId);
        this._mdrRuleGroupInstanceModelResourcePermission.check(this.getPermissionChecker(), action.getRuleGroupInstanceId(), "UPDATE");
        this.mdrActionLocalService.deleteAction(action);
    }

    public MDRAction fetchAction(long actionId) throws PortalException {
        MDRAction action = this.mdrActionLocalService.fetchAction(actionId);
        if (action != null) {
            this._mdrRuleGroupInstanceModelResourcePermission.check(this.getPermissionChecker(), action.getRuleGroupInstanceId(), "VIEW");
        }
        return action;
    }

    public MDRAction getAction(long actionId) throws PortalException {
        MDRAction action = this.mdrActionPersistence.findByPrimaryKey(actionId);
        this._mdrRuleGroupInstanceModelResourcePermission.check(this.getPermissionChecker(), action.getRuleGroupInstanceId(), "VIEW");
        return action;
    }

    public MDRAction updateAction(long actionId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String type, String typeSettings, ServiceContext serviceContext) throws PortalException {
        MDRAction action = this.mdrActionPersistence.findByPrimaryKey(actionId);
        this._mdrRuleGroupInstanceModelResourcePermission.check(this.getPermissionChecker(), action.getRuleGroupInstanceId(), "UPDATE");
        return this.mdrActionLocalService.updateAction(actionId, nameMap, descriptionMap, type, typeSettings, serviceContext);
    }

    public MDRAction updateAction(long actionId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String type, UnicodeProperties typeSettingsUnicodeProperties, ServiceContext serviceContext) throws PortalException {
        MDRAction action = this.mdrActionPersistence.findByPrimaryKey(actionId);
        this._mdrRuleGroupInstanceModelResourcePermission.check(this.getPermissionChecker(), action.getRuleGroupInstanceId(), "UPDATE");
        return this.mdrActionLocalService.updateAction(actionId, nameMap, descriptionMap, type, typeSettingsUnicodeProperties, serviceContext);
    }
}

