/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.device.rules.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.exportimport.kernel.lar.ExportImportHelperUtil;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.mobile.device.rules.model.MDRRule;
import com.liferay.mobile.device.rules.service.MDRRuleLocalService;
import com.liferay.mobile.device.rules.service.MDRRuleLocalServiceUtil;
import com.liferay.mobile.device.rules.service.persistence.MDRRuleGroupFinder;
import com.liferay.mobile.device.rules.service.persistence.MDRRuleGroupPersistence;
import com.liferay.mobile.device.rules.service.persistence.MDRRulePersistence;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.ParamSetter;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdate;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdateFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import java.io.Serializable;
import java.util.List;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

public abstract class MDRRuleLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements AopService,
IdentifiableOSGiService,
MDRRuleLocalService {
    protected MDRRuleLocalService mdrRuleLocalService;
    @Reference
    protected MDRRulePersistence mdrRulePersistence;
    @Reference
    protected CounterLocalService counterLocalService;
    @Reference
    protected UserLocalService userLocalService;
    @Reference
    protected MDRRuleGroupPersistence mdrRuleGroupPersistence;
    @Reference
    protected MDRRuleGroupFinder mdrRuleGroupFinder;
    private static final Log _log = LogFactoryUtil.getLog(MDRRuleLocalServiceBaseImpl.class);

    @Indexable(type=IndexableType.REINDEX)
    public MDRRule addMDRRule(MDRRule mdrRule) {
        mdrRule.setNew(true);
        return (MDRRule)this.mdrRulePersistence.update((BaseModel)mdrRule);
    }

    @Transactional(enabled=false)
    public MDRRule createMDRRule(long ruleId) {
        return this.mdrRulePersistence.create(ruleId);
    }

    @Indexable(type=IndexableType.DELETE)
    public MDRRule deleteMDRRule(long ruleId) throws PortalException {
        return this.mdrRulePersistence.remove(ruleId);
    }

    @Indexable(type=IndexableType.DELETE)
    public MDRRule deleteMDRRule(MDRRule mdrRule) {
        return (MDRRule)this.mdrRulePersistence.remove((BaseModel)mdrRule);
    }

    public <T> T dslQuery(DSLQuery dslQuery) {
        return (T)this.mdrRulePersistence.dslQuery(dslQuery);
    }

    public int dslQueryCount(DSLQuery dslQuery) {
        Long count = (Long)this.dslQuery(dslQuery);
        return count.intValue();
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(MDRRule.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.mdrRulePersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.mdrRulePersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.mdrRulePersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.mdrRulePersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.mdrRulePersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public MDRRule fetchMDRRule(long ruleId) {
        return this.mdrRulePersistence.fetchByPrimaryKey(ruleId);
    }

    public MDRRule fetchMDRRuleByUuidAndGroupId(String uuid, long groupId) {
        return this.mdrRulePersistence.fetchByUUID_G(uuid, groupId);
    }

    public MDRRule getMDRRule(long ruleId) throws PortalException {
        return this.mdrRulePersistence.findByPrimaryKey(ruleId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.mdrRuleLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(MDRRule.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("ruleId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.mdrRuleLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(MDRRule.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("ruleId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.mdrRuleLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(MDRRule.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("ruleId");
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(final PortletDataContext portletDataContext) {
        ExportActionableDynamicQuery exportActionableDynamicQuery = new ExportActionableDynamicQuery(){

            public long performCount() throws PortalException {
                ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
                StagedModelType stagedModelType = this.getStagedModelType();
                long modelAdditionCount = super.performCount();
                manifestSummary.addModelAdditionCount(stagedModelType, modelAdditionCount);
                long modelDeletionCount = ExportImportHelperUtil.getModelDeletionCount((PortletDataContext)portletDataContext, (StagedModelType)stagedModelType);
                manifestSummary.addModelDeletionCount(stagedModelType, modelDeletionCount);
                return modelAdditionCount;
            }
        };
        this.initActionableDynamicQuery((ActionableDynamicQuery)exportActionableDynamicQuery);
        exportActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                portletDataContext.addDateRangeCriteria(dynamicQuery, "modifiedDate");
            }
        });
        exportActionableDynamicQuery.setCompanyId(portletDataContext.getCompanyId());
        exportActionableDynamicQuery.setGroupId(portletDataContext.getScopeGroupId());
        exportActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<MDRRule>(){

            public void performAction(MDRRule mdrRule) throws PortalException {
                StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)mdrRule);
            }
        });
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(PortalUtil.getClassNameId((String)MDRRule.class.getName())));
        return exportActionableDynamicQuery;
    }

    public PersistedModel createPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return this.mdrRulePersistence.create(((Long)primaryKeyObj).longValue());
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        return this.mdrRuleLocalService.deleteMDRRule((MDRRule)persistedModel);
    }

    public BasePersistence<MDRRule> getBasePersistence() {
        return this.mdrRulePersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.mdrRulePersistence.findByPrimaryKey(primaryKeyObj);
    }

    public List<MDRRule> getMDRRulesByUuidAndCompanyId(String uuid, long companyId) {
        return this.mdrRulePersistence.findByUuid_C(uuid, companyId);
    }

    public List<MDRRule> getMDRRulesByUuidAndCompanyId(String uuid, long companyId, int start, int end, OrderByComparator<MDRRule> orderByComparator) {
        return this.mdrRulePersistence.findByUuid_C(uuid, companyId, start, end, orderByComparator);
    }

    public MDRRule getMDRRuleByUuidAndGroupId(String uuid, long groupId) throws PortalException {
        return this.mdrRulePersistence.findByUUID_G(uuid, groupId);
    }

    public List<MDRRule> getMDRRules(int start, int end) {
        return this.mdrRulePersistence.findAll(start, end);
    }

    public int getMDRRulesCount() {
        return this.mdrRulePersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public MDRRule updateMDRRule(MDRRule mdrRule) {
        return (MDRRule)this.mdrRulePersistence.update((BaseModel)mdrRule);
    }

    @Deactivate
    protected void deactivate() {
        MDRRuleLocalServiceUtil.setService(null);
    }

    public Class<?>[] getAopInterfaces() {
        return new Class[]{MDRRuleLocalService.class, IdentifiableOSGiService.class, PersistedModelLocalService.class};
    }

    public void setAopProxy(Object aopProxy) {
        this.mdrRuleLocalService = (MDRRuleLocalService)aopProxy;
        MDRRuleLocalServiceUtil.setService((MDRRuleLocalService)this.mdrRuleLocalService);
    }

    public String getOSGiServiceIdentifier() {
        return MDRRuleLocalService.class.getName();
    }

    protected Class<?> getModelClass() {
        return MDRRule.class;
    }

    protected String getModelClassName() {
        return MDRRule.class.getName();
    }

    protected void runSQL(String sql) {
        try {
            DataSource dataSource = this.mdrRulePersistence.getDataSource();
            DB db = DBManagerUtil.getDB();
            sql = db.buildSQL(sql);
            sql = PortalUtil.transformSQL((String)sql);
            SqlUpdate sqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate((DataSource)dataSource, (String)sql, (ParamSetter[])new ParamSetter[0]);
            sqlUpdate.update(new Object[0]);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }
}

