/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.device.rules.service.impl;

import com.liferay.mobile.device.rules.model.MDRRule;
import com.liferay.mobile.device.rules.model.MDRRuleGroup;
import com.liferay.mobile.device.rules.service.base.MDRRuleLocalServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.UnicodeProperties;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;

@Component(property={"model.class.name=com.liferay.mobile.device.rules.model.MDRRule"}, service={AopService.class})
public class MDRRuleLocalServiceImpl
extends MDRRuleLocalServiceBaseImpl {
    public MDRRule addRule(long ruleGroupId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String type, String typeSettings, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        MDRRuleGroup ruleGroup = this.mdrRuleGroupPersistence.findByPrimaryKey(ruleGroupId);
        long ruleId = this.counterLocalService.increment();
        MDRRule rule = this.mdrRulePersistence.create(ruleId);
        rule.setUuid(serviceContext.getUuid());
        rule.setGroupId(ruleGroup.getGroupId());
        rule.setCompanyId(serviceContext.getCompanyId());
        rule.setUserId(user.getUserId());
        rule.setUserName(user.getFullName());
        rule.setRuleGroupId(ruleGroupId);
        rule.setNameMap(nameMap);
        rule.setDescriptionMap(descriptionMap);
        rule.setType(type);
        rule.setTypeSettings(typeSettings);
        rule = this.updateMDRRule(rule);
        ruleGroup.setModifiedDate(new Date());
        this.mdrRuleGroupPersistence.update((BaseModel)ruleGroup);
        return rule;
    }

    public MDRRule addRule(long ruleGroupId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String type, UnicodeProperties typeSettingsProperties, ServiceContext serviceContext) throws PortalException {
        return this.addRule(ruleGroupId, nameMap, descriptionMap, type, typeSettingsProperties.toString(), serviceContext);
    }

    public MDRRule copyRule(long ruleId, long ruleGroupId, ServiceContext serviceContext) throws PortalException {
        MDRRule rule = this.mdrRulePersistence.findByPrimaryKey(ruleId);
        return this.copyRule(rule, ruleGroupId, serviceContext);
    }

    public MDRRule copyRule(MDRRule rule, long ruleGroupId, ServiceContext serviceContext) throws PortalException {
        MDRRuleGroup ruleGroup = this.mdrRuleGroupPersistence.findByPrimaryKey(ruleGroupId);
        return this.addRule(ruleGroup.getRuleGroupId(), (Map<Locale, String>)rule.getNameMap(), (Map<Locale, String>)rule.getDescriptionMap(), rule.getType(), rule.getTypeSettings(), serviceContext);
    }

    public void deleteRule(long ruleId) {
        MDRRule rule = this.mdrRulePersistence.fetchByPrimaryKey(ruleId);
        if (rule != null) {
            this.mdrRuleLocalService.deleteRule(rule);
        }
    }

    @SystemEvent(type=1)
    public void deleteRule(MDRRule rule) {
        this.mdrRulePersistence.remove((BaseModel)rule);
        MDRRuleGroup ruleGroup = this.mdrRuleGroupPersistence.fetchByPrimaryKey(rule.getRuleGroupId());
        if (ruleGroup != null) {
            ruleGroup.setModifiedDate(new Date());
            this.mdrRuleGroupPersistence.update((BaseModel)ruleGroup);
        }
    }

    public void deleteRules(long ruleGroupId) {
        List rules = this.mdrRulePersistence.findByRuleGroupId(ruleGroupId);
        for (MDRRule rule : rules) {
            this.mdrRuleLocalService.deleteRule(rule);
        }
    }

    public MDRRule fetchRule(long ruleId) {
        return this.mdrRulePersistence.fetchByPrimaryKey(ruleId);
    }

    public MDRRule getRule(long ruleId) throws PortalException {
        return this.mdrRulePersistence.findByPrimaryKey(ruleId);
    }

    public List<MDRRule> getRules(long ruleGroupId) {
        return this.mdrRulePersistence.findByRuleGroupId(ruleGroupId);
    }

    public List<MDRRule> getRules(long ruleGroupId, int start, int end) {
        return this.mdrRulePersistence.findByRuleGroupId(ruleGroupId, start, end);
    }

    public List<MDRRule> getRules(long ruleGroupId, int start, int end, OrderByComparator<MDRRule> obc) {
        return this.mdrRulePersistence.findByRuleGroupId(ruleGroupId, start, end, obc);
    }

    public int getRulesCount(long ruleGroupId) {
        return this.mdrRulePersistence.countByRuleGroupId(ruleGroupId);
    }

    public MDRRule updateRule(long ruleId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String type, String typeSettings, ServiceContext serviceContext) throws PortalException {
        MDRRule rule = this.mdrRulePersistence.findByPrimaryKey(ruleId);
        rule.setNameMap(nameMap);
        rule.setDescriptionMap(descriptionMap);
        rule.setType(type);
        rule.setTypeSettings(typeSettings);
        rule = (MDRRule)this.mdrRulePersistence.update((BaseModel)rule);
        MDRRuleGroup ruleGroup = this.mdrRuleGroupPersistence.findByPrimaryKey(rule.getRuleGroupId());
        ruleGroup.setModifiedDate(serviceContext.getModifiedDate(null));
        this.mdrRuleGroupPersistence.update((BaseModel)ruleGroup);
        return rule;
    }

    public MDRRule updateRule(long ruleId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String type, UnicodeProperties typeSettingsProperties, ServiceContext serviceContext) throws PortalException {
        return this.updateRule(ruleId, nameMap, descriptionMap, type, typeSettingsProperties.toString(), serviceContext);
    }
}

