/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.device.rules.service.impl;

import com.liferay.mobile.device.rules.exception.DuplicateRuleGroupInstanceException;
import com.liferay.mobile.device.rules.model.MDRRuleGroupInstance;
import com.liferay.mobile.device.rules.service.base.MDRRuleGroupInstanceLocalServiceBaseImpl;
import com.liferay.mobile.device.rules.util.comparator.RuleGroupInstancePriorityComparator;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;

public class MDRRuleGroupInstanceLocalServiceImpl
extends MDRRuleGroupInstanceLocalServiceBaseImpl {
    public MDRRuleGroupInstance addRuleGroupInstance(long groupId, String className, long classPK, long ruleGroupId, int priority, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        long classNameId = this.classNameLocalService.getClassNameId(className);
        this.validate(classNameId, classPK, ruleGroupId);
        long ruleGroupInstanceId = this.counterLocalService.increment();
        MDRRuleGroupInstance ruleGroupInstance = this.mdrRuleGroupInstanceLocalService.createMDRRuleGroupInstance(ruleGroupInstanceId);
        ruleGroupInstance.setUuid(serviceContext.getUuid());
        ruleGroupInstance.setGroupId(groupId);
        ruleGroupInstance.setCompanyId(serviceContext.getCompanyId());
        ruleGroupInstance.setUserId(serviceContext.getUserId());
        ruleGroupInstance.setUserName(user.getFullName());
        ruleGroupInstance.setClassNameId(classNameId);
        ruleGroupInstance.setClassPK(classPK);
        ruleGroupInstance.setRuleGroupId(ruleGroupId);
        ruleGroupInstance.setPriority(priority);
        this.resourceLocalService.addModelResources((AuditedModel)ruleGroupInstance, serviceContext);
        return this.updateMDRRuleGroupInstance(ruleGroupInstance);
    }

    public MDRRuleGroupInstance addRuleGroupInstance(long groupId, String className, long classPK, long ruleGroupId, ServiceContext serviceContext) throws PortalException {
        List<MDRRuleGroupInstance> ruleGroupInstances = this.getRuleGroupInstances(className, classPK, -1, -1, (OrderByComparator<MDRRuleGroupInstance>)RuleGroupInstancePriorityComparator.INSTANCE_ASCENDING);
        int priority = 0;
        if (!ruleGroupInstances.isEmpty()) {
            MDRRuleGroupInstance highestPriorityRuleGroupInstance = ruleGroupInstances.get(ruleGroupInstances.size() - 1);
            priority = highestPriorityRuleGroupInstance.getPriority() + 1;
        }
        return this.addRuleGroupInstance(groupId, className, classPK, ruleGroupId, priority, serviceContext);
    }

    public void deleteGroupRuleGroupInstances(long groupId) {
        List ruleGroupInstances = this.mdrRuleGroupInstancePersistence.findByGroupId(groupId);
        for (MDRRuleGroupInstance ruleGroupInstance : ruleGroupInstances) {
            this.mdrRuleGroupInstanceLocalService.deleteRuleGroupInstance(ruleGroupInstance);
        }
    }

    public void deleteRuleGroupInstance(long ruleGroupInstanceId) {
        MDRRuleGroupInstance ruleGroupInstance = this.mdrRuleGroupInstancePersistence.fetchByPrimaryKey(ruleGroupInstanceId);
        this.mdrRuleGroupInstanceLocalService.deleteRuleGroupInstance(ruleGroupInstance);
    }

    @SystemEvent(action=1, type=1)
    public void deleteRuleGroupInstance(MDRRuleGroupInstance ruleGroupInstance) {
        this.mdrRuleGroupInstancePersistence.remove((BaseModel)ruleGroupInstance);
        this.mdrActionLocalService.deleteActions(ruleGroupInstance.getRuleGroupInstanceId());
        List<MDRRuleGroupInstance> mdrRuleGroupInstances = this.getRuleGroupInstances(ruleGroupInstance.getClassName(), ruleGroupInstance.getClassPK(), -1, -1, (OrderByComparator<MDRRuleGroupInstance>)RuleGroupInstancePriorityComparator.INSTANCE_ASCENDING);
        for (int i = 0; i < mdrRuleGroupInstances.size(); ++i) {
            MDRRuleGroupInstance mdrRuleGroupInstance = mdrRuleGroupInstances.get(i);
            if (mdrRuleGroupInstance.getPriority() == i) continue;
            mdrRuleGroupInstance.setPriority(i);
            this.mdrRuleGroupInstancePersistence.update((BaseModel)mdrRuleGroupInstance);
        }
    }

    public void deleteRuleGroupInstances(long ruleGroupId) {
        List ruleGroupInstances = this.mdrRuleGroupInstancePersistence.findByRuleGroupId(ruleGroupId);
        for (MDRRuleGroupInstance ruleGroupInstance : ruleGroupInstances) {
            this.mdrRuleGroupInstanceLocalService.deleteRuleGroupInstance(ruleGroupInstance);
        }
    }

    public MDRRuleGroupInstance fetchRuleGroupInstance(long ruleGroupInstanceId) {
        return this.mdrRuleGroupInstancePersistence.fetchByPrimaryKey(ruleGroupInstanceId);
    }

    public MDRRuleGroupInstance fetchRuleGroupInstance(String className, long classPK, long ruleGroupId) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.mdrRuleGroupInstancePersistence.fetchByC_C_R(classNameId, classPK, ruleGroupId);
    }

    public MDRRuleGroupInstance getRuleGroupInstance(long ruleGroupInstanceId) throws PortalException {
        return this.mdrRuleGroupInstancePersistence.findByPrimaryKey(ruleGroupInstanceId);
    }

    public MDRRuleGroupInstance getRuleGroupInstance(String className, long classPK, long ruleGroupId) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.mdrRuleGroupInstancePersistence.findByC_C_R(classNameId, classPK, ruleGroupId);
    }

    public List<MDRRuleGroupInstance> getRuleGroupInstances(long ruleGroupId) {
        return this.mdrRuleGroupInstancePersistence.findByRuleGroupId(ruleGroupId);
    }

    public List<MDRRuleGroupInstance> getRuleGroupInstances(long ruleGroupId, int start, int end) {
        return this.mdrRuleGroupInstancePersistence.findByRuleGroupId(ruleGroupId, start, end);
    }

    public List<MDRRuleGroupInstance> getRuleGroupInstances(String className, long classPK) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.mdrRuleGroupInstancePersistence.findByC_C(classNameId, classPK);
    }

    public List<MDRRuleGroupInstance> getRuleGroupInstances(String className, long classPK, int start, int end, OrderByComparator<MDRRuleGroupInstance> orderByComparator) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.mdrRuleGroupInstancePersistence.findByC_C(classNameId, classPK, start, end, orderByComparator);
    }

    public int getRuleGroupInstancesCount(long ruleGroupId) {
        return this.mdrRuleGroupInstancePersistence.countByRuleGroupId(ruleGroupId);
    }

    public int getRuleGroupInstancesCount(String className, long classPK) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.mdrRuleGroupInstancePersistence.countByC_C(classNameId, classPK);
    }

    public MDRRuleGroupInstance updateRuleGroupInstance(long ruleGroupInstanceId, int priority) throws PortalException {
        MDRRuleGroupInstance ruleGroupInstance = this.mdrRuleGroupInstancePersistence.findByPrimaryKey(ruleGroupInstanceId);
        ruleGroupInstance.setPriority(priority);
        return (MDRRuleGroupInstance)this.mdrRuleGroupInstancePersistence.update((BaseModel)ruleGroupInstance);
    }

    protected void validate(long classNameId, long classPK, long ruleGroupId) throws PortalException {
        MDRRuleGroupInstance ruleGroupInstance = this.mdrRuleGroupInstancePersistence.fetchByC_C_R(classNameId, classPK, ruleGroupId);
        if (ruleGroupInstance != null) {
            StringBundler sb = new StringBundler(7);
            sb.append("{classNameId=");
            sb.append(classNameId);
            sb.append(", classPK=");
            sb.append(classPK);
            sb.append(", ruleGroupId=");
            sb.append(ruleGroupId);
            sb.append("}");
            throw new DuplicateRuleGroupInstanceException(sb.toString());
        }
        this.mdrRuleGroupLocalService.getMDRRuleGroup(ruleGroupId);
    }
}

