/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.device.rules.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.exportimport.kernel.lar.ExportImportHelperUtil;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.mobile.device.rules.model.MDRRule;
import com.liferay.mobile.device.rules.service.MDRRuleGroupLocalService;
import com.liferay.mobile.device.rules.service.MDRRuleLocalService;
import com.liferay.mobile.device.rules.service.MDRRuleLocalServiceUtil;
import com.liferay.mobile.device.rules.service.persistence.MDRRuleGroupFinder;
import com.liferay.mobile.device.rules.service.persistence.MDRRuleGroupPersistence;
import com.liferay.mobile.device.rules.service.persistence.MDRRulePersistence;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.PersistedModelLocalServiceRegistry;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.UserPersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.io.Serializable;
import java.sql.Connection;
import java.util.List;
import javax.sql.DataSource;

public abstract class MDRRuleLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements IdentifiableOSGiService,
MDRRuleLocalService {
    @BeanReference(type=MDRRuleLocalService.class)
    protected MDRRuleLocalService mdrRuleLocalService;
    @BeanReference(type=MDRRulePersistence.class)
    protected MDRRulePersistence mdrRulePersistence;
    @ServiceReference(type=CounterLocalService.class)
    protected CounterLocalService counterLocalService;
    @ServiceReference(type=UserLocalService.class)
    protected UserLocalService userLocalService;
    @ServiceReference(type=UserPersistence.class)
    protected UserPersistence userPersistence;
    @BeanReference(type=MDRRuleGroupLocalService.class)
    protected MDRRuleGroupLocalService mdrRuleGroupLocalService;
    @BeanReference(type=MDRRuleGroupPersistence.class)
    protected MDRRuleGroupPersistence mdrRuleGroupPersistence;
    @BeanReference(type=MDRRuleGroupFinder.class)
    protected MDRRuleGroupFinder mdrRuleGroupFinder;
    private static final Log _log = LogFactoryUtil.getLog(MDRRuleLocalServiceBaseImpl.class);
    @ServiceReference(type=PersistedModelLocalServiceRegistry.class)
    protected PersistedModelLocalServiceRegistry persistedModelLocalServiceRegistry;

    @Indexable(type=IndexableType.REINDEX)
    public MDRRule addMDRRule(MDRRule mdrRule) {
        mdrRule.setNew(true);
        return (MDRRule)this.mdrRulePersistence.update((BaseModel)mdrRule);
    }

    @Transactional(enabled=false)
    public MDRRule createMDRRule(long ruleId) {
        return this.mdrRulePersistence.create(ruleId);
    }

    @Indexable(type=IndexableType.DELETE)
    public MDRRule deleteMDRRule(long ruleId) throws PortalException {
        return this.mdrRulePersistence.remove(ruleId);
    }

    @Indexable(type=IndexableType.DELETE)
    public MDRRule deleteMDRRule(MDRRule mdrRule) {
        return (MDRRule)this.mdrRulePersistence.remove((BaseModel)mdrRule);
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(MDRRule.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.mdrRulePersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.mdrRulePersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.mdrRulePersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.mdrRulePersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.mdrRulePersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public MDRRule fetchMDRRule(long ruleId) {
        return this.mdrRulePersistence.fetchByPrimaryKey(ruleId);
    }

    public MDRRule fetchMDRRuleByUuidAndGroupId(String uuid, long groupId) {
        return this.mdrRulePersistence.fetchByUUID_G(uuid, groupId);
    }

    public MDRRule getMDRRule(long ruleId) throws PortalException {
        return this.mdrRulePersistence.findByPrimaryKey(ruleId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.mdrRuleLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(MDRRule.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("ruleId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.mdrRuleLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(MDRRule.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("ruleId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.mdrRuleLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(MDRRule.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("ruleId");
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(final PortletDataContext portletDataContext) {
        ExportActionableDynamicQuery exportActionableDynamicQuery = new ExportActionableDynamicQuery(){

            public long performCount() throws PortalException {
                ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
                StagedModelType stagedModelType = this.getStagedModelType();
                long modelAdditionCount = super.performCount();
                manifestSummary.addModelAdditionCount(stagedModelType, modelAdditionCount);
                long modelDeletionCount = ExportImportHelperUtil.getModelDeletionCount((PortletDataContext)portletDataContext, (StagedModelType)stagedModelType);
                manifestSummary.addModelDeletionCount(stagedModelType, modelDeletionCount);
                return modelAdditionCount;
            }
        };
        this.initActionableDynamicQuery((ActionableDynamicQuery)exportActionableDynamicQuery);
        exportActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                portletDataContext.addDateRangeCriteria(dynamicQuery, "modifiedDate");
            }
        });
        exportActionableDynamicQuery.setCompanyId(portletDataContext.getCompanyId());
        exportActionableDynamicQuery.setGroupId(portletDataContext.getScopeGroupId());
        exportActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<MDRRule>(){

            public void performAction(MDRRule mdrRule) throws PortalException {
                StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)mdrRule);
            }
        });
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(PortalUtil.getClassNameId((String)MDRRule.class.getName())));
        return exportActionableDynamicQuery;
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        return this.mdrRuleLocalService.deleteMDRRule((MDRRule)persistedModel);
    }

    public BasePersistence<MDRRule> getBasePersistence() {
        return this.mdrRulePersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.mdrRulePersistence.findByPrimaryKey(primaryKeyObj);
    }

    public List<MDRRule> getMDRRulesByUuidAndCompanyId(String uuid, long companyId) {
        return this.mdrRulePersistence.findByUuid_C(uuid, companyId);
    }

    public List<MDRRule> getMDRRulesByUuidAndCompanyId(String uuid, long companyId, int start, int end, OrderByComparator<MDRRule> orderByComparator) {
        return this.mdrRulePersistence.findByUuid_C(uuid, companyId, start, end, orderByComparator);
    }

    public MDRRule getMDRRuleByUuidAndGroupId(String uuid, long groupId) throws PortalException {
        return this.mdrRulePersistence.findByUUID_G(uuid, groupId);
    }

    public List<MDRRule> getMDRRules(int start, int end) {
        return this.mdrRulePersistence.findAll(start, end);
    }

    public int getMDRRulesCount() {
        return this.mdrRulePersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public MDRRule updateMDRRule(MDRRule mdrRule) {
        return (MDRRule)this.mdrRulePersistence.update((BaseModel)mdrRule);
    }

    public MDRRuleLocalService getMDRRuleLocalService() {
        return this.mdrRuleLocalService;
    }

    public void setMDRRuleLocalService(MDRRuleLocalService mdrRuleLocalService) {
        this.mdrRuleLocalService = mdrRuleLocalService;
    }

    public MDRRulePersistence getMDRRulePersistence() {
        return this.mdrRulePersistence;
    }

    public void setMDRRulePersistence(MDRRulePersistence mdrRulePersistence) {
        this.mdrRulePersistence = mdrRulePersistence;
    }

    public CounterLocalService getCounterLocalService() {
        return this.counterLocalService;
    }

    public void setCounterLocalService(CounterLocalService counterLocalService) {
        this.counterLocalService = counterLocalService;
    }

    public UserLocalService getUserLocalService() {
        return this.userLocalService;
    }

    public void setUserLocalService(UserLocalService userLocalService) {
        this.userLocalService = userLocalService;
    }

    public UserPersistence getUserPersistence() {
        return this.userPersistence;
    }

    public void setUserPersistence(UserPersistence userPersistence) {
        this.userPersistence = userPersistence;
    }

    public MDRRuleGroupLocalService getMDRRuleGroupLocalService() {
        return this.mdrRuleGroupLocalService;
    }

    public void setMDRRuleGroupLocalService(MDRRuleGroupLocalService mdrRuleGroupLocalService) {
        this.mdrRuleGroupLocalService = mdrRuleGroupLocalService;
    }

    public MDRRuleGroupPersistence getMDRRuleGroupPersistence() {
        return this.mdrRuleGroupPersistence;
    }

    public void setMDRRuleGroupPersistence(MDRRuleGroupPersistence mdrRuleGroupPersistence) {
        this.mdrRuleGroupPersistence = mdrRuleGroupPersistence;
    }

    public MDRRuleGroupFinder getMDRRuleGroupFinder() {
        return this.mdrRuleGroupFinder;
    }

    public void setMDRRuleGroupFinder(MDRRuleGroupFinder mdrRuleGroupFinder) {
        this.mdrRuleGroupFinder = mdrRuleGroupFinder;
    }

    public void afterPropertiesSet() {
        this.persistedModelLocalServiceRegistry.register("com.liferay.mobile.device.rules.model.MDRRule", (PersistedModelLocalService)this.mdrRuleLocalService);
        MDRRuleLocalServiceUtil.setService((MDRRuleLocalService)this.mdrRuleLocalService);
    }

    public void destroy() {
        this.persistedModelLocalServiceRegistry.unregister("com.liferay.mobile.device.rules.model.MDRRule");
        MDRRuleLocalServiceUtil.setService(null);
    }

    public String getOSGiServiceIdentifier() {
        return MDRRuleLocalService.class.getName();
    }

    protected Class<?> getModelClass() {
        return MDRRule.class;
    }

    protected String getModelClassName() {
        return MDRRule.class.getName();
    }

    protected void runSQL(String sql) {
        DataSource dataSource = this.mdrRulePersistence.getDataSource();
        DB db = DBManagerUtil.getDB();
        Connection currentConnection = CurrentConnectionUtil.getConnection((DataSource)dataSource);
        try {
            if (currentConnection != null) {
                db.runSQL(currentConnection, new String[]{sql});
                return;
            }
            try (Connection connection = dataSource.getConnection();){
                db.runSQL(connection, new String[]{sql});
            }
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }
}

