/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.device.rules.internal.events;

import com.liferay.mobile.device.rules.action.ActionHandlerManagerUtil;
import com.liferay.mobile.device.rules.internal.MDRRuleGroupInstanceImpl;
import com.liferay.mobile.device.rules.model.MDRRuleGroupInstance;
import com.liferay.mobile.device.rules.rule.RuleGroupProcessorUtil;
import com.liferay.mobile.device.rules.service.MDRActionLocalService;
import com.liferay.portal.kernel.events.Action;
import com.liferay.portal.kernel.events.LifecycleAction;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.mobile.device.Device;
import com.liferay.portal.kernel.mobile.device.DeviceDetectionUtil;
import com.liferay.portal.kernel.mobile.device.UnknownDevice;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.TransientValue;
import com.liferay.portal.util.PropsValues;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"key=servlet.service.events.pre"}, service={LifecycleAction.class})
public class MDRServicePreAction
extends Action {
    private static final Log _log = LogFactoryUtil.getLog(MDRServicePreAction.class);
    private MDRActionLocalService _mdrActionLocalService;

    public void run(HttpServletRequest request, HttpServletResponse response) {
        block12: {
            ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            Device device = null;
            if (PropsValues.MOBILE_DEVICE_SESSION_CACHE_ENABLED) {
                HttpSession session = request.getSession();
                TransientValue transientValue = (TransientValue)session.getAttribute("DEVICE");
                if (transientValue != null) {
                    device = (Device)transientValue.getValue();
                }
                if (device == null) {
                    device = DeviceDetectionUtil.detectDevice((HttpServletRequest)request);
                    session.setAttribute("DEVICE", (Object)new TransientValue((Object)device));
                }
            } else {
                device = DeviceDetectionUtil.detectDevice((HttpServletRequest)request);
            }
            themeDisplay.setDevice(device);
            UnknownDevice unknownDevice = UnknownDevice.getInstance();
            if (device.equals(unknownDevice)) {
                return;
            }
            MDRRuleGroupInstance mdrRuleGroupInstance = null;
            try {
                mdrRuleGroupInstance = RuleGroupProcessorUtil.evaluateRuleGroups((ThemeDisplay)themeDisplay);
                if (_log.isDebugEnabled()) {
                    String logMessage = "Rule group evaluation returned rule group instance ";
                    logMessage = mdrRuleGroupInstance != null ? logMessage + mdrRuleGroupInstance.getRuleGroupInstanceId() : logMessage + "null";
                    _log.debug((Object)logMessage);
                }
            }
            catch (Exception e) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"Unable to retrieve rule group", (Throwable)e);
                }
                return;
            }
            if (mdrRuleGroupInstance == null) {
                return;
            }
            themeDisplay.setMDRRuleGroupInstance((com.liferay.mobile.device.rules.kernel.MDRRuleGroupInstance)new MDRRuleGroupInstanceImpl(mdrRuleGroupInstance));
            try {
                List mdrActions = this._mdrActionLocalService.getActions(mdrRuleGroupInstance.getRuleGroupInstanceId());
                ActionHandlerManagerUtil.applyActions((List)mdrActions, (HttpServletRequest)request, (HttpServletResponse)response);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block12;
                _log.warn((Object)"Unable to apply device profile", (Throwable)e);
            }
        }
    }

    @Reference(unbind="-")
    protected void setMDRActionLocalService(MDRActionLocalService mdrActionLocalService) {
        this._mdrActionLocalService = mdrActionLocalService;
    }
}

