/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.microsoft.translator.internal;

import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.HttpUtil;

public class MicrosoftTranslatorAuthenticator {
    private static final long _EXPIRE_TIME = 600000L;
    private static final String _URL = "https://api.cognitive.microsoft.com/sts/v1.0/issueToken";
    private static final Log _log = LogFactoryUtil.getLog(MicrosoftTranslatorAuthenticator.class);
    private String _accessToken;
    private String _error;
    private long _initTime;
    private final String _subscriptionKey;

    public MicrosoftTranslatorAuthenticator(String subscriptionKey) {
        this._subscriptionKey = subscriptionKey;
        this.init(true);
    }

    public String getAccessToken() {
        this.init(false);
        return this._accessToken;
    }

    public String getError() {
        return this._error;
    }

    public void init(boolean manual) {
        if (manual || this.isStale()) {
            this.doInit();
        }
    }

    protected void doInit() {
        block6: {
            this._accessToken = null;
            this._error = null;
            try {
                Http.Options options = new Http.Options();
                options.addHeader("Content-Length", "0");
                options.addHeader("Ocp-Apim-Subscription-Key", this._subscriptionKey);
                options.setLocation(_URL);
                options.setPost(true);
                String content = HttpUtil.URLtoString((Http.Options)options);
                Http.Response response = options.getResponse();
                int responseCode = response.getResponseCode();
                if (responseCode != 200) {
                    JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)content);
                    this._error = jsonObject.getString("message");
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)("Unable to initialize access token: " + content));
                    }
                } else {
                    this._accessToken = content;
                }
                if (_log.isInfoEnabled() && this._accessToken != null) {
                    _log.info((Object)("Access token " + this._accessToken));
                }
                this._initTime = System.currentTimeMillis();
            }
            catch (Exception exception) {
                if (!_log.isInfoEnabled()) break block6;
                _log.info((Object)"Unable to initialize authentication token", (Throwable)exception);
            }
        }
    }

    protected boolean isStale() {
        return this._initTime + 600000L <= System.currentTimeMillis();
    }
}

