/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.microblogs.internal.security.permission.resource;

import com.liferay.microblogs.model.MicroblogsEntry;
import com.liferay.microblogs.service.MicroblogsEntryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.social.kernel.service.SocialRelationLocalService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=com.liferay.microblogs.model.MicroblogsEntry"}, service={ModelResourcePermission.class})
public class MicroblogsEntryModelResourcePermission
implements ModelResourcePermission<MicroblogsEntry> {
    @Reference
    private MicroblogsEntryLocalService _microblogsEntryLocalService;
    @Reference(target="(resource.name=com.liferay.microblogs)")
    private PortletResourcePermission _portletResourcePermission;
    @Reference
    private SocialRelationLocalService _socialRelationLocalService;

    public void check(PermissionChecker permissionChecker, long primaryKey, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, primaryKey, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, MicroblogsEntry.class.getName(), primaryKey, new String[]{actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, MicroblogsEntry microblogsEntry, String actionId) throws PrincipalException {
        if (!this.contains(permissionChecker, microblogsEntry, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, MicroblogsEntry.class.getName(), microblogsEntry.getMicroblogsEntryId(), new String[]{actionId});
        }
    }

    public boolean contains(PermissionChecker permissionChecker, long microblogsEntryId, String actionId) throws PortalException {
        return this.contains(permissionChecker, this._microblogsEntryLocalService.getMicroblogsEntry(microblogsEntryId), actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, MicroblogsEntry microblogsEntry, String actionId) {
        if (actionId.equals("DELETE") || actionId.equals("UPDATE")) {
            return permissionChecker.hasOwnerPermission(microblogsEntry.getCompanyId(), MicroblogsEntry.class.getName(), microblogsEntry.getMicroblogsEntryId(), microblogsEntry.getUserId(), actionId);
        }
        if (permissionChecker.hasOwnerPermission(microblogsEntry.getCompanyId(), MicroblogsEntry.class.getName(), microblogsEntry.getMicroblogsEntryId(), microblogsEntry.getUserId(), actionId) || microblogsEntry.getSocialRelationType() == 0) {
            return true;
        }
        return microblogsEntry.getUserId() != permissionChecker.getUserId() && this._socialRelationLocalService.hasRelation(permissionChecker.getUserId(), microblogsEntry.getUserId(), microblogsEntry.getSocialRelationType());
    }

    public String getModelName() {
        return MicroblogsEntry.class.getName();
    }

    public PortletResourcePermission getPortletResourcePermission() {
        return this._portletResourcePermission;
    }
}

