/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.microblogs.internal.upgrade.v1_0_2;

import com.liferay.microblogs.internal.upgrade.v1_0_2.util.MicroblogsEntryTable;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;

public class MicroblogsEntryUpgradeProcess
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        this.removeReceiverUserId();
        this.renameReceiverMicroblogsEntryId();
    }

    protected void removeReceiverUserId() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            if (!this.hasColumn("MicroblogsEntry", "receiverUserId")) {
                return;
            }
            this.alter(MicroblogsEntryTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableDropColumn((UpgradeProcess)this, "receiverUserId")});
        }
    }

    protected void renameReceiverMicroblogsEntryId() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            if (!this.hasColumn("MicroblogsEntry", "receiverMicroblogsEntryId")) {
                return;
            }
            this.alter(MicroblogsEntryTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableAddColumn((UpgradeProcess)this, "parentMicroblogsEntryId", "LONG")});
            this.runSQL("update MicroblogsEntry set parentMicroblogsEntryId = receiverMicroblogsEntryId");
            this.alter(MicroblogsEntryTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableDropColumn((UpgradeProcess)this, "receiverMicroblogsEntryId")});
        }
    }
}

