/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.microblogs.service.impl;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.microblogs.exception.UnsupportedMicroblogsEntryException;
import com.liferay.microblogs.internal.util.MicroblogsUtil;
import com.liferay.microblogs.model.MicroblogsEntry;
import com.liferay.microblogs.service.base.MicroblogsEntryLocalServiceBaseImpl;
import com.liferay.microblogs.util.comparator.EntryCreateDateComparator;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.process.ProcessCallable;
import com.liferay.portal.kernel.process.ProcessException;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserNotificationEventLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.social.kernel.service.SocialActivityLocalService;
import com.liferay.subscription.model.Subscription;
import com.liferay.subscription.service.SubscriptionLocalService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.microblogs.model.MicroblogsEntry"}, service={AopService.class})
public class MicroblogsEntryLocalServiceImpl
extends MicroblogsEntryLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(MicroblogsEntryLocalServiceImpl.class);
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private MessageBus _messageBus;
    @Reference
    private SocialActivityLocalService _socialActivityLocalService;
    @Reference
    private SubscriptionLocalService _subscriptionLocalService;
    @Reference
    private UserNotificationEventLocalService _userNotificationEventLocalService;

    public MicroblogsEntry addMicroblogsEntry(long userId, long creatorClassNameId, long creatorClassPK, String content, int type, long parentMicroblogsEntryId, int socialRelationType, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        Date date = new Date();
        this.validate(type, parentMicroblogsEntryId);
        long microblogsEntryId = this.counterLocalService.increment();
        if (parentMicroblogsEntryId == 0L) {
            parentMicroblogsEntryId = microblogsEntryId;
        }
        MicroblogsEntry microblogsEntry = this.microblogsEntryPersistence.create(microblogsEntryId);
        microblogsEntry.setCompanyId(user.getCompanyId());
        microblogsEntry.setUserId(user.getUserId());
        microblogsEntry.setUserName(user.getFullName());
        microblogsEntry.setCreateDate(date);
        microblogsEntry.setModifiedDate(date);
        microblogsEntry.setCreatorClassNameId(creatorClassNameId);
        microblogsEntry.setCreatorClassPK(creatorClassPK);
        microblogsEntry.setContent(content);
        microblogsEntry.setType(type);
        microblogsEntry.setParentMicroblogsEntryId(parentMicroblogsEntryId);
        microblogsEntry.setSocialRelationType(socialRelationType);
        microblogsEntry = (MicroblogsEntry)this.microblogsEntryPersistence.update((BaseModel)microblogsEntry);
        this.resourceLocalService.addModelResources((AuditedModel)microblogsEntry, serviceContext);
        this.updateAsset(microblogsEntry, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames());
        return microblogsEntry;
    }

    public MicroblogsEntry addMicroblogsEntry(long userId, String content, int type, long parentMicroblogsEntryId, int socialRelationType, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        Date date = new Date();
        this.validate(type, parentMicroblogsEntryId);
        long microblogsEntryId = this.counterLocalService.increment();
        if (parentMicroblogsEntryId == 0L) {
            parentMicroblogsEntryId = microblogsEntryId;
        }
        MicroblogsEntry microblogsEntry = this.microblogsEntryPersistence.create(microblogsEntryId);
        microblogsEntry.setCompanyId(user.getCompanyId());
        microblogsEntry.setUserId(user.getUserId());
        microblogsEntry.setUserName(user.getFullName());
        microblogsEntry.setCreateDate(date);
        microblogsEntry.setModifiedDate(date);
        microblogsEntry.setCreatorClassNameId(this.classNameLocalService.getClassNameId(User.class));
        microblogsEntry.setCreatorClassPK(user.getUserId());
        microblogsEntry.setContent(content);
        microblogsEntry.setType(type);
        microblogsEntry.setParentMicroblogsEntryId(parentMicroblogsEntryId);
        microblogsEntry.setSocialRelationType(socialRelationType);
        microblogsEntry = (MicroblogsEntry)this.microblogsEntryPersistence.update((BaseModel)microblogsEntry);
        this.resourceLocalService.addModelResources((AuditedModel)microblogsEntry, serviceContext);
        this.updateAsset(microblogsEntry, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames());
        int activityKey = 1;
        if (type == 1) {
            activityKey = 3;
        } else if (type == 2) {
            activityKey = 2;
        }
        this._socialActivityLocalService.addActivity(userId, 0L, MicroblogsEntry.class.getName(), microblogsEntryId, activityKey, JSONUtil.put((String)"content", (Object)microblogsEntry.getContent()).put("parentMicroblogsEntryId", parentMicroblogsEntryId).toString(), microblogsEntry.getParentMicroblogsEntryUserId());
        this.subscribeUsers(microblogsEntry, serviceContext);
        this.sendNotificationEvent(microblogsEntry, serviceContext);
        return microblogsEntry;
    }

    public void deleteMicroblogsEntries(long creatorClassNameId, long creatorClassPK) throws PortalException {
        this.microblogsEntryPersistence.removeByCCNI_CCPK(creatorClassNameId, creatorClassPK);
    }

    @Override
    public MicroblogsEntry deleteMicroblogsEntry(long microblogsEntryId) throws PortalException {
        MicroblogsEntry microblogsEntry = this.microblogsEntryPersistence.findByPrimaryKey(microblogsEntryId);
        return this.deleteMicroblogsEntry(microblogsEntry);
    }

    @Override
    @SystemEvent(type=1)
    public MicroblogsEntry deleteMicroblogsEntry(MicroblogsEntry microblogsEntry) throws PortalException {
        ArrayList<MicroblogsEntry> microblogsEntries = new ArrayList<MicroblogsEntry>();
        microblogsEntries.add(microblogsEntry);
        microblogsEntries.addAll(this._getAllRelatedMicroblogsEntries(microblogsEntry.getMicroblogsEntryId()));
        for (MicroblogsEntry curMicroblogsEntry : microblogsEntries) {
            this.microblogsEntryPersistence.remove((BaseModel)curMicroblogsEntry);
            this.resourceLocalService.deleteResource(curMicroblogsEntry.getCompanyId(), MicroblogsEntry.class.getName(), 4, curMicroblogsEntry.getMicroblogsEntryId());
            this._assetEntryLocalService.deleteEntry(MicroblogsEntry.class.getName(), curMicroblogsEntry.getMicroblogsEntryId());
            this._socialActivityLocalService.deleteActivities(MicroblogsEntry.class.getName(), curMicroblogsEntry.getMicroblogsEntryId());
        }
        return microblogsEntry;
    }

    public void deleteUserMicroblogsEntries(long userId) throws PortalException {
        List microblogsEntries = this.microblogsEntryPersistence.findByUserId(userId);
        for (MicroblogsEntry microblogsEntry : microblogsEntries) {
            this.deleteMicroblogsEntry(microblogsEntry);
        }
    }

    public List<MicroblogsEntry> getCompanyMicroblogsEntries(long companyId, int start, int end) {
        return this.microblogsEntryPersistence.findByCompanyId(companyId, start, end);
    }

    public int getCompanyMicroblogsEntriesCount(long companyId) {
        return this.microblogsEntryPersistence.countByCompanyId(companyId);
    }

    public List<MicroblogsEntry> getMicroblogsEntries(long companyId, long creatorClassNameId, int type, int start, int end, OrderByComparator<MicroblogsEntry> orderByComparator) {
        return this.microblogsEntryPersistence.findByC_CCNI_T(companyId, creatorClassNameId, type, start, end, orderByComparator);
    }

    public List<MicroblogsEntry> getMicroblogsEntries(long companyId, long creatorClassNameId, long creatorClassPK, int start, int end) {
        return this.microblogsEntryPersistence.findByC_CCNI_CCPK(companyId, creatorClassNameId, creatorClassPK, start, end);
    }

    public List<MicroblogsEntry> getMicroblogsEntries(long companyId, long creatorClassNameId, long creatorClassPK, int type, int start, int end) {
        return this.microblogsEntryPersistence.findByC_CCNI_CCPK_T(companyId, creatorClassNameId, creatorClassPK, type, start, end);
    }

    public List<MicroblogsEntry> getMicroblogsEntries(long companyId, long creatorClassNameId, long creatorClassPK, String assetTagName, boolean andOperator, int start, int end) {
        return this.microblogsEntryFinder.findByC_CCNI_CCPK_ATN(companyId, creatorClassNameId, creatorClassPK, assetTagName, andOperator, start, end);
    }

    public int getMicroblogsEntriesCount(long companyId, long creatorClassNameId, long creatorClassPK) {
        return this.microblogsEntryPersistence.countByC_CCNI_CCPK(companyId, creatorClassNameId, creatorClassPK);
    }

    public int getMicroblogsEntriesCount(long companyId, long creatorClassNameId, long creatorClassPK, int type) {
        return this.microblogsEntryPersistence.countByC_CCNI_CCPK_T(companyId, creatorClassNameId, creatorClassPK, type);
    }

    public int getMicroblogsEntriesCount(long companyId, long creatorClassNameId, long creatorClassPK, String assetTagName, boolean andOperator) {
        return this.microblogsEntryFinder.countByC_CCNI_CCPK_ATN(companyId, creatorClassNameId, creatorClassPK, assetTagName, andOperator);
    }

    public int getMicroblogsEntriesCount(long companyId, long creatorClassNameId, String assetTagName) {
        return this.microblogsEntryFinder.countByC_CCNI_ATN(companyId, creatorClassNameId, assetTagName);
    }

    @Override
    public MicroblogsEntry getMicroblogsEntry(long microblogsEntryId) throws PortalException {
        return this.microblogsEntryPersistence.findByPrimaryKey(microblogsEntryId);
    }

    public List<MicroblogsEntry> getParentMicroblogsEntryMicroblogsEntries(int type, long parentMicroblogsEntryId, int start, int end) {
        return this.microblogsEntryPersistence.findByT_P(type, parentMicroblogsEntryId, start, end, (OrderByComparator)new EntryCreateDateComparator(true));
    }

    public List<MicroblogsEntry> getParentMicroblogsEntryMicroblogsEntries(int type, long parentMicroblogsEntryId, int start, int end, OrderByComparator<MicroblogsEntry> orderByComparator) {
        return this.microblogsEntryPersistence.findByT_P(type, parentMicroblogsEntryId, start, end, orderByComparator);
    }

    public int getParentMicroblogsEntryMicroblogsEntriesCount(int type, long parentMicroblogsEntryId) {
        return this.microblogsEntryPersistence.countByT_P(type, parentMicroblogsEntryId);
    }

    public List<MicroblogsEntry> getUserMicroblogsEntries(long userId, int start, int end) {
        return this.microblogsEntryPersistence.findByUserId(userId, start, end);
    }

    public List<MicroblogsEntry> getUserMicroblogsEntries(long userId, int type, int start, int end) {
        return this.microblogsEntryPersistence.findByU_T(userId, type, start, end);
    }

    public int getUserMicroblogsEntriesCount(long userId) {
        return this.microblogsEntryPersistence.countByUserId(userId);
    }

    public int getUserMicroblogsEntriesCount(long userId, int type) {
        return this.microblogsEntryPersistence.countByU_T(userId, type);
    }

    public void updateAsset(MicroblogsEntry microblogsEntry, long[] assetCategoryIds, String[] assetTagNames) throws PortalException {
        Group group = this._groupLocalService.getCompanyGroup(microblogsEntry.getCompanyId());
        this._assetEntryLocalService.updateEntry(microblogsEntry.getUserId(), group.getGroupId(), MicroblogsEntry.class.getName(), microblogsEntry.getMicroblogsEntryId(), assetCategoryIds, assetTagNames);
    }

    public MicroblogsEntry updateMicroblogsEntry(long microblogsEntryId, String content, int socialRelationType, ServiceContext serviceContext) throws PortalException {
        MicroblogsEntry microblogsEntry = this.microblogsEntryPersistence.findByPrimaryKey(microblogsEntryId);
        microblogsEntry.setModifiedDate(new Date());
        microblogsEntry.setContent(content);
        microblogsEntry.setSocialRelationType(socialRelationType);
        microblogsEntry = (MicroblogsEntry)this.microblogsEntryPersistence.update((BaseModel)microblogsEntry);
        this.updateAsset(microblogsEntry, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames());
        return microblogsEntry;
    }

    protected long getSubscriptionId(long userId, MicroblogsEntry microblogsEntry) {
        try {
            Subscription subscription = this._subscriptionLocalService.getSubscription(microblogsEntry.getCompanyId(), userId, MicroblogsEntry.class.getName(), microblogsEntry.getParentMicroblogsEntryId());
            return subscription.getSubscriptionId();
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)portalException);
            }
            return 0L;
        }
    }

    protected void sendNotificationEvent(final MicroblogsEntry microblogsEntry, ServiceContext serviceContext) throws PortalException {
        String entryURL;
        block2: {
            AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClass(MicroblogsEntry.class);
            AssetRenderer assetRenderer = assetRendererFactory.getAssetRenderer(microblogsEntry.getMicroblogsEntryId());
            entryURL = "";
            try {
                entryURL = assetRenderer.getURLViewInContext(serviceContext.getLiferayPortletRequest(), serviceContext.getLiferayPortletResponse(), null);
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Throwable)exception);
            }
        }
        final JSONObject notificationEventJSONObject = JSONUtil.put((String)"className", (Object)MicroblogsEntry.class.getName()).put("classPK", microblogsEntry.getMicroblogsEntryId()).put("entryTitle", MicroblogsUtil.getProcessedContent(StringUtil.shorten((String)microblogsEntry.getContent(), (int)50), serviceContext)).put("entryURL", entryURL).put("userId", microblogsEntry.getUserId());
        final List<Long> receiverUserIds = MicroblogsUtil.getSubscriberUserIds(microblogsEntry);
        Callable<Void> callable = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Message message = new Message();
                message.setPayload((Object)new NotificationProcessCallable(receiverUserIds, microblogsEntry, notificationEventJSONObject));
                MicroblogsEntryLocalServiceImpl.this._messageBus.sendMessage("liferay/async_service", message);
                return null;
            }
        };
        TransactionCommitCallbackUtil.registerCallback((Callable)callable);
    }

    protected void subscribeUsers(MicroblogsEntry microblogsEntry, ServiceContext serviceContext) throws PortalException {
        long rootMicroblogsEntryId = MicroblogsUtil.getRootMicroblogsEntryId(microblogsEntry);
        this._subscriptionLocalService.addSubscription(microblogsEntry.getUserId(), serviceContext.getScopeGroupId(), MicroblogsEntry.class.getName(), rootMicroblogsEntryId);
        List<String> screenNames = MicroblogsUtil.getScreenNames(microblogsEntry.getContent());
        for (String screenName : screenNames) {
            long userId = this.userLocalService.getUserIdByScreenName(serviceContext.getCompanyId(), screenName);
            this._subscriptionLocalService.addSubscription(userId, serviceContext.getScopeGroupId(), MicroblogsEntry.class.getName(), rootMicroblogsEntryId);
        }
    }

    protected void validate(int type, long parentMicroblogsEntryId) throws PortalException {
        if (parentMicroblogsEntryId == 0L) {
            return;
        }
        MicroblogsEntry microblogsEntry = this.microblogsEntryPersistence.findByPrimaryKey(parentMicroblogsEntryId);
        if (microblogsEntry.getSocialRelationType() == 0) {
            return;
        }
        if (type == 2) {
            throw new UnsupportedMicroblogsEntryException();
        }
    }

    private List<MicroblogsEntry> _getAllRelatedMicroblogsEntries(long microblogsEntryId) {
        ArrayList<MicroblogsEntry> microblogsEntries = new ArrayList<MicroblogsEntry>();
        microblogsEntries.addAll(this.microblogsEntryPersistence.findByT_P(1, microblogsEntryId));
        List repostMicroblogsEntries = this.microblogsEntryPersistence.findByT_P(2, microblogsEntryId);
        for (MicroblogsEntry microblogsEntry : repostMicroblogsEntries) {
            microblogsEntries.add(microblogsEntry);
            microblogsEntries.addAll(this._getAllRelatedMicroblogsEntries(microblogsEntry.getMicroblogsEntryId()));
        }
        return microblogsEntries;
    }

    private class NotificationProcessCallable
    implements ProcessCallable<Serializable> {
        private static final long serialVersionUID = 1L;
        private final MicroblogsEntry _microblogsEntry;
        private final JSONObject _notificationEventJSONObject;
        private final List<Long> _receiverUserIds;

        public NotificationProcessCallable(List<Long> receiverUserIds, MicroblogsEntry microblogsEntry, JSONObject notificationEventJSONObject) {
            this._receiverUserIds = receiverUserIds;
            this._microblogsEntry = microblogsEntry;
            this._notificationEventJSONObject = notificationEventJSONObject;
        }

        public Serializable call() throws ProcessException {
            try {
                this.sendUserNotifications(this._receiverUserIds, this._microblogsEntry, this._notificationEventJSONObject);
            }
            catch (Exception exception) {
                throw new ProcessException((Throwable)exception);
            }
            return null;
        }

        protected void sendUserNotifications(List<Long> receiverUserIds, MicroblogsEntry microblogsEntry, JSONObject notificationEventJSONObject) throws PortalException {
            int count = receiverUserIds.size();
            int pages = count / 10000;
            for (int i = 0; i <= pages; ++i) {
                int start = i * 10000;
                int end = start + 10000;
                if (count < end) {
                    end = count;
                }
                for (int j = start; j < end; ++j) {
                    notificationEventJSONObject.put("subscriptionId", MicroblogsEntryLocalServiceImpl.this.getSubscriptionId(receiverUserIds.get(j), microblogsEntry));
                    int notificationType = MicroblogsUtil.getNotificationType(microblogsEntry, receiverUserIds.get(j), 10005);
                    if (notificationType != -1) {
                        notificationEventJSONObject.put("notificationType", notificationType);
                        MicroblogsEntryLocalServiceImpl.this._userNotificationEventLocalService.sendUserNotificationEvents(receiverUserIds.get(j).longValue(), "com_liferay_microblogs_web_portlet_MicroblogsPortlet", 10005, notificationEventJSONObject);
                    }
                    if ((notificationType = MicroblogsUtil.getNotificationType(microblogsEntry, receiverUserIds.get(j), 10002)) == -1) continue;
                    notificationEventJSONObject.put("notificationType", notificationType);
                    MicroblogsEntryLocalServiceImpl.this._userNotificationEventLocalService.sendUserNotificationEvents(receiverUserIds.get(j).longValue(), "com_liferay_microblogs_web_portlet_MicroblogsPortlet", 10002, notificationEventJSONObject);
                }
            }
        }
    }
}

