/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.microblogs.internal.upgrade.v1_0_2;

import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;

public class MicroblogsEntryUpgradeProcess
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        this._removeReceiverUserId();
        this._renameReceiverMicroblogsEntryId();
    }

    private void _removeReceiverUserId() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            if (!this.hasColumn("MicroblogsEntry", "receiverUserId")) {
                return;
            }
            this.alterTableDropColumn("MicroblogsEntry", "receiverUserId");
        }
    }

    private void _renameReceiverMicroblogsEntryId() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            if (!this.hasColumn("MicroblogsEntry", "receiverMicroblogsEntryId")) {
                return;
            }
            this.alterTableAddColumn("MicroblogsEntry", "parentMicroblogsEntryId", "LONG");
            this.runSQL("update MicroblogsEntry set parentMicroblogsEntryId = receiverMicroblogsEntryId");
            this.alterTableDropColumn("MicroblogsEntry", "receiverMicroblogsEntryId");
        }
    }
}

