/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.microblogs.service.permission;

import com.liferay.microblogs.model.MicroblogsEntry;
import com.liferay.microblogs.service.MicroblogsEntryLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.social.kernel.service.SocialRelationLocalServiceUtil;

public class MicroblogsEntryPermission {
    public static void check(PermissionChecker permissionChecker, long microblogsEntryId, String actionId) throws PortalException {
        if (!MicroblogsEntryPermission.contains(permissionChecker, microblogsEntryId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, MicroblogsEntry microblogsEntry, String actionId) throws PortalException {
        if (!MicroblogsEntryPermission.contains(permissionChecker, microblogsEntry, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long microblogsEntryId, String actionId) throws PortalException {
        MicroblogsEntry microblogsEntry = MicroblogsEntryLocalServiceUtil.getMicroblogsEntry((long)microblogsEntryId);
        return MicroblogsEntryPermission.contains(permissionChecker, microblogsEntry, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, MicroblogsEntry microblogsEntry, String actionId) {
        if (actionId.equals("DELETE") || actionId.equals("UPDATE")) {
            return permissionChecker.hasOwnerPermission(microblogsEntry.getCompanyId(), MicroblogsEntry.class.getName(), microblogsEntry.getMicroblogsEntryId(), microblogsEntry.getUserId(), actionId);
        }
        if (permissionChecker.hasOwnerPermission(microblogsEntry.getCompanyId(), MicroblogsEntry.class.getName(), microblogsEntry.getMicroblogsEntryId(), microblogsEntry.getUserId(), actionId)) {
            return true;
        }
        if (microblogsEntry.getSocialRelationType() == 0) {
            return true;
        }
        return microblogsEntry.getUserId() != permissionChecker.getUserId() && SocialRelationLocalServiceUtil.hasRelation((long)permissionChecker.getUserId(), (long)microblogsEntry.getUserId(), (int)microblogsEntry.getSocialRelationType());
    }
}

