/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.microblogs.service.impl;

import com.liferay.microblogs.model.MicroblogsEntry;
import com.liferay.microblogs.service.base.MicroblogsEntryServiceBaseImpl;
import com.liferay.microblogs.service.permission.MicroblogsEntryPermission;
import com.liferay.microblogs.service.permission.MicroblogsPermission;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import java.util.List;

public class MicroblogsEntryServiceImpl
extends MicroblogsEntryServiceBaseImpl {
    public MicroblogsEntry addMicroblogsEntry(long userId, String content, int type, long parentMicroblogsEntryId, int socialRelationType, ServiceContext serviceContext) throws PortalException {
        MicroblogsPermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), "ADD_ENTRY");
        return this.microblogsEntryLocalService.addMicroblogsEntry(userId, content, type, parentMicroblogsEntryId, socialRelationType, serviceContext);
    }

    public MicroblogsEntry deleteMicroblogsEntry(long microblogsEntryId) throws PortalException {
        MicroblogsEntryPermission.check(this.getPermissionChecker(), microblogsEntryId, "DELETE");
        return this.microblogsEntryLocalService.deleteMicroblogsEntry(microblogsEntryId);
    }

    public List<MicroblogsEntry> getMicroblogsEntries(int start, int end) throws PortalException {
        User user = this.getGuestOrUser();
        return this.microblogsEntryFinder.findByC_U(user.getCompanyId(), user.getUserId(), start, end);
    }

    public List<MicroblogsEntry> getMicroblogsEntries(String assetTagName, int start, int end) throws PortalException {
        User user = this.getGuestOrUser();
        return this.microblogsEntryFinder.findByC_U_ATN(user.getCompanyId(), user.getUserId(), assetTagName, start, end);
    }

    public int getMicroblogsEntriesCount() throws PortalException {
        User user = this.getGuestOrUser();
        return this.microblogsEntryFinder.countByC_U(user.getCompanyId(), user.getUserId());
    }

    public int getMicroblogsEntriesCount(String assetTagName) throws PortalException {
        User user = this.getGuestOrUser();
        return this.microblogsEntryFinder.countByC_U_ATN(user.getCompanyId(), user.getUserId(), assetTagName);
    }

    public MicroblogsEntry getMicroblogsEntry(long microblogsEntryId) throws PortalException {
        MicroblogsEntryPermission.check(this.getPermissionChecker(), microblogsEntryId, "VIEW");
        return this.microblogsEntryLocalService.getMicroblogsEntry(microblogsEntryId);
    }

    public List<MicroblogsEntry> getUserMicroblogsEntries(long microblogsEntryUserId, int start, int end) throws PortalException {
        return this.microblogsEntryFinder.findByU_MU(this.getGuestOrUserId(), microblogsEntryUserId, start, end);
    }

    public List<MicroblogsEntry> getUserMicroblogsEntries(long microblogsEntryUserId, int type, int start, int end) throws PortalException {
        return this.microblogsEntryFinder.findByU_T_MU(this.getGuestOrUserId(), type, microblogsEntryUserId, start, end);
    }

    public int getUserMicroblogsEntriesCount(long microblogsEntryUserId) throws PortalException {
        return this.microblogsEntryFinder.countByU_MU(this.getGuestOrUserId(), microblogsEntryUserId);
    }

    public int getUserMicroblogsEntriesCount(long microblogsEntryUserId, int type) throws PortalException {
        return this.microblogsEntryFinder.countByU_T_MU(this.getGuestOrUserId(), type, microblogsEntryUserId);
    }

    public MicroblogsEntry updateMicroblogsEntry(long microblogsEntryId, String content, int socialRelationType, ServiceContext serviceContext) throws PortalException {
        MicroblogsEntryPermission.check(this.getPermissionChecker(), microblogsEntryId, "UPDATE");
        return this.microblogsEntryLocalService.updateMicroblogsEntry(microblogsEntryId, content, socialRelationType, serviceContext);
    }
}

