/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.microblogs.upgrade.v1_0_1;

import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class UpgradeUserNotificationEvent
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        this.upgradeNotifications();
    }

    protected void updateNotification(long userNotificationEventId, JSONObject jsonObject) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement("update UserNotificationEvent set payload = ? where userNotificationEventId = ?");){
            ps.setString(1, jsonObject.toString());
            ps.setLong(2, userNotificationEventId);
            ps.executeUpdate();
        }
    }

    protected void upgradeNotifications() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps = this.connection.prepareStatement("select userNotificationEventId, payload from UserNotificationEvent where type_ = ?");){
            ps.setString(1, "com_liferay_microblogs_web_portlet_MicroblogsPortlet");
            try (ResultSet rs = ps.executeQuery();){
                while (true) {
                    if (rs.next()) {
                        long userNotificationEventId = rs.getLong("userNotificationEventId");
                        String payload = rs.getString("payload");
                        JSONObject payloadJSONObject = JSONFactoryUtil.createJSONObject((String)payload);
                        int notificationType = payloadJSONObject.getInt("notificationType");
                        if (notificationType != 0) {
                            return;
                        }
                        payloadJSONObject.put("notificationType", 0);
                        this.updateNotification(userNotificationEventId, payloadJSONObject);
                        continue;
                    }
                    break;
                }
            }
        }
    }
}

