/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.microblogs.upgrade.v1_0_2;

import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;

public class UpgradeMicroblogsEntry
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        this.removeReceiverUserId();
        this.renameReceiverMicroblogsEntryId();
    }

    protected void removeReceiverUserId() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            if (!this.hasColumn("MicroblogsEntry", "receiverUserId")) {
                return;
            }
            this.runSQL("alter table MicroblogsEntry drop column receiverUserId");
            this.runSQL("drop index IX_7ABB0AB3 on MicroblogsEntry");
        }
    }

    protected void renameReceiverMicroblogsEntryId() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            if (!this.hasColumn("MicroblogsEntry", "receiverMicroblogsEntryId")) {
                return;
            }
            this.runSQL("alter table MicroblogsEntry add parentMicroblogsEntryId LONG");
            this.runSQL("update MicroblogsEntry set parentMicroblogsEntryId = receiverMicroblogsEntryId");
            this.runSQL("alter table MicroblogsEntry drop column receiverMicroblogsEntryId");
            this.runSQL("create index IX_6BD29B9C on MicroblogsEntry (type_, parentMicroblogsEntryId)");
            this.runSQL("drop index IX_36CA3D37 on MicroblogsEntry");
        }
    }
}

