/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.moderation.internal.upgrade.v1_0_0;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.workflow.WorkflowDefinition;
import com.liferay.portal.kernel.workflow.WorkflowException;
import com.liferay.portal.workflow.manager.WorkflowDefinitionManager;

public class MBModerationWorkflowDefinitionUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(MBModerationWorkflowDefinitionUpgradeProcess.class);
    private final CompanyLocalService _companyLocalService;
    private final WorkflowDefinitionManager _workflowDefinitionManager;

    public MBModerationWorkflowDefinitionUpgradeProcess(CompanyLocalService companyLocalService, WorkflowDefinitionManager workflowDefinitionManager) {
        this._companyLocalService = companyLocalService;
        this._workflowDefinitionManager = workflowDefinitionManager;
    }

    protected void doUpgrade() throws Exception {
        this._companyLocalService.forEachCompanyId(companyId -> this.updateMBModerationWorkflowDefinition((long)companyId));
    }

    protected void updateMBModerationWorkflowDefinition(long companyId) throws Exception {
        block3: {
            int workflowDefinitionsCount = this._workflowDefinitionManager.getWorkflowDefinitionsCount(companyId, "Message Boards User Stats Moderation");
            if (workflowDefinitionsCount == 0) {
                return;
            }
            WorkflowDefinition latestWorkflowDefinition = this._workflowDefinitionManager.liberalGetLatestWorkflowDefinition(companyId, "Message Boards User Stats Moderation");
            String content = StringUtil.read(MBModerationWorkflowDefinitionUpgradeProcess.class, (String)"dependencies/message-boards-moderation-workflow-definition.xml");
            try {
                this._workflowDefinitionManager.deployWorkflowDefinition(null, companyId, latestWorkflowDefinition.getUserId(), latestWorkflowDefinition.getTitle(), latestWorkflowDefinition.getName(), latestWorkflowDefinition.getScope(), content.getBytes());
            }
            catch (WorkflowException workflowException) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Object)("Unable to upgrade workflow definition with name " + latestWorkflowDefinition.getName()), (Throwable)workflowException);
            }
        }
    }
}

