/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.moderation.internal.kaleo.runtime.condition;

import com.liferay.message.boards.moderation.configuration.MBModerationGroupConfiguration;
import com.liferay.message.boards.service.MBStatsUserLocalService;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.workflow.kaleo.model.KaleoCondition;
import com.liferay.portal.workflow.kaleo.runtime.ExecutionContext;
import com.liferay.portal.workflow.kaleo.runtime.condition.ConditionEvaluator;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"scripting.language=java"}, service={ConditionEvaluator.class})
public class MBModerationConditionEvaluator
implements ConditionEvaluator {
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private MBStatsUserLocalService _mbStatsUserLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public String evaluate(KaleoCondition kaleoCondition, ExecutionContext executionContext) throws PortalException {
        Map workflowContext = executionContext.getWorkflowContext();
        long groupId = GetterUtil.getLong(workflowContext.get("groupId"));
        MBModerationGroupConfiguration mbModerationGroupConfiguration = (MBModerationGroupConfiguration)this._configurationProvider.getGroupConfiguration(MBModerationGroupConfiguration.class, kaleoCondition.getCompanyId(), groupId);
        long userId = GetterUtil.getLong(workflowContext.get("userId"));
        if (this._mbStatsUserLocalService.getMessageCountByUserId(userId) >= (long)mbModerationGroupConfiguration.minimumContributedMessages()) {
            return "approve";
        }
        User user = this._userLocalService.getUser(userId);
        for (String authorizedDomainName : mbModerationGroupConfiguration.authorizedDomainNames()) {
            if (!Validator.isNotNull((String)authorizedDomainName) || !StringUtil.endsWith((String)user.getEmailAddress(), (String)("@" + authorizedDomainName))) continue;
            return "approve";
        }
        return "review";
    }
}

