/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.moderation.internal.instance.lifecycle;

import com.liferay.message.boards.model.MBMessage;
import com.liferay.portal.instance.lifecycle.InitialRequestPortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Localization;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.workflow.manager.WorkflowDefinitionManager;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={PortalInstanceLifecycleListener.class})
public class AddMBModerationWorkflowDefinitionInitialRequestPortalInstanceLifecycleListener
extends InitialRequestPortalInstanceLifecycleListener {
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private Language _language;
    @Reference
    private Localization _localization;
    @Reference
    private UserLocalService _userLocalService;
    @Reference
    private WorkflowDefinitionManager _workflowDefinitionManager;

    @Activate
    protected void activate(BundleContext bundleContext) {
        super.activate(bundleContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPortalInstanceRegistered(long companyId) throws Exception {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        PermissionThreadLocal.setPermissionChecker(null);
        try {
            int workflowDefinitionsCount = this._workflowDefinitionManager.getWorkflowDefinitionsCount(companyId, "message-boards-user-stats-moderation");
            if (workflowDefinitionsCount > 0) {
                return;
            }
            long guestUserId = this._userLocalService.getGuestUserId(companyId);
            Company company = this._companyLocalService.getCompany(companyId);
            String content = StringUtil.read(AddMBModerationWorkflowDefinitionInitialRequestPortalInstanceLifecycleListener.class, (String)"dependencies/message-boards-moderation-workflow-definition.xml");
            this._workflowDefinitionManager.deployWorkflowDefinition(null, companyId, guestUserId, this._localization.getXml(this._getTitleMap(companyId), this._language.getLanguageId(company.getLocale()), "title"), "message-boards-user-stats-moderation", MBMessage.class.getName(), content.getBytes());
        }
        finally {
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
        }
    }

    private Map<String, String> _getTitleMap(long companyId) {
        HashMap<String, String> titleMap = new HashMap<String, String>();
        for (Locale locale : this._language.getCompanyAvailableLocales(companyId)) {
            titleMap.put(this._language.getLanguageId(locale), this._language.get(locale, "message-boards-user-stats-moderation"));
        }
        return titleMap;
    }
}

