/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.moderation.internal.configuration.persistence.listener;

import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.moderation.configuration.MBModerationGroupConfiguration;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.configuration.persistence.listener.ConfigurationModelListener;
import com.liferay.portal.configuration.persistence.listener.ConfigurationModelListenerException;
import com.liferay.portal.kernel.model.WorkflowDefinitionLink;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.WorkflowDefinitionLinkLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.workflow.WorkflowDefinition;
import com.liferay.portal.workflow.manager.WorkflowDefinitionManager;
import java.util.Dictionary;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.message.boards.moderation.configuration.MBModerationGroupConfiguration"}, service={ConfigurationModelListener.class})
public class MBModerationGroupConfigurationModelListener
implements ConfigurationModelListener {
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private WorkflowDefinitionLinkLocalService _workflowDefinitionLinkLocalService;
    @Reference
    private WorkflowDefinitionManager _workflowDefinitionManager;

    public void onAfterSave(String pid, Dictionary<String, Object> properties) throws ConfigurationModelListenerException {
        MBModerationGroupConfiguration mbModerationGroupConfiguration = (MBModerationGroupConfiguration)ConfigurableUtil.createConfigurable(MBModerationGroupConfiguration.class, (Dictionary)new HashMapDictionary());
        long companyId = GetterUtil.getLong((Object)properties.get("companyId"));
        boolean enableMessageBoardsModeration = GetterUtil.getBoolean((Object)properties.get("enableMessageBoardsModeration"), (boolean)mbModerationGroupConfiguration.enableMessageBoardsModeration());
        try {
            if (companyId == 0L) {
                this._companyLocalService.forEachCompanyId(curCompanyId -> this._updateMBModerationWorkflow((long)curCompanyId, enableMessageBoardsModeration));
            } else {
                this._updateMBModerationWorkflow(companyId, enableMessageBoardsModeration);
            }
        }
        catch (Exception exception) {
            throw new ConfigurationModelListenerException(exception.getMessage(), MBModerationGroupConfiguration.class, this.getClass(), properties);
        }
    }

    private void _updateMBModerationWorkflow(long companyId, boolean enableMessageBoardsModeration) throws Exception {
        if (!enableMessageBoardsModeration) {
            WorkflowDefinitionLink workflowDefinitionLink = this._workflowDefinitionLinkLocalService.fetchWorkflowDefinitionLink(companyId, 0L, MBMessage.class.getName(), 0L, 0L);
            if (workflowDefinitionLink != null) {
                this._workflowDefinitionLinkLocalService.deleteWorkflowDefinitionLink(workflowDefinitionLink);
            }
            return;
        }
        WorkflowDefinition workflowDefinition = this._workflowDefinitionManager.liberalGetLatestWorkflowDefinition(companyId, "message-boards-user-stats-moderation");
        this._workflowDefinitionLinkLocalService.addWorkflowDefinitionLink(workflowDefinition.getUserId(), companyId, 0L, MBMessage.class.getName(), 0L, 0L, "message-boards-user-stats-moderation", workflowDefinition.getVersion());
    }
}

