/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.comment.internal.security.permission.resource;

import com.liferay.message.boards.model.MBDiscussion;
import com.liferay.message.boards.service.MBDiscussionLocalService;
import com.liferay.portal.kernel.comment.DiscussionPermission;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.message.boards.model.MBDiscussion"}, service={ModelResourcePermission.class})
public class MBDiscussionModelResourcePermission
implements ModelResourcePermission<MBDiscussion> {
    @Reference
    private DiscussionPermission _discussionPermission;
    @Reference
    private MBDiscussionLocalService _mbDiscussionLocalService;

    public void check(PermissionChecker permissionChecker, long discussionId, String actionId) throws PortalException {
        this.check(permissionChecker, this._mbDiscussionLocalService.getMBDiscussion(discussionId), actionId);
    }

    public void check(PermissionChecker permissionChecker, MBDiscussion mbDiscussion, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, mbDiscussion, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, MBDiscussion.class.getName(), mbDiscussion.getDiscussionId(), new String[]{actionId});
        }
    }

    public boolean contains(PermissionChecker permissionChecker, long discussionId, String actionId) throws PortalException {
        return this.contains(permissionChecker, this._mbDiscussionLocalService.getMBDiscussion(discussionId), actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, MBDiscussion mbDiscussion, String actionId) {
        return this._discussionPermission.hasPermission(permissionChecker, mbDiscussion.getCompanyId(), mbDiscussion.getGroupId(), mbDiscussion.getClassName(), mbDiscussion.getClassPK(), actionId);
    }

    public String getModelName() {
        return MBDiscussion.class.getName();
    }

    public PortletResourcePermission getPortletResourcePermission() {
        return null;
    }
}

