/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mcp.server.internal.servlet;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import io.modelcontextprotocol.common.McpTransportContext;
import io.modelcontextprotocol.json.McpJsonMapper;
import io.modelcontextprotocol.json.jackson.JacksonMcpJsonMapper;
import io.modelcontextprotocol.server.McpServer;
import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.server.McpSyncServer;
import io.modelcontextprotocol.server.McpSyncServerExchange;
import io.modelcontextprotocol.server.transport.HttpServletSseServerTransportProvider;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.spec.McpServerTransportProvider;
import jakarta.servlet.GenericServlet;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(property={"osgi.http.whiteboard.context.path=/mcp", "osgi.http.whiteboard.servlet.name=com.liferay.mcp.server.internal.servlet.MCPServerServlet", "osgi.http.whiteboard.servlet.pattern=/mcp/*"}, service={Servlet.class})
public class MCPServerServlet
extends HttpServlet {
    private static final Log _log = LogFactoryUtil.getLog(MCPServerServlet.class);
    @Reference
    private Http _http;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectEntryLocalService _objectEntryLocalService;
    @Reference
    private Portal _portal;
    private final Map<Long, Servlet> _servlets = new ConcurrentHashMap<Long, Servlet>();

    public void destroy() {
        for (Map.Entry<Long, Servlet> entry : this._servlets.entrySet()) {
            Servlet servlet = entry.getValue();
            servlet.destroy();
        }
        this._servlets.clear();
    }

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        long companyId = this._portal.getCompanyId(httpServletRequest);
        if (!FeatureFlagManagerUtil.isEnabled((long)companyId, (String)"LPD-63311")) {
            httpServletResponse.setStatus(404);
            return;
        }
        Servlet servlet = this._getServlet(this._portal.getPortalURL(httpServletRequest) + this._portal.getPathModule(), companyId);
        servlet.service((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    @Deactivate
    protected void deactivate() {
        this.destroy();
    }

    private Servlet _buildServlet(String baseURL, long companyId) {
        final HttpServletSseServerTransportProvider httpServletSseServerTransportProvider = HttpServletSseServerTransportProvider.builder().baseUrl(baseURL + "/mcp").contextExtractor(request -> McpTransportContext.create((Map)HashMapBuilder.put((Object)"authorization", (Object)request.getHeader("Authorization")).build())).messageEndpoint("/message").build();
        JSONObject toolsJSONObject = this._getToolsJSONObject(baseURL);
        final McpSyncServer mcpSyncServer = McpServer.sync((McpServerTransportProvider)httpServletSseServerTransportProvider).capabilities(McpSchema.ServerCapabilities.builder().tools(Boolean.valueOf(true)).prompts(Boolean.valueOf(true)).build()).tool(this._getTool("call-http-endpoint", toolsJSONObject), (mcpSyncServerExchange, monos) -> {
            Object path = String.valueOf(monos.get("path"));
            if (!((String)path).startsWith("/")) {
                path = "/" + (String)path;
            }
            return this._call(String.valueOf(monos.get("payload")), baseURL + (String)path, (McpSyncServerExchange)mcpSyncServerExchange, String.valueOf(monos.get("method")));
        }).tool(this._getTool("get-openapi", toolsJSONObject), (mcpSyncServerExchange, monos) -> this._call(null, String.valueOf(monos.get("url")), (McpSyncServerExchange)mcpSyncServerExchange, "GET")).tool(this._getTool("get-openapis", toolsJSONObject), (mcpSyncServerExchange, monos) -> this._call(null, baseURL + "/openapi", (McpSyncServerExchange)mcpSyncServerExchange, "GET")).prompts(this._getSyncPromptSpecifications(companyId)).build();
        return new GenericServlet(){

            public void destroy() {
                mcpSyncServer.closeGracefully();
            }

            public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
                httpServletSseServerTransportProvider.service(servletRequest, servletResponse);
            }
        };
    }

    private McpSchema.CallToolResult _call(String body, String location, McpSyncServerExchange mcpSyncServerExchange, String method) {
        Http.Options options = new Http.Options();
        if (Validator.isNotNull((String)body)) {
            options.setBody(body, "application/json", "UTF-8");
        }
        options.setHeaders((Map)HashMapBuilder.put((Object)"Authorization", () -> {
            McpTransportContext mcpTransportContext = mcpSyncServerExchange.transportContext();
            Object authorization = mcpTransportContext.get("authorization");
            if (authorization == null) {
                return null;
            }
            return String.valueOf(authorization);
        }).put((Object)"Content-Type", () -> Validator.isNotNull((String)body) ? "application/json" : null).build());
        options.setLocation(location);
        options.setMethod(Http.Method.valueOf((String)StringUtil.toUpperCase((String)method)));
        try {
            String content = this._http.URLtoString(options);
            Http.Response response = options.getResponse();
            int responseCode = response.getResponseCode();
            if (responseCode < 300) {
                return new McpSchema.CallToolResult(content, Boolean.valueOf(false));
            }
            return new McpSchema.CallToolResult(StringBundler.concat((Object[])new Object[]{"Status code: ", responseCode, ", Content:\n", content}), Boolean.valueOf(true));
        }
        catch (IOException ioException) {
            _log.error((Throwable)ioException);
            return new McpSchema.CallToolResult(ioException.getMessage(), Boolean.valueOf(true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Servlet _getServlet(String baseURL, long companyId) {
        Servlet servlet = this._servlets.get(companyId);
        if (servlet != null) {
            return servlet;
        }
        MCPServerServlet mCPServerServlet = this;
        synchronized (mCPServerServlet) {
            servlet = this._servlets.get(companyId);
            if (servlet != null) {
                return servlet;
            }
            servlet = this._buildServlet(baseURL, companyId);
            this._servlets.put(companyId, servlet);
            return servlet;
        }
    }

    private List<McpServerFeatures.SyncPromptSpecification> _getSyncPromptSpecifications(long companyId) {
        ObjectDefinition objectDefinition = this._objectDefinitionLocalService.fetchObjectDefinitionByExternalReferenceCode("L_MCP_SERVER_PROMPT", companyId);
        if (objectDefinition == null) {
            return Collections.emptyList();
        }
        return TransformUtil.transform((Collection)this._objectEntryLocalService.getObjectEntries(0L, objectDefinition.getObjectDefinitionId(), -1, -1), objectEntry -> {
            Map values = objectEntry.getValues();
            return new McpServerFeatures.SyncPromptSpecification(new McpSchema.Prompt((String)values.get("name"), (String)values.get("description"), Collections.emptyList()), (mcpSyncServerExchange, request) -> new McpSchema.GetPromptResult((String)values.get("description"), List.of(new McpSchema.PromptMessage(McpSchema.Role.USER, (McpSchema.Content)new McpSchema.TextContent((String)values.get("prompt"))))));
        });
    }

    private McpSchema.Tool _getTool(String name, JSONObject toolsJSONObject) {
        JSONObject toolJSONObject = toolsJSONObject.getJSONObject(name);
        return McpSchema.Tool.builder().name(name).description(toolJSONObject.getString("description")).inputSchema((McpJsonMapper)new JacksonMcpJsonMapper(new ObjectMapper()), toolJSONObject.getJSONObject("schema").toString()).build();
    }

    private JSONObject _getToolsJSONObject(String baseURL) {
        try {
            return this._jsonFactory.createJSONObject(StringUtil.replace((String)StringUtil.read(MCPServerServlet.class, (String)"dependencies/tools.json"), (String)"[$BASE_URL$]", (String)baseURL));
        }
        catch (JSONException jsonException) {
            throw new RuntimeException(jsonException);
        }
    }
}

