var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __reExport = (target, mod, secondTarget) => (__copyProps(target, mod, "default"), secondTarget && __copyProps(secondTarget, mod, "default"));

// ../../../../../../../../../$/bridge/for/main/@liferay/map-common
var map_common_exports = {};
__reExport(map_common_exports, liferay_star);
import * as liferay_star from "../../map-common/__liferay__/index.js";

// src/main/resources/META-INF/resources/js/OpenStreetMapDialog.js
var OpenStreetMapDialog = class {
  /**
   * Creates a new map dialog using OpenStreetMap's API
   * @review
   */
  constructor(args) {
    this._dialog = L.popup({
      className: "leaflet-popup",
      minWidth: 400
    });
    this.map = args.map;
  }
  /**
   * Opens the dialog with the given map attribute and passes
   * the given configuration to the dialog object.
   * @param {Object} cfg
   * @review
   */
  open(cfg) {
    this._dialog.setContent(cfg.content);
    this._dialog.setLatLng(cfg.position);
    this._dialog.options.offset = cfg.marker.options.icon.options.popupAnchor || [0, 0];
    this._dialog.openOn(this.map);
  }
};

// src/main/resources/META-INF/resources/js/OpenStreetMapGeoJSON.js
var OpenStreetMapGeoJSONBase = class extends map_common_exports.GeoJSONBase {
  /**
   * Creates a new map geojson parser using OpenStreetMap's API
   * @param {Array} args List of arguments to be passed to State
   * @review
   */
  constructor(args) {
    super(args);
    this._handleFeatureClicked = this._handleFeatureClicked.bind(this);
    this.map = args.map;
  }
  /**
   * @inheritDoc
   * @review
   */
  _getNativeFeatures(geoJSONData) {
    const features = [];
    L.geoJson(geoJSONData, {
      onEachFeature: (feature, layer) => {
        layer.on("click", this._handleFeatureClicked);
        features.push(feature);
      }
    }).addTo(this.map);
    return features;
  }
  /**
   * @inheritDoc
   * @review
   */
  _wrapNativeFeature(nativeFeature) {
    const feature = nativeFeature.geometry ? nativeFeature : nativeFeature.target.feature;
    const geometry = feature.geometry;
    return {
      getGeometry() {
        return {
          get() {
            return L.latLng(
              geometry.coordinates[1],
              geometry.coordinates[0]
            );
          }
        };
      },
      getMarker() {
        return nativeFeature.target;
      },
      getProperty(prop) {
        return feature.properties[prop];
      }
    };
  }
};

// ../../../../../../../../../$/bridge/for/main/frontend-js-web
var frontend_js_web_exports = {};
__reExport(frontend_js_web_exports, liferay_star2);
import * as liferay_star2 from "../../frontend-js-web/__liferay__/index.js";

// src/main/resources/META-INF/resources/js/OpenStreetMapGeocoder.js
var OPEN_STREET_MAP_URL = "https://nominatim.openstreetmap.org/";
var OpenStreetMapGeocoder = class _OpenStreetMapGeocoder {
  /**
   * Handles the server response of a successfull address forward
   * @param {Object} response Server response
   * @param {function} callback Callback that will be executed on success
   * @protected
   * @review
   */
  _handleForward(response, callback) {
    callback(response);
  }
  /**
   * Handles the server response of a successfull location reverse
   * @param {Object} response Server response
   * @param {function} callback Callback that will be executed on success
   * @protected
   * @review
   */
  _handleReverse(response, callback) {
    const { display_name, error, lat, lon } = response;
    const result = {
      data: {},
      error
    };
    if (!result.error) {
      result.data = {
        address: display_name,
        location: {
          lat: parseFloat(lat) || 0,
          lng: parseFloat(lon) || 0
        }
      };
    }
    callback(result);
  }
  /**
   * Transforms a given address into valid latitude and longitude
   * @param {string} query Address to be transformed into latitude and longitude
   * @param {function} callback Callback that will be executed on success
   * @review
   */
  forward(query, callback) {
    const forwardURL = _OpenStreetMapGeocoder.TPL_FORWARD_GEOCODING_URL.replace(
      "{query}",
      query
    );
    (0, frontend_js_web_exports.fetch)(forwardURL).then((response) => response.json()).then((response) => this._handleForward(response, callback));
  }
  /**
   * Transforms a given location object (lat, lng) into a valid address
   * @param {string} location Location information to be sent to the server
   * @param {function} callback Callback that will be executed on success
   * @review
   */
  reverse(location, callback) {
    const reverseURL = _OpenStreetMapGeocoder.TPL_REVERSE_GEOCODING_URL.replace(
      "{lat}",
      location.lat
    ).replace("{lng}", location.lng);
    (0, frontend_js_web_exports.fetch)(reverseURL).then((response) => response.json()).then((response) => this._handleReverse(response, callback));
  }
};
OpenStreetMapGeocoder.TPL_FORWARD_GEOCODING_URL = `${OPEN_STREET_MAP_URL}search?q={query}&format=jsonv2`;
OpenStreetMapGeocoder.TPL_REVERSE_GEOCODING_URL = `${OPEN_STREET_MAP_URL}reverse?lat={lat}&lon={lng}&format=jsonv2`;

// src/main/resources/META-INF/resources/js/OpenStreetMapMarker.js
var OpenStreetMapMarker = class extends map_common_exports.MarkerBase {
  /**
   * @inheritDoc
   * @review
   */
  _getNativeMarker(location, map) {
    if (!this._nativeMarker) {
      this._nativeMarker = L.marker(location, {
        draggable: true
      }).addTo(map);
      this._nativeMarker.on(
        "click",
        this._getNativeEventFunction("click")
      );
      this._nativeMarker.on(
        "dblclick",
        this._getNativeEventFunction("dblclick")
      );
      this._nativeMarker.on("drag", this._getNativeEventFunction("drag"));
      this._nativeMarker.on(
        "dragend",
        this._getNativeEventFunction("dragend")
      );
      this._nativeMarker.on(
        "dragstart",
        this._getNativeEventFunction("dragstart")
      );
      this._nativeMarker.on(
        "mousedown",
        this._getNativeEventFunction("mousedown")
      );
      this._nativeMarker.on(
        "mouseout",
        this._getNativeEventFunction("mouseout")
      );
      this._nativeMarker.on(
        "mouseover",
        this._getNativeEventFunction("mouseover")
      );
    }
    return this._nativeMarker;
  }
  /**
   * @inheritDoc
   * @review
   */
  _getNormalizedEventData(nativeEvent) {
    return {
      location: nativeEvent.target.getLatLng()
    };
  }
  /**
   * If a marked has been created, sets the marker location to the given one
   * @param {Object} location Location to set the native marker in
   * @review
   */
  setPosition(location) {
    if (this._nativeMarker) {
      this._nativeMarker.setLatLng(location);
    }
  }
};

// src/main/resources/META-INF/resources/js/MapOpenStreetMap.js
var defaultTileURI = "//{s}.tile.openstreetmap.org/{z}/{x}/{y}.png";
var MapOpenStreetMap = class _MapOpenStreetMap extends map_common_exports.MapBase {
  get tileURI() {
    return this._STATE_.tileURI;
  }
  set tileURI(tileURI) {
    this._STATE_.tileURI = tileURI;
  }
  /**
   * Creates a new map using OpenStreetMap's API
   * @param  {Array} args List of arguments to be passed to State
   * @review
   */
  constructor(args) {
    map_common_exports.MapBase.DialogImpl = OpenStreetMapDialog;
    map_common_exports.MapBase.GeocoderImpl = OpenStreetMapGeocoder;
    map_common_exports.MapBase.GeoJSONImpl = OpenStreetMapGeoJSONBase;
    map_common_exports.MapBase.MarkerImpl = OpenStreetMapMarker;
    map_common_exports.MapBase.SearchImpl = null;
    super(args);
    const { tileURI = defaultTileURI } = args;
    this._STATE_ = {
      ...this._STATE_,
      tileURI
    };
    this._map = null;
  }
  /**
   * @inheritDoc
   * @review
   */
  _createMap(location, controlsConfig) {
    const mapConfig = {
      center: location,
      layers: [
        L.tileLayer(this.tileURI, {
          attribution: '&copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors'
        })
      ],
      zoom: this.zoom
    };
    const map = L.map(
      document.querySelector(this.boundingBox),
      Object.assign(mapConfig, controlsConfig)
    );
    if (this.data?.features?.length) {
      const bounds = new L.LatLngBounds();
      this.data.features.forEach(
        (feature) => bounds.extend(
          new L.LatLng(
            feature.geometry.coordinates[1],
            feature.geometry.coordinates[0]
          )
        )
      );
      map.fitBounds(bounds);
    }
    return map;
  }
  /**
   * @inheritDoc
   * @review
   */
  addControl(control, position) {
    const LeafLetControl = L.Control.extend({
      onAdd() {
        if (typeof control === "string") {
          control = document.querySelector(control);
        }
        return control;
      },
      options: {
        position: _MapOpenStreetMap.POSITION_MAP[position]
      }
    });
    this._map.addControl(new LeafLetControl());
  }
  /**
   * @inheritDoc
   * @review
   */
  getBounds() {
    return this._map.getBounds();
  }
  /**
   * @inheritDoc
   * @review
   */
  setCenter(location) {
    if (this._map) {
      this._map.panTo(location);
    }
    if (this._geolocationMarker) {
      this._geolocationMarker.setPosition(location);
    }
  }
};
MapOpenStreetMap.CONTROLS_MAP = {
  [map_common_exports.MapBase.CONTROLS.ATTRIBUTION]: "attributionControl",
  [map_common_exports.MapBase.CONTROLS.ZOOM]: "zoomControl"
};
MapOpenStreetMap.POSITION_MAP = {
  [map_common_exports.MapBase.POSITION.BOTTOM]: "bottomleft",
  [map_common_exports.MapBase.POSITION.BOTTOM_CENTER]: "bottomleft",
  [map_common_exports.MapBase.POSITION.BOTTOM_LEFT]: "bottomleft",
  [map_common_exports.MapBase.POSITION.BOTTOM_RIGHT]: "bottomright",
  [map_common_exports.MapBase.POSITION.CENTER]: "topleft",
  [map_common_exports.MapBase.POSITION.LEFT]: "topleft",
  [map_common_exports.MapBase.POSITION.LEFT_BOTTOM]: "bottomleft",
  [map_common_exports.MapBase.POSITION.LEFT_CENTER]: "topleft",
  [map_common_exports.MapBase.POSITION.LEFT_TOP]: "topleft",
  [map_common_exports.MapBase.POSITION.RIGHT]: "bottomright",
  [map_common_exports.MapBase.POSITION.RIGHT_BOTTOM]: "bottomright",
  [map_common_exports.MapBase.POSITION.RIGHT_CENTER]: "bottomright",
  [map_common_exports.MapBase.POSITION.RIGHT_TOP]: "topright",
  [map_common_exports.MapBase.POSITION.TOP]: "topright",
  [map_common_exports.MapBase.POSITION.TOP_CENTER]: "topright",
  [map_common_exports.MapBase.POSITION.TOP_LEFT]: "topleft",
  [map_common_exports.MapBase.POSITION.TOP_RIGHT]: "topright"
};
var MapOpenStreetMap_default = MapOpenStreetMap;

// src/main/resources/META-INF/resources/js/App.js
function App({
  boundingBox,
  data,
  geolocation,
  isMobile,
  latitude,
  longitude,
  name,
  portletId
}) {
  const MapControls = Liferay.MapBase.CONTROLS;
  const mapConfig = { boundingBox, geolocation };
  if (geolocation) {
    if (isMobile) {
      mapConfig.controls = [MapControls.HOME, MapControls.SEARCH];
    } else {
      mapConfig.controls = [
        MapControls.HOME,
        MapControls.PAN,
        MapControls.SEARCH,
        MapControls.TYPE,
        MapControls.ZOOM
      ];
    }
  }
  if (data) {
    mapConfig.data = data;
  }
  if (latitude !== 0 && longitude !== 0) {
    mapConfig.position = {
      location: {
        lat: latitude,
        lng: longitude
      }
    };
  }
  const createMap = function() {
    const map = new MapOpenStreetMap_default(mapConfig);
    Liferay.MapBase.register(name, map, portletId);
  };
  createMap();
}
export {
  App,
  MapOpenStreetMap_default as MapOpenStreetMap,
  OpenStreetMapDialog,
  OpenStreetMapGeoJSONBase as OpenStreetMapGeoJSON,
  OpenStreetMapGeocoder,
  OpenStreetMapMarker
};
//# sourceMappingURL=index.js.map
