Liferay.Loader.define("map-openstreetmap@4.0.35/js/OpenStreetMapGeocoder.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-state'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.OpenStreetMapGeocoder = exports["default"] = void 0;

  var _metalState = _interopRequireDefault(require("frontend-js-metal-web$metal-state"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * OpenStreetMapGeocoder
   */
  var OpenStreetMapGeocoder = /*#__PURE__*/function (_State) {
    _inherits(OpenStreetMapGeocoder, _State);

    function OpenStreetMapGeocoder() {
      _classCallCheck(this, OpenStreetMapGeocoder);

      return _possibleConstructorReturn(this, _getPrototypeOf(OpenStreetMapGeocoder).apply(this, arguments));
    }

    _createClass(OpenStreetMapGeocoder, [{
      key: "_handleForwardJSONP",

      /**
       * Handles the server response of a successfull address forward
       * @param {Object} response Server response
       * @param {function} callback Callback that will be executed on success
       * @protected
       * @review
       */
      value: function _handleForwardJSONP(response, callback) {
        callback(response);
      }
      /**
       * Handles the server response of a successfull location reverse
       * @param {Object} response Server response
       * @param {function} callback Callback that will be executed on success
       * @protected
       * @review
       */

    }, {
      key: "_handleReverseJSONP",
      value: function _handleReverseJSONP(_ref, callback) {
        var display_name = _ref.display_name,
            error = _ref.error,
            lat = _ref.lat,
            lon = _ref.lon;
        var result = {
          data: {},
          err: error
        };

        if (!result.err) {
          result.data = {
            address: display_name,
            location: {
              lat: parseFloat(lat) || 0,
              lng: parseFloat(lon) || 0
            }
          };
        }

        callback(result);
      }
      /**
       * Transforms a given address into valid latitude and longitude
       * @param {string} query Address to be transformed into latitude and longitude
       * @param {function} callback Callback that will be executed on success
       * @review
       */

    }, {
      key: "forward",
      value: function forward(query, callback) {
        var _this = this;

        AUI().use('jsonp', function (A) {
          var forwardUrl = OpenStreetMapGeocoder.TPL_FORWARD_GEOCODING_URL.replace('{query}', query);
          A.jsonp(forwardUrl, {
            context: _this,
            on: {
              success: A.rbind('_handleForwardJSONP', _this, callback)
            }
          });
        });
      }
      /**
       * Transforms a given location object (lat, lng) into a valid address
       * @param {string} location Location information to be sent to the server
       * @param {function} callback Callback that will be executed on success
       * @review
       */

    }, {
      key: "reverse",
      value: function reverse(location, callback) {
        var _this2 = this;

        AUI().use('jsonp', function (A) {
          var reverseUrl = OpenStreetMapGeocoder.TPL_REVERSE_GEOCODING_URL.replace('{lat}', location.lat).replace('{lng}', location.lng);
          A.jsonp(reverseUrl, {
            context: _this2,
            on: {
              success: A.rbind('_handleReverseJSONP', _this2, callback)
            }
          });
        });
      }
    }]);

    return OpenStreetMapGeocoder;
  }(_metalState["default"]);
  /**
   * Url template used for OpenStreetMapGeocoder.forward() method
   * @review
   * @see OpenStreetMapGeocoder.forward()
   * @type {string}
   */

  exports.OpenStreetMapGeocoder = OpenStreetMapGeocoder;
  OpenStreetMapGeocoder.TPL_FORWARD_GEOCODING_URL = '//nominatim.openstreetmap.org/search?format=json&json_callback={callback}&q={query}';
  /**
   * Url template used for OpenStreetMapGeocoder.reverse() method
   * @review
   * @see OpenStreetMapGeocoder.reverse()
   * @type {string}
   */

  OpenStreetMapGeocoder.TPL_REVERSE_GEOCODING_URL = '//nominatim.openstreetmap.org/reverse?format=json&json_callback={callback}&lat={lat}&lon={lng}';
  var _default = OpenStreetMapGeocoder;
  exports["default"] = _default;
  //# sourceMappingURL=OpenStreetMapGeocoder.es.js.map
});
//# sourceMappingURL=OpenStreetMapGeocoder.es.js.map