/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mail.reader.service.persistence.impl;

import com.liferay.mail.reader.exception.NoSuchMessageException;
import com.liferay.mail.reader.model.Message;
import com.liferay.mail.reader.model.MessageTable;
import com.liferay.mail.reader.model.impl.MessageImpl;
import com.liferay.mail.reader.model.impl.MessageModelImpl;
import com.liferay.mail.reader.service.persistence.MessagePersistence;
import com.liferay.mail.reader.service.persistence.MessageUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.orm.ArgumentsResolver;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={MessagePersistence.class})
public class MessagePersistenceImpl
extends BasePersistenceImpl<Message>
implements MessagePersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = MessageImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByCompanyId;
    private FinderPath _finderPathWithoutPaginationFindByCompanyId;
    private FinderPath _finderPathCountByCompanyId;
    private static final String _FINDER_COLUMN_COMPANYID_COMPANYID_2 = "message.companyId = ?";
    private FinderPath _finderPathWithPaginationFindByFolderId;
    private FinderPath _finderPathWithoutPaginationFindByFolderId;
    private FinderPath _finderPathCountByFolderId;
    private static final String _FINDER_COLUMN_FOLDERID_FOLDERID_2 = "message.folderId = ?";
    private FinderPath _finderPathFetchByF_R;
    private FinderPath _finderPathCountByF_R;
    private static final String _FINDER_COLUMN_F_R_FOLDERID_2 = "message.folderId = ? AND ";
    private static final String _FINDER_COLUMN_F_R_REMOTEMESSAGEID_2 = "message.remoteMessageId = ?";
    private int _valueObjectFinderCacheListThreshold;
    private BundleContext _bundleContext;
    @Reference
    protected EntityCache entityCache;
    @Reference
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_MESSAGE = "SELECT message FROM Message message";
    private static final String _SQL_SELECT_MESSAGE_WHERE = "SELECT message FROM Message message WHERE ";
    private static final String _SQL_COUNT_MESSAGE = "SELECT COUNT(message) FROM Message message";
    private static final String _SQL_COUNT_MESSAGE_WHERE = "SELECT COUNT(message) FROM Message message WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "message.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No Message exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No Message exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(MessagePersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"to", "size"});
    private Set<ServiceRegistration<FinderPath>> _serviceRegistrations = new HashSet<ServiceRegistration<FinderPath>>();
    private ServiceRegistration<ArgumentsResolver> _argumentsResolverServiceRegistration;

    public List<Message> findByCompanyId(long companyId) {
        return this.findByCompanyId(companyId, -1, -1, null);
    }

    public List<Message> findByCompanyId(long companyId, int start, int end) {
        return this.findByCompanyId(companyId, start, end, null);
    }

    public List<Message> findByCompanyId(long companyId, int start, int end, OrderByComparator<Message> orderByComparator) {
        return this.findByCompanyId(companyId, start, end, orderByComparator, true);
    }

    public List<Message> findByCompanyId(long companyId, int start, int end, OrderByComparator<Message> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByCompanyId;
                finderArgs = new Object[]{companyId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByCompanyId;
            finderArgs = new Object[]{companyId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (Message message : list) {
                if (companyId == message.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_MESSAGE_WHERE);
            sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY message.sentDate ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public Message findByCompanyId_First(long companyId, OrderByComparator<Message> orderByComparator) throws NoSuchMessageException {
        Message message = this.fetchByCompanyId_First(companyId, orderByComparator);
        if (message != null) {
            return message;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchMessageException(sb.toString());
    }

    public Message fetchByCompanyId_First(long companyId, OrderByComparator<Message> orderByComparator) {
        List<Message> list = this.findByCompanyId(companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Message findByCompanyId_Last(long companyId, OrderByComparator<Message> orderByComparator) throws NoSuchMessageException {
        Message message = this.fetchByCompanyId_Last(companyId, orderByComparator);
        if (message != null) {
            return message;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchMessageException(sb.toString());
    }

    public Message fetchByCompanyId_Last(long companyId, OrderByComparator<Message> orderByComparator) {
        int count = this.countByCompanyId(companyId);
        if (count == 0) {
            return null;
        }
        List<Message> list = this.findByCompanyId(companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Message[] findByCompanyId_PrevAndNext(long messageId, long companyId, OrderByComparator<Message> orderByComparator) throws NoSuchMessageException {
        Message message = this.findByPrimaryKey(messageId);
        Session session = null;
        try {
            session = this.openSession();
            Message[] array = new MessageImpl[]{this.getByCompanyId_PrevAndNext(session, message, companyId, orderByComparator, true), message, this.getByCompanyId_PrevAndNext(session, message, companyId, orderByComparator, false)};
            Message[] messageArray = array;
            return messageArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Message getByCompanyId_PrevAndNext(Session session, Message message, long companyId, OrderByComparator<Message> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_MESSAGE_WHERE);
        sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY message.sentDate ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)message)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (Message)list.get(1);
        }
        return null;
    }

    public void removeByCompanyId(long companyId) {
        for (Message message : this.findByCompanyId(companyId, -1, -1, null)) {
            this.remove((BaseModel)message);
        }
    }

    public int countByCompanyId(long companyId) {
        FinderPath finderPath = this._finderPathCountByCompanyId;
        Object[] finderArgs = new Object[]{companyId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_MESSAGE_WHERE);
            sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<Message> findByFolderId(long folderId) {
        return this.findByFolderId(folderId, -1, -1, null);
    }

    public List<Message> findByFolderId(long folderId, int start, int end) {
        return this.findByFolderId(folderId, start, end, null);
    }

    public List<Message> findByFolderId(long folderId, int start, int end, OrderByComparator<Message> orderByComparator) {
        return this.findByFolderId(folderId, start, end, orderByComparator, true);
    }

    public List<Message> findByFolderId(long folderId, int start, int end, OrderByComparator<Message> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByFolderId;
                finderArgs = new Object[]{folderId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByFolderId;
            finderArgs = new Object[]{folderId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (Message message : list) {
                if (folderId == message.getFolderId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_MESSAGE_WHERE);
            sb.append(_FINDER_COLUMN_FOLDERID_FOLDERID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY message.sentDate ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(folderId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public Message findByFolderId_First(long folderId, OrderByComparator<Message> orderByComparator) throws NoSuchMessageException {
        Message message = this.fetchByFolderId_First(folderId, orderByComparator);
        if (message != null) {
            return message;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("folderId=");
        sb.append(folderId);
        sb.append("}");
        throw new NoSuchMessageException(sb.toString());
    }

    public Message fetchByFolderId_First(long folderId, OrderByComparator<Message> orderByComparator) {
        List<Message> list = this.findByFolderId(folderId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Message findByFolderId_Last(long folderId, OrderByComparator<Message> orderByComparator) throws NoSuchMessageException {
        Message message = this.fetchByFolderId_Last(folderId, orderByComparator);
        if (message != null) {
            return message;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("folderId=");
        sb.append(folderId);
        sb.append("}");
        throw new NoSuchMessageException(sb.toString());
    }

    public Message fetchByFolderId_Last(long folderId, OrderByComparator<Message> orderByComparator) {
        int count = this.countByFolderId(folderId);
        if (count == 0) {
            return null;
        }
        List<Message> list = this.findByFolderId(folderId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Message[] findByFolderId_PrevAndNext(long messageId, long folderId, OrderByComparator<Message> orderByComparator) throws NoSuchMessageException {
        Message message = this.findByPrimaryKey(messageId);
        Session session = null;
        try {
            session = this.openSession();
            Message[] array = new MessageImpl[]{this.getByFolderId_PrevAndNext(session, message, folderId, orderByComparator, true), message, this.getByFolderId_PrevAndNext(session, message, folderId, orderByComparator, false)};
            Message[] messageArray = array;
            return messageArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Message getByFolderId_PrevAndNext(Session session, Message message, long folderId, OrderByComparator<Message> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_MESSAGE_WHERE);
        sb.append(_FINDER_COLUMN_FOLDERID_FOLDERID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY message.sentDate ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(folderId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)message)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (Message)list.get(1);
        }
        return null;
    }

    public void removeByFolderId(long folderId) {
        for (Message message : this.findByFolderId(folderId, -1, -1, null)) {
            this.remove((BaseModel)message);
        }
    }

    public int countByFolderId(long folderId) {
        FinderPath finderPath = this._finderPathCountByFolderId;
        Object[] finderArgs = new Object[]{folderId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_MESSAGE_WHERE);
            sb.append(_FINDER_COLUMN_FOLDERID_FOLDERID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(folderId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Message findByF_R(long folderId, long remoteMessageId) throws NoSuchMessageException {
        Message message = this.fetchByF_R(folderId, remoteMessageId);
        if (message == null) {
            StringBundler sb = new StringBundler(6);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("folderId=");
            sb.append(folderId);
            sb.append(", remoteMessageId=");
            sb.append(remoteMessageId);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchMessageException(sb.toString());
        }
        return message;
    }

    public Message fetchByF_R(long folderId, long remoteMessageId) {
        return this.fetchByF_R(folderId, remoteMessageId, true);
    }

    public Message fetchByF_R(long folderId, long remoteMessageId, boolean useFinderCache) {
        Message message;
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{folderId, remoteMessageId};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByF_R, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof Message && (folderId != (message = (Message)result).getFolderId() || remoteMessageId != message.getRemoteMessageId())) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_SELECT_MESSAGE_WHERE);
            sb.append(_FINDER_COLUMN_F_R_FOLDERID_2);
            sb.append(_FINDER_COLUMN_F_R_REMOTEMESSAGEID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(folderId);
                queryPos.add(remoteMessageId);
                List list = query.list();
                if (list.isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByF_R, finderArgs, (Object)list);
                    }
                } else {
                    if (list.size() > 1) {
                        Collections.sort(list, Collections.reverseOrder());
                        if (_log.isWarnEnabled()) {
                            if (!useFinderCache) {
                                finderArgs = new Object[]{folderId, remoteMessageId};
                            }
                            _log.warn((Object)("MessagePersistenceImpl.fetchByF_R(long, long, boolean) with parameters (" + StringUtil.merge((Object[])finderArgs) + ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder."));
                        }
                    }
                    Message message2 = (Message)list.get(0);
                    result = message2;
                    this.cacheResult(message2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (Message)result;
    }

    public Message removeByF_R(long folderId, long remoteMessageId) throws NoSuchMessageException {
        Message message = this.findByF_R(folderId, remoteMessageId);
        return (Message)this.remove((BaseModel)message);
    }

    public int countByF_R(long folderId, long remoteMessageId) {
        FinderPath finderPath = this._finderPathCountByF_R;
        Object[] finderArgs = new Object[]{folderId, remoteMessageId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_MESSAGE_WHERE);
            sb.append(_FINDER_COLUMN_F_R_FOLDERID_2);
            sb.append(_FINDER_COLUMN_F_R_REMOTEMESSAGEID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(folderId);
                queryPos.add(remoteMessageId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public MessagePersistenceImpl() {
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("to", "to_");
        dbColumnNames.put("size", "size_");
        this.setDBColumnNames(dbColumnNames);
        this.setModelClass(Message.class);
        this.setModelImplClass(MessageImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)MessageTable.INSTANCE);
    }

    public void cacheResult(Message message) {
        this.entityCache.putResult(MessageImpl.class, (Serializable)Long.valueOf(message.getPrimaryKey()), (Serializable)message);
        this.finderCache.putResult(this._finderPathFetchByF_R, new Object[]{message.getFolderId(), message.getRemoteMessageId()}, (Object)message);
    }

    public void cacheResult(List<Message> messages) {
        if (this._valueObjectFinderCacheListThreshold == 0 || this._valueObjectFinderCacheListThreshold > 0 && messages.size() > this._valueObjectFinderCacheListThreshold) {
            return;
        }
        for (Message message : messages) {
            if (this.entityCache.getResult(MessageImpl.class, (Serializable)Long.valueOf(message.getPrimaryKey())) != null) continue;
            this.cacheResult(message);
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(MessageImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(Message message) {
        this.entityCache.removeResult(MessageImpl.class, (BaseModel)message);
    }

    public void clearCache(List<Message> messages) {
        for (Message message : messages) {
            this.entityCache.removeResult(MessageImpl.class, (BaseModel)message);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(MessageImpl.class, primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(MessageModelImpl messageModelImpl) {
        Object[] args = new Object[]{messageModelImpl.getFolderId(), messageModelImpl.getRemoteMessageId()};
        this.finderCache.putResult(this._finderPathCountByF_R, args, (Object)1L, false);
        this.finderCache.putResult(this._finderPathFetchByF_R, args, (Object)messageModelImpl, false);
    }

    public Message create(long messageId) {
        MessageImpl message = new MessageImpl();
        message.setNew(true);
        message.setPrimaryKey(messageId);
        message.setCompanyId(CompanyThreadLocal.getCompanyId());
        return message;
    }

    public Message remove(long messageId) throws NoSuchMessageException {
        return this.remove(Long.valueOf(messageId));
    }

    public Message remove(Serializable primaryKey) throws NoSuchMessageException {
        Session session = null;
        try {
            session = this.openSession();
            Message message = (Message)session.get(MessageImpl.class, primaryKey);
            if (message == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchMessageException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            Message message2 = (Message)this.remove((BaseModel)message);
            return message2;
        }
        catch (NoSuchMessageException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Message removeImpl(Message message) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)message)) {
                message = (Message)session.get(MessageImpl.class, message.getPrimaryKeyObj());
            }
            if (message != null) {
                session.delete((Object)message);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (message != null) {
            this.clearCache(message);
        }
        return message;
    }

    public Message updateImpl(Message message) {
        boolean isNew = message.isNew();
        if (!(message instanceof MessageModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(message.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)message);
                throw new IllegalArgumentException("Implement ModelWrapper in message proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom Message implementation " + message.getClass());
        }
        MessageModelImpl messageModelImpl = (MessageModelImpl)message;
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date date = new Date();
        if (isNew && message.getCreateDate() == null) {
            if (serviceContext == null) {
                message.setCreateDate(date);
            } else {
                message.setCreateDate(serviceContext.getCreateDate(date));
            }
        }
        if (!messageModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                message.setModifiedDate(date);
            } else {
                message.setModifiedDate(serviceContext.getModifiedDate(date));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)message);
            } else {
                message = (Message)session.merge((Object)message);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.entityCache.putResult(MessageImpl.class, (BaseModel)messageModelImpl, false, true);
        this.cacheUniqueFindersCache(messageModelImpl);
        if (isNew) {
            message.setNew(false);
        }
        message.resetOriginalValues();
        return message;
    }

    public Message findByPrimaryKey(Serializable primaryKey) throws NoSuchMessageException {
        Message message = (Message)this.fetchByPrimaryKey(primaryKey);
        if (message == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchMessageException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return message;
    }

    public Message findByPrimaryKey(long messageId) throws NoSuchMessageException {
        return this.findByPrimaryKey(Long.valueOf(messageId));
    }

    public Message fetchByPrimaryKey(long messageId) {
        return (Message)this.fetchByPrimaryKey(Long.valueOf(messageId));
    }

    public List<Message> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<Message> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<Message> findAll(int start, int end, OrderByComparator<Message> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<Message> findAll(int start, int end, OrderByComparator<Message> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_MESSAGE);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_MESSAGE;
                sql = sql.concat(" ORDER BY message.sentDate ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (Message message : this.findAll()) {
            this.remove((BaseModel)message);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_MESSAGE);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "messageId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_MESSAGE;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return MessageModelImpl.TABLE_COLUMNS_MAP;
    }

    @Activate
    public void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._argumentsResolverServiceRegistration = this._bundleContext.registerService(ArgumentsResolver.class, (Object)new MessageModelArgumentsResolver(), MapUtil.singletonDictionary((Object)"model.class.name", (Object)Message.class.getName()));
        this._valueObjectFinderCacheListThreshold = GetterUtil.getInteger((String)PropsUtil.get((String)"value.object.finder.cache.list.threshold"));
        this._finderPathWithPaginationFindAll = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathWithPaginationFindByCompanyId = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByCompanyId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"companyId"}, true);
        this._finderPathWithoutPaginationFindByCompanyId = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByCompanyId", new String[]{Long.class.getName()}, new String[]{"companyId"}, true);
        this._finderPathCountByCompanyId = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCompanyId", new String[]{Long.class.getName()}, new String[]{"companyId"}, false);
        this._finderPathWithPaginationFindByFolderId = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByFolderId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"folderId"}, true);
        this._finderPathWithoutPaginationFindByFolderId = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByFolderId", new String[]{Long.class.getName()}, new String[]{"folderId"}, true);
        this._finderPathCountByFolderId = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByFolderId", new String[]{Long.class.getName()}, new String[]{"folderId"}, false);
        this._finderPathFetchByF_R = this._createFinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByF_R", new String[]{Long.class.getName(), Long.class.getName()}, new String[]{"folderId", "remoteMessageId"}, true);
        this._finderPathCountByF_R = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByF_R", new String[]{Long.class.getName(), Long.class.getName()}, new String[]{"folderId", "remoteMessageId"}, false);
        MessageUtil.setPersistence((MessagePersistence)this);
    }

    @Deactivate
    public void deactivate() {
        MessageUtil.setPersistence(null);
        this.entityCache.removeCache(MessageImpl.class.getName());
        this._argumentsResolverServiceRegistration.unregister();
        for (ServiceRegistration<FinderPath> serviceRegistration : this._serviceRegistrations) {
            serviceRegistration.unregister();
        }
    }

    @Reference(target="(&(origin.bundle.symbolic.name=com.liferay.mail.reader.service)(name=service))", unbind="-")
    public void setConfiguration(Configuration configuration) {
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.mail.reader.service)", unbind="-")
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.mail.reader.service)", unbind="-")
    public void setSessionFactory(SessionFactory sessionFactory) {
        super.setSessionFactory(sessionFactory);
    }

    private FinderPath _createFinderPath(String cacheName, String methodName, String[] params, String[] columnNames, boolean baseModelResult) {
        FinderPath finderPath = new FinderPath(cacheName, methodName, params, columnNames, baseModelResult);
        if (!cacheName.equals(FINDER_CLASS_NAME_LIST_WITH_PAGINATION)) {
            this._serviceRegistrations.add((ServiceRegistration<FinderPath>)this._bundleContext.registerService(FinderPath.class, (Object)finderPath, MapUtil.singletonDictionary((Object)"cache.name", (Object)cacheName)));
        }
        return finderPath;
    }

    private static class MessageModelArgumentsResolver
    implements ArgumentsResolver {
        private static final Map<FinderPath, Long> _finderPathColumnBitmasksCache = new ConcurrentHashMap<FinderPath, Long>();
        private static final long _ORDER_BY_COLUMNS_BITMASK;

        private MessageModelArgumentsResolver() {
        }

        public Object[] getArguments(FinderPath finderPath, BaseModel<?> baseModel, boolean checkColumn, boolean original) {
            String[] columnNames = finderPath.getColumnNames();
            if (columnNames == null || columnNames.length == 0) {
                if (baseModel.isNew()) {
                    return new Object[0];
                }
                return null;
            }
            MessageModelImpl messageModelImpl = (MessageModelImpl)baseModel;
            long columnBitmask = messageModelImpl.getColumnBitmask();
            if (!checkColumn || columnBitmask == 0L) {
                return MessageModelArgumentsResolver._getValue(messageModelImpl, columnNames, original);
            }
            Long finderPathColumnBitmask = _finderPathColumnBitmasksCache.get(finderPath);
            if (finderPathColumnBitmask == null) {
                finderPathColumnBitmask = 0L;
                for (String columnName : columnNames) {
                    finderPathColumnBitmask = finderPathColumnBitmask | MessageModelImpl.getColumnBitmask(columnName);
                }
                if (finderPath.isBaseModelResult() && FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION == finderPath.getCacheName()) {
                    finderPathColumnBitmask = finderPathColumnBitmask | _ORDER_BY_COLUMNS_BITMASK;
                }
                _finderPathColumnBitmasksCache.put(finderPath, finderPathColumnBitmask);
            }
            if ((columnBitmask & finderPathColumnBitmask) != 0L) {
                return MessageModelArgumentsResolver._getValue(messageModelImpl, columnNames, original);
            }
            return null;
        }

        private static Object[] _getValue(MessageModelImpl messageModelImpl, String[] columnNames, boolean original) {
            Object[] arguments = new Object[columnNames.length];
            for (int i = 0; i < arguments.length; ++i) {
                String columnName = columnNames[i];
                arguments[i] = original ? messageModelImpl.getColumnOriginalValue(columnName) : messageModelImpl.getColumnValue(columnName);
            }
            return arguments;
        }

        static {
            long orderByColumnsBitmask = 0L;
            _ORDER_BY_COLUMNS_BITMASK = orderByColumnsBitmask |= MessageModelImpl.getColumnBitmask("sentDate");
        }
    }
}

