/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mail.reader.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.mail.reader.model.Folder;
import com.liferay.mail.reader.service.FolderLocalService;
import com.liferay.mail.reader.service.FolderLocalServiceUtil;
import com.liferay.mail.reader.service.persistence.AccountPersistence;
import com.liferay.mail.reader.service.persistence.AttachmentPersistence;
import com.liferay.mail.reader.service.persistence.FolderPersistence;
import com.liferay.mail.reader.service.persistence.MessagePersistence;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.io.Serializable;
import java.sql.Connection;
import java.util.List;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

public abstract class FolderLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements AopService,
FolderLocalService,
IdentifiableOSGiService {
    @Reference
    protected AccountPersistence accountPersistence;
    @Reference
    protected AttachmentPersistence attachmentPersistence;
    protected FolderLocalService folderLocalService;
    @Reference
    protected FolderPersistence folderPersistence;
    @Reference
    protected MessagePersistence messagePersistence;
    @Reference
    protected CounterLocalService counterLocalService;
    @Reference
    protected ClassNameLocalService classNameLocalService;
    @Reference
    protected ResourceLocalService resourceLocalService;
    @Reference
    protected UserLocalService userLocalService;
    private static final Log _log = LogFactoryUtil.getLog(FolderLocalServiceBaseImpl.class);

    @Indexable(type=IndexableType.REINDEX)
    public Folder addFolder(Folder folder) {
        folder.setNew(true);
        return (Folder)this.folderPersistence.update((BaseModel)folder);
    }

    @Transactional(enabled=false)
    public Folder createFolder(long folderId) {
        return this.folderPersistence.create(folderId);
    }

    @Indexable(type=IndexableType.DELETE)
    public Folder deleteFolder(long folderId) throws PortalException {
        return this.folderPersistence.remove(folderId);
    }

    @Indexable(type=IndexableType.DELETE)
    public Folder deleteFolder(Folder folder) throws PortalException {
        return (Folder)this.folderPersistence.remove((BaseModel)folder);
    }

    public <T> T dslQuery(DSLQuery dslQuery) {
        return (T)this.folderPersistence.dslQuery(dslQuery);
    }

    public int dslQueryCount(DSLQuery dslQuery) {
        Long count = (Long)this.dslQuery(dslQuery);
        return count.intValue();
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(Folder.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.folderPersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.folderPersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.folderPersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.folderPersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.folderPersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public Folder fetchFolder(long folderId) {
        return this.folderPersistence.fetchByPrimaryKey(folderId);
    }

    public Folder getFolder(long folderId) throws PortalException {
        return this.folderPersistence.findByPrimaryKey(folderId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.folderLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(Folder.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("folderId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.folderLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(Folder.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("folderId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.folderLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(Folder.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("folderId");
    }

    public PersistedModel createPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return this.folderPersistence.create(((Long)primaryKeyObj).longValue());
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        return this.folderLocalService.deleteFolder((Folder)persistedModel);
    }

    public BasePersistence<Folder> getBasePersistence() {
        return this.folderPersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.folderPersistence.findByPrimaryKey(primaryKeyObj);
    }

    public List<Folder> getFolders(int start, int end) {
        return this.folderPersistence.findAll(start, end);
    }

    public int getFoldersCount() {
        return this.folderPersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public Folder updateFolder(Folder folder) {
        return (Folder)this.folderPersistence.update((BaseModel)folder);
    }

    @Deactivate
    protected void deactivate() {
        FolderLocalServiceUtil.setService(null);
    }

    public Class<?>[] getAopInterfaces() {
        return new Class[]{FolderLocalService.class, IdentifiableOSGiService.class, PersistedModelLocalService.class};
    }

    public void setAopProxy(Object aopProxy) {
        this.folderLocalService = (FolderLocalService)aopProxy;
        FolderLocalServiceUtil.setService((FolderLocalService)this.folderLocalService);
    }

    public String getOSGiServiceIdentifier() {
        return FolderLocalService.class.getName();
    }

    protected Class<?> getModelClass() {
        return Folder.class;
    }

    protected String getModelClassName() {
        return Folder.class.getName();
    }

    protected void runSQL(String sql) {
        DataSource dataSource = this.folderPersistence.getDataSource();
        DB db = DBManagerUtil.getDB();
        Connection currentConnection = CurrentConnectionUtil.getConnection((DataSource)dataSource);
        try {
            if (currentConnection != null) {
                db.runSQL(currentConnection, new String[]{sql});
                return;
            }
            try (Connection connection = dataSource.getConnection();){
                db.runSQL(connection, new String[]{sql});
            }
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }
}

