/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.mail.reader.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.mail.reader.model.Account;
import com.liferay.mail.reader.model.AccountModel;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the Account service. Represents a row in the &quot;Mail_Account&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>AccountModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link AccountImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see AccountImpl
 * @generated
 */
public class AccountModelImpl
	extends BaseModelImpl<Account> implements AccountModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a account model instance should use the <code>Account</code> interface instead.
	 */
	public static final String TABLE_NAME = "Mail_Account";

	public static final Object[][] TABLE_COLUMNS = {
		{"accountId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"address", Types.VARCHAR}, {"personalName", Types.VARCHAR},
		{"protocol", Types.VARCHAR}, {"incomingHostName", Types.VARCHAR},
		{"incomingPort", Types.INTEGER}, {"incomingSecure", Types.BOOLEAN},
		{"outgoingHostName", Types.VARCHAR}, {"outgoingPort", Types.INTEGER},
		{"outgoingSecure", Types.BOOLEAN}, {"login", Types.VARCHAR},
		{"password_", Types.VARCHAR}, {"savePassword", Types.BOOLEAN},
		{"signature", Types.VARCHAR}, {"useSignature", Types.BOOLEAN},
		{"folderPrefix", Types.VARCHAR}, {"inboxFolderId", Types.BIGINT},
		{"draftFolderId", Types.BIGINT}, {"sentFolderId", Types.BIGINT},
		{"trashFolderId", Types.BIGINT}, {"defaultSender", Types.BOOLEAN}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("accountId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("address", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("personalName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("protocol", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("incomingHostName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("incomingPort", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("incomingSecure", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("outgoingHostName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("outgoingPort", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("outgoingSecure", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("login", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("password_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("savePassword", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("signature", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("useSignature", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("folderPrefix", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("inboxFolderId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("draftFolderId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("sentFolderId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("trashFolderId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("defaultSender", Types.BOOLEAN);
	}

	public static final String TABLE_SQL_CREATE =
		"create table Mail_Account (accountId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,address VARCHAR(75) null,personalName VARCHAR(75) null,protocol VARCHAR(75) null,incomingHostName VARCHAR(75) null,incomingPort INTEGER,incomingSecure BOOLEAN,outgoingHostName VARCHAR(75) null,outgoingPort INTEGER,outgoingSecure BOOLEAN,login VARCHAR(75) null,password_ VARCHAR(75) null,savePassword BOOLEAN,signature VARCHAR(75) null,useSignature BOOLEAN,folderPrefix VARCHAR(75) null,inboxFolderId LONG,draftFolderId LONG,sentFolderId LONG,trashFolderId LONG,defaultSender BOOLEAN)";

	public static final String TABLE_SQL_DROP = "drop table Mail_Account";

	public static final String ORDER_BY_JPQL = " ORDER BY account.address ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY Mail_Account.address ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long ADDRESS_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long USERID_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public AccountModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _accountId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setAccountId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _accountId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return Account.class;
	}

	@Override
	public String getModelClassName() {
		return Account.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<Account, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		for (Map.Entry<String, Function<Account, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<Account, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName, attributeGetterFunction.apply((Account)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<Account, Object>> attributeSetterBiConsumers =
			getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<Account, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(Account)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<Account, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<Account, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static final Map<String, Function<Account, Object>>
		_attributeGetterFunctions;

	static {
		Map<String, Function<Account, Object>> attributeGetterFunctions =
			new LinkedHashMap<String, Function<Account, Object>>();

		attributeGetterFunctions.put("accountId", Account::getAccountId);
		attributeGetterFunctions.put("companyId", Account::getCompanyId);
		attributeGetterFunctions.put("userId", Account::getUserId);
		attributeGetterFunctions.put("userName", Account::getUserName);
		attributeGetterFunctions.put("createDate", Account::getCreateDate);
		attributeGetterFunctions.put("modifiedDate", Account::getModifiedDate);
		attributeGetterFunctions.put("address", Account::getAddress);
		attributeGetterFunctions.put("personalName", Account::getPersonalName);
		attributeGetterFunctions.put("protocol", Account::getProtocol);
		attributeGetterFunctions.put(
			"incomingHostName", Account::getIncomingHostName);
		attributeGetterFunctions.put("incomingPort", Account::getIncomingPort);
		attributeGetterFunctions.put(
			"incomingSecure", Account::getIncomingSecure);
		attributeGetterFunctions.put(
			"outgoingHostName", Account::getOutgoingHostName);
		attributeGetterFunctions.put("outgoingPort", Account::getOutgoingPort);
		attributeGetterFunctions.put(
			"outgoingSecure", Account::getOutgoingSecure);
		attributeGetterFunctions.put("login", Account::getLogin);
		attributeGetterFunctions.put("password", Account::getPassword);
		attributeGetterFunctions.put("savePassword", Account::getSavePassword);
		attributeGetterFunctions.put("signature", Account::getSignature);
		attributeGetterFunctions.put("useSignature", Account::getUseSignature);
		attributeGetterFunctions.put("folderPrefix", Account::getFolderPrefix);
		attributeGetterFunctions.put(
			"inboxFolderId", Account::getInboxFolderId);
		attributeGetterFunctions.put(
			"draftFolderId", Account::getDraftFolderId);
		attributeGetterFunctions.put("sentFolderId", Account::getSentFolderId);
		attributeGetterFunctions.put(
			"trashFolderId", Account::getTrashFolderId);
		attributeGetterFunctions.put(
			"defaultSender", Account::getDefaultSender);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
	}

	private static final Map<String, BiConsumer<Account, Object>>
		_attributeSetterBiConsumers;

	static {
		Map<String, BiConsumer<Account, ?>> attributeSetterBiConsumers =
			new LinkedHashMap<String, BiConsumer<Account, ?>>();

		attributeSetterBiConsumers.put(
			"accountId", (BiConsumer<Account, Long>)Account::setAccountId);
		attributeSetterBiConsumers.put(
			"companyId", (BiConsumer<Account, Long>)Account::setCompanyId);
		attributeSetterBiConsumers.put(
			"userId", (BiConsumer<Account, Long>)Account::setUserId);
		attributeSetterBiConsumers.put(
			"userName", (BiConsumer<Account, String>)Account::setUserName);
		attributeSetterBiConsumers.put(
			"createDate", (BiConsumer<Account, Date>)Account::setCreateDate);
		attributeSetterBiConsumers.put(
			"modifiedDate",
			(BiConsumer<Account, Date>)Account::setModifiedDate);
		attributeSetterBiConsumers.put(
			"address", (BiConsumer<Account, String>)Account::setAddress);
		attributeSetterBiConsumers.put(
			"personalName",
			(BiConsumer<Account, String>)Account::setPersonalName);
		attributeSetterBiConsumers.put(
			"protocol", (BiConsumer<Account, String>)Account::setProtocol);
		attributeSetterBiConsumers.put(
			"incomingHostName",
			(BiConsumer<Account, String>)Account::setIncomingHostName);
		attributeSetterBiConsumers.put(
			"incomingPort",
			(BiConsumer<Account, Integer>)Account::setIncomingPort);
		attributeSetterBiConsumers.put(
			"incomingSecure",
			(BiConsumer<Account, Boolean>)Account::setIncomingSecure);
		attributeSetterBiConsumers.put(
			"outgoingHostName",
			(BiConsumer<Account, String>)Account::setOutgoingHostName);
		attributeSetterBiConsumers.put(
			"outgoingPort",
			(BiConsumer<Account, Integer>)Account::setOutgoingPort);
		attributeSetterBiConsumers.put(
			"outgoingSecure",
			(BiConsumer<Account, Boolean>)Account::setOutgoingSecure);
		attributeSetterBiConsumers.put(
			"login", (BiConsumer<Account, String>)Account::setLogin);
		attributeSetterBiConsumers.put(
			"password", (BiConsumer<Account, String>)Account::setPassword);
		attributeSetterBiConsumers.put(
			"savePassword",
			(BiConsumer<Account, Boolean>)Account::setSavePassword);
		attributeSetterBiConsumers.put(
			"signature", (BiConsumer<Account, String>)Account::setSignature);
		attributeSetterBiConsumers.put(
			"useSignature",
			(BiConsumer<Account, Boolean>)Account::setUseSignature);
		attributeSetterBiConsumers.put(
			"folderPrefix",
			(BiConsumer<Account, String>)Account::setFolderPrefix);
		attributeSetterBiConsumers.put(
			"inboxFolderId",
			(BiConsumer<Account, Long>)Account::setInboxFolderId);
		attributeSetterBiConsumers.put(
			"draftFolderId",
			(BiConsumer<Account, Long>)Account::setDraftFolderId);
		attributeSetterBiConsumers.put(
			"sentFolderId",
			(BiConsumer<Account, Long>)Account::setSentFolderId);
		attributeSetterBiConsumers.put(
			"trashFolderId",
			(BiConsumer<Account, Long>)Account::setTrashFolderId);
		attributeSetterBiConsumers.put(
			"defaultSender",
			(BiConsumer<Account, Boolean>)Account::setDefaultSender);

		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@Override
	public long getAccountId() {
		return _accountId;
	}

	@Override
	public void setAccountId(long accountId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_accountId = accountId;
	}

	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalUserId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("userId"));
	}

	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@Override
	public String getAddress() {
		if (_address == null) {
			return "";
		}
		else {
			return _address;
		}
	}

	@Override
	public void setAddress(String address) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_address = address;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalAddress() {
		return getColumnOriginalValue("address");
	}

	@Override
	public String getPersonalName() {
		if (_personalName == null) {
			return "";
		}
		else {
			return _personalName;
		}
	}

	@Override
	public void setPersonalName(String personalName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_personalName = personalName;
	}

	@Override
	public String getProtocol() {
		if (_protocol == null) {
			return "";
		}
		else {
			return _protocol;
		}
	}

	@Override
	public void setProtocol(String protocol) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_protocol = protocol;
	}

	@Override
	public String getIncomingHostName() {
		if (_incomingHostName == null) {
			return "";
		}
		else {
			return _incomingHostName;
		}
	}

	@Override
	public void setIncomingHostName(String incomingHostName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_incomingHostName = incomingHostName;
	}

	@Override
	public int getIncomingPort() {
		return _incomingPort;
	}

	@Override
	public void setIncomingPort(int incomingPort) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_incomingPort = incomingPort;
	}

	@Override
	public boolean getIncomingSecure() {
		return _incomingSecure;
	}

	@Override
	public boolean isIncomingSecure() {
		return _incomingSecure;
	}

	@Override
	public void setIncomingSecure(boolean incomingSecure) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_incomingSecure = incomingSecure;
	}

	@Override
	public String getOutgoingHostName() {
		if (_outgoingHostName == null) {
			return "";
		}
		else {
			return _outgoingHostName;
		}
	}

	@Override
	public void setOutgoingHostName(String outgoingHostName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_outgoingHostName = outgoingHostName;
	}

	@Override
	public int getOutgoingPort() {
		return _outgoingPort;
	}

	@Override
	public void setOutgoingPort(int outgoingPort) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_outgoingPort = outgoingPort;
	}

	@Override
	public boolean getOutgoingSecure() {
		return _outgoingSecure;
	}

	@Override
	public boolean isOutgoingSecure() {
		return _outgoingSecure;
	}

	@Override
	public void setOutgoingSecure(boolean outgoingSecure) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_outgoingSecure = outgoingSecure;
	}

	@Override
	public String getLogin() {
		if (_login == null) {
			return "";
		}
		else {
			return _login;
		}
	}

	@Override
	public void setLogin(String login) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_login = login;
	}

	@Override
	public String getPassword() {
		if (_password == null) {
			return "";
		}
		else {
			return _password;
		}
	}

	@Override
	public void setPassword(String password) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_password = password;
	}

	@Override
	public boolean getSavePassword() {
		return _savePassword;
	}

	@Override
	public boolean isSavePassword() {
		return _savePassword;
	}

	@Override
	public void setSavePassword(boolean savePassword) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_savePassword = savePassword;
	}

	@Override
	public String getSignature() {
		if (_signature == null) {
			return "";
		}
		else {
			return _signature;
		}
	}

	@Override
	public void setSignature(String signature) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_signature = signature;
	}

	@Override
	public boolean getUseSignature() {
		return _useSignature;
	}

	@Override
	public boolean isUseSignature() {
		return _useSignature;
	}

	@Override
	public void setUseSignature(boolean useSignature) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_useSignature = useSignature;
	}

	@Override
	public String getFolderPrefix() {
		if (_folderPrefix == null) {
			return "";
		}
		else {
			return _folderPrefix;
		}
	}

	@Override
	public void setFolderPrefix(String folderPrefix) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_folderPrefix = folderPrefix;
	}

	@Override
	public long getInboxFolderId() {
		return _inboxFolderId;
	}

	@Override
	public void setInboxFolderId(long inboxFolderId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_inboxFolderId = inboxFolderId;
	}

	@Override
	public long getDraftFolderId() {
		return _draftFolderId;
	}

	@Override
	public void setDraftFolderId(long draftFolderId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_draftFolderId = draftFolderId;
	}

	@Override
	public long getSentFolderId() {
		return _sentFolderId;
	}

	@Override
	public void setSentFolderId(long sentFolderId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_sentFolderId = sentFolderId;
	}

	@Override
	public long getTrashFolderId() {
		return _trashFolderId;
	}

	@Override
	public void setTrashFolderId(long trashFolderId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_trashFolderId = trashFolderId;
	}

	@Override
	public boolean getDefaultSender() {
		return _defaultSender;
	}

	@Override
	public boolean isDefaultSender() {
		return _defaultSender;
	}

	@Override
	public void setDefaultSender(boolean defaultSender) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_defaultSender = defaultSender;
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), Account.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public Account toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, Account>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		AccountImpl accountImpl = new AccountImpl();

		accountImpl.setAccountId(getAccountId());
		accountImpl.setCompanyId(getCompanyId());
		accountImpl.setUserId(getUserId());
		accountImpl.setUserName(getUserName());
		accountImpl.setCreateDate(getCreateDate());
		accountImpl.setModifiedDate(getModifiedDate());
		accountImpl.setAddress(getAddress());
		accountImpl.setPersonalName(getPersonalName());
		accountImpl.setProtocol(getProtocol());
		accountImpl.setIncomingHostName(getIncomingHostName());
		accountImpl.setIncomingPort(getIncomingPort());
		accountImpl.setIncomingSecure(isIncomingSecure());
		accountImpl.setOutgoingHostName(getOutgoingHostName());
		accountImpl.setOutgoingPort(getOutgoingPort());
		accountImpl.setOutgoingSecure(isOutgoingSecure());
		accountImpl.setLogin(getLogin());
		accountImpl.setPassword(getPassword());
		accountImpl.setSavePassword(isSavePassword());
		accountImpl.setSignature(getSignature());
		accountImpl.setUseSignature(isUseSignature());
		accountImpl.setFolderPrefix(getFolderPrefix());
		accountImpl.setInboxFolderId(getInboxFolderId());
		accountImpl.setDraftFolderId(getDraftFolderId());
		accountImpl.setSentFolderId(getSentFolderId());
		accountImpl.setTrashFolderId(getTrashFolderId());
		accountImpl.setDefaultSender(isDefaultSender());

		accountImpl.resetOriginalValues();

		return accountImpl;
	}

	@Override
	public int compareTo(Account account) {
		int value = 0;

		value = getAddress().compareTo(account.getAddress());

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof Account)) {
			return false;
		}

		Account account = (Account)object;

		long primaryKey = account.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<Account> toCacheModel() {
		AccountCacheModel accountCacheModel = new AccountCacheModel();

		accountCacheModel.accountId = getAccountId();

		accountCacheModel.companyId = getCompanyId();

		accountCacheModel.userId = getUserId();

		accountCacheModel.userName = getUserName();

		String userName = accountCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			accountCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			accountCacheModel.createDate = createDate.getTime();
		}
		else {
			accountCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			accountCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			accountCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		accountCacheModel.address = getAddress();

		String address = accountCacheModel.address;

		if ((address != null) && (address.length() == 0)) {
			accountCacheModel.address = null;
		}

		accountCacheModel.personalName = getPersonalName();

		String personalName = accountCacheModel.personalName;

		if ((personalName != null) && (personalName.length() == 0)) {
			accountCacheModel.personalName = null;
		}

		accountCacheModel.protocol = getProtocol();

		String protocol = accountCacheModel.protocol;

		if ((protocol != null) && (protocol.length() == 0)) {
			accountCacheModel.protocol = null;
		}

		accountCacheModel.incomingHostName = getIncomingHostName();

		String incomingHostName = accountCacheModel.incomingHostName;

		if ((incomingHostName != null) && (incomingHostName.length() == 0)) {
			accountCacheModel.incomingHostName = null;
		}

		accountCacheModel.incomingPort = getIncomingPort();

		accountCacheModel.incomingSecure = isIncomingSecure();

		accountCacheModel.outgoingHostName = getOutgoingHostName();

		String outgoingHostName = accountCacheModel.outgoingHostName;

		if ((outgoingHostName != null) && (outgoingHostName.length() == 0)) {
			accountCacheModel.outgoingHostName = null;
		}

		accountCacheModel.outgoingPort = getOutgoingPort();

		accountCacheModel.outgoingSecure = isOutgoingSecure();

		accountCacheModel.login = getLogin();

		String login = accountCacheModel.login;

		if ((login != null) && (login.length() == 0)) {
			accountCacheModel.login = null;
		}

		accountCacheModel.password = getPassword();

		String password = accountCacheModel.password;

		if ((password != null) && (password.length() == 0)) {
			accountCacheModel.password = null;
		}

		accountCacheModel.savePassword = isSavePassword();

		accountCacheModel.signature = getSignature();

		String signature = accountCacheModel.signature;

		if ((signature != null) && (signature.length() == 0)) {
			accountCacheModel.signature = null;
		}

		accountCacheModel.useSignature = isUseSignature();

		accountCacheModel.folderPrefix = getFolderPrefix();

		String folderPrefix = accountCacheModel.folderPrefix;

		if ((folderPrefix != null) && (folderPrefix.length() == 0)) {
			accountCacheModel.folderPrefix = null;
		}

		accountCacheModel.inboxFolderId = getInboxFolderId();

		accountCacheModel.draftFolderId = getDraftFolderId();

		accountCacheModel.sentFolderId = getSentFolderId();

		accountCacheModel.trashFolderId = getTrashFolderId();

		accountCacheModel.defaultSender = isDefaultSender();

		return accountCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<Account, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<Account, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<Account, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply((Account)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<Account, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<Account, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<Account, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(attributeGetterFunction.apply((Account)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, Account>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					Account.class, ModelWrapper.class);

	}

	private long _accountId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private String _address;
	private String _personalName;
	private String _protocol;
	private String _incomingHostName;
	private int _incomingPort;
	private boolean _incomingSecure;
	private String _outgoingHostName;
	private int _outgoingPort;
	private boolean _outgoingSecure;
	private String _login;
	private String _password;
	private boolean _savePassword;
	private String _signature;
	private boolean _useSignature;
	private String _folderPrefix;
	private long _inboxFolderId;
	private long _draftFolderId;
	private long _sentFolderId;
	private long _trashFolderId;
	private boolean _defaultSender;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<Account, Object> function = _attributeGetterFunctions.get(
			columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((Account)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("accountId", _accountId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("address", _address);
		_columnOriginalValues.put("personalName", _personalName);
		_columnOriginalValues.put("protocol", _protocol);
		_columnOriginalValues.put("incomingHostName", _incomingHostName);
		_columnOriginalValues.put("incomingPort", _incomingPort);
		_columnOriginalValues.put("incomingSecure", _incomingSecure);
		_columnOriginalValues.put("outgoingHostName", _outgoingHostName);
		_columnOriginalValues.put("outgoingPort", _outgoingPort);
		_columnOriginalValues.put("outgoingSecure", _outgoingSecure);
		_columnOriginalValues.put("login", _login);
		_columnOriginalValues.put("password_", _password);
		_columnOriginalValues.put("savePassword", _savePassword);
		_columnOriginalValues.put("signature", _signature);
		_columnOriginalValues.put("useSignature", _useSignature);
		_columnOriginalValues.put("folderPrefix", _folderPrefix);
		_columnOriginalValues.put("inboxFolderId", _inboxFolderId);
		_columnOriginalValues.put("draftFolderId", _draftFolderId);
		_columnOriginalValues.put("sentFolderId", _sentFolderId);
		_columnOriginalValues.put("trashFolderId", _trashFolderId);
		_columnOriginalValues.put("defaultSender", _defaultSender);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("password_", "password");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("accountId", 1L);

		columnBitmasks.put("companyId", 2L);

		columnBitmasks.put("userId", 4L);

		columnBitmasks.put("userName", 8L);

		columnBitmasks.put("createDate", 16L);

		columnBitmasks.put("modifiedDate", 32L);

		columnBitmasks.put("address", 64L);

		columnBitmasks.put("personalName", 128L);

		columnBitmasks.put("protocol", 256L);

		columnBitmasks.put("incomingHostName", 512L);

		columnBitmasks.put("incomingPort", 1024L);

		columnBitmasks.put("incomingSecure", 2048L);

		columnBitmasks.put("outgoingHostName", 4096L);

		columnBitmasks.put("outgoingPort", 8192L);

		columnBitmasks.put("outgoingSecure", 16384L);

		columnBitmasks.put("login", 32768L);

		columnBitmasks.put("password_", 65536L);

		columnBitmasks.put("savePassword", 131072L);

		columnBitmasks.put("signature", 262144L);

		columnBitmasks.put("useSignature", 524288L);

		columnBitmasks.put("folderPrefix", 1048576L);

		columnBitmasks.put("inboxFolderId", 2097152L);

		columnBitmasks.put("draftFolderId", 4194304L);

		columnBitmasks.put("sentFolderId", 8388608L);

		columnBitmasks.put("trashFolderId", 16777216L);

		columnBitmasks.put("defaultSender", 33554432L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private Account _escapedModel;

}