/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mail.reader.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.mail.reader.model.Attachment;
import com.liferay.mail.reader.service.AttachmentLocalService;
import com.liferay.mail.reader.service.AttachmentLocalServiceUtil;
import com.liferay.mail.reader.service.persistence.AccountPersistence;
import com.liferay.mail.reader.service.persistence.AttachmentPersistence;
import com.liferay.mail.reader.service.persistence.FolderPersistence;
import com.liferay.mail.reader.service.persistence.MessagePersistence;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.io.Serializable;
import java.sql.Connection;
import java.util.List;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

public abstract class AttachmentLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements AopService,
AttachmentLocalService,
IdentifiableOSGiService {
    @Reference
    protected AccountPersistence accountPersistence;
    protected AttachmentLocalService attachmentLocalService;
    @Reference
    protected AttachmentPersistence attachmentPersistence;
    @Reference
    protected FolderPersistence folderPersistence;
    @Reference
    protected MessagePersistence messagePersistence;
    @Reference
    protected CounterLocalService counterLocalService;
    @Reference
    protected ClassNameLocalService classNameLocalService;
    @Reference
    protected ResourceLocalService resourceLocalService;
    @Reference
    protected UserLocalService userLocalService;
    private static final Log _log = LogFactoryUtil.getLog(AttachmentLocalServiceBaseImpl.class);

    @Indexable(type=IndexableType.REINDEX)
    public Attachment addAttachment(Attachment attachment) {
        attachment.setNew(true);
        return (Attachment)this.attachmentPersistence.update((BaseModel)attachment);
    }

    @Transactional(enabled=false)
    public Attachment createAttachment(long attachmentId) {
        return this.attachmentPersistence.create(attachmentId);
    }

    @Indexable(type=IndexableType.DELETE)
    public Attachment deleteAttachment(long attachmentId) throws PortalException {
        return this.attachmentPersistence.remove(attachmentId);
    }

    @Indexable(type=IndexableType.DELETE)
    public Attachment deleteAttachment(Attachment attachment) {
        return (Attachment)this.attachmentPersistence.remove((BaseModel)attachment);
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(Attachment.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.attachmentPersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.attachmentPersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.attachmentPersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.attachmentPersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.attachmentPersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public Attachment fetchAttachment(long attachmentId) {
        return this.attachmentPersistence.fetchByPrimaryKey(attachmentId);
    }

    public Attachment getAttachment(long attachmentId) throws PortalException {
        return this.attachmentPersistence.findByPrimaryKey(attachmentId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.attachmentLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(Attachment.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("attachmentId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.attachmentLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(Attachment.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("attachmentId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.attachmentLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(Attachment.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("attachmentId");
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        return this.attachmentLocalService.deleteAttachment((Attachment)persistedModel);
    }

    public BasePersistence<Attachment> getBasePersistence() {
        return this.attachmentPersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.attachmentPersistence.findByPrimaryKey(primaryKeyObj);
    }

    public List<Attachment> getAttachments(int start, int end) {
        return this.attachmentPersistence.findAll(start, end);
    }

    public int getAttachmentsCount() {
        return this.attachmentPersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public Attachment updateAttachment(Attachment attachment) {
        return (Attachment)this.attachmentPersistence.update((BaseModel)attachment);
    }

    @Deactivate
    protected void deactivate() {
        AttachmentLocalServiceUtil.setService(null);
    }

    public Class<?>[] getAopInterfaces() {
        return new Class[]{AttachmentLocalService.class, IdentifiableOSGiService.class, PersistedModelLocalService.class};
    }

    public void setAopProxy(Object aopProxy) {
        this.attachmentLocalService = (AttachmentLocalService)aopProxy;
        AttachmentLocalServiceUtil.setService((AttachmentLocalService)this.attachmentLocalService);
    }

    public String getOSGiServiceIdentifier() {
        return AttachmentLocalService.class.getName();
    }

    protected Class<?> getModelClass() {
        return Attachment.class;
    }

    protected String getModelClassName() {
        return Attachment.class.getName();
    }

    protected void runSQL(String sql) {
        DataSource dataSource = this.attachmentPersistence.getDataSource();
        DB db = DBManagerUtil.getDB();
        Connection currentConnection = CurrentConnectionUtil.getConnection((DataSource)dataSource);
        try {
            if (currentConnection != null) {
                db.runSQL(currentConnection, new String[]{sql});
                return;
            }
            try (Connection connection = dataSource.getConnection();){
                db.runSQL(connection, new String[]{sql});
            }
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }
}

