/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mail.reader.internal.search;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeIndexerUtil;
import com.liferay.mail.reader.model.Folder;
import com.liferay.mail.reader.service.FolderLocalService;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.IndexSearcherHelper;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SortFactoryUtil;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.ArrayList;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={Indexer.class})
public class FolderIndexer
extends BaseIndexer<Folder> {
    public static final String CLASS_NAME = Folder.class.getName();
    @Reference
    protected FolderLocalService folderLocalService;
    @Reference
    protected IndexSearcherHelper indexSearcherHelper;
    @Reference
    protected IndexWriterHelper indexWriterHelper;
    private static final Log _log = LogFactoryUtil.getLog(FolderIndexer.class);

    public String getClassName() {
        return CLASS_NAME;
    }

    protected void doDelete(Folder folder) throws Exception {
        SearchContext searchContext = new SearchContext();
        searchContext.setCompanyId(folder.getCompanyId());
        searchContext.setEnd(-1);
        searchContext.setSearchEngineId(this.getSearchEngineId());
        searchContext.setSorts(SortFactoryUtil.getDefaultSorts());
        searchContext.setStart(-1);
        BooleanQueryImpl booleanQuery = new BooleanQueryImpl();
        booleanQuery.addRequiredTerm("entryClassName", CLASS_NAME);
        booleanQuery.addRequiredTerm("folderId", folder.getFolderId());
        Hits hits = this.indexSearcherHelper.search(searchContext, (Query)booleanQuery);
        ArrayList<String> uids = new ArrayList<String>(hits.getLength());
        for (int i = 0; i < hits.getLength(); ++i) {
            Document document = hits.doc(i);
            uids.add(document.get("uid"));
        }
        this.indexWriterHelper.deleteDocuments(this.getSearchEngineId(), folder.getCompanyId(), uids, this.isCommitImmediately());
    }

    protected Document doGetDocument(Folder folder) throws Exception {
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)folder);
        ExpandoBridge expandoBridge = folder.getExpandoBridge();
        document.addKeyword("folderId", folder.getFolderId());
        document.addText("name", folder.getDisplayName());
        document.addKeyword("accountId", folder.getAccountId());
        ExpandoBridgeIndexerUtil.addAttributes((Document)document, (ExpandoBridge)expandoBridge);
        return document;
    }

    protected Summary doGetSummary(Document doc, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) {
        return null;
    }

    protected void doReindex(Folder folder) throws Exception {
        Document document = this.getDocument(folder);
        this.indexWriterHelper.updateDocument(this.getSearchEngineId(), folder.getCompanyId(), document, this.isCommitImmediately());
    }

    protected void doReindex(String className, long classPK) throws Exception {
        Folder folder = this.folderLocalService.getFolder(classPK);
        this.doReindex(folder);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexMessages(companyId);
    }

    protected void reindexMessages(long companyId) throws PortalException {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = this.folderLocalService.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod(folder -> {
            block2: {
                try {
                    Document document = this.getDocument(folder);
                    indexableActionableDynamicQuery.addDocuments(new Document[]{document});
                }
                catch (PortalException pe) {
                    if (!_log.isWarnEnabled()) break block2;
                    _log.warn((Object)("Unable to index folder " + folder.getFolderId()), (Throwable)pe);
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }
}

