/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mail.reader.internal.messaging;

import com.liferay.mail.reader.exception.NoSuchAccountException;
import com.liferay.mail.reader.internal.mailbox.MailboxFactoryUtil;
import com.liferay.mail.reader.mailbox.Mailbox;
import com.liferay.mail.reader.service.AccountLocalServiceUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.Validator;

public class MailSynchronizationMessageListener
extends BaseMessageListener {
    private static final Log _log = LogFactoryUtil.getLog(MailSynchronizationMessageListener.class);

    protected void doReceive(Message message) throws Exception {
        String command = message.getString("command");
        if (command.equals("synchronize")) {
            this.synchronize(message);
        } else if (command.equals("flag")) {
            this.flagMessage(message);
        }
    }

    protected void flagMessage(Message message) throws Exception {
        String password = message.getString("password");
        long messageId = message.getLong("messageId");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Flagging message for messageId " + messageId));
        }
        if (Validator.isNull((String)password)) {
            return;
        }
        long userId = message.getLong("userId");
        long accountId = message.getLong("accountId");
        long folderId = message.getLong("folderId");
        int flag = message.getInteger("flag");
        boolean flagValue = message.getBoolean("flagValue");
        Mailbox mailbox = MailboxFactoryUtil.getMailbox(UserLocalServiceUtil.getUser((long)userId), AccountLocalServiceUtil.getAccount((long)accountId), password);
        mailbox.updateFlags(folderId, new long[]{messageId}, flag, flagValue);
    }

    protected void synchronize(Message message) throws Exception {
        block12: {
            long userId = message.getLong("userId");
            long accountId = message.getLong("accountId");
            String password = message.getString("password");
            long folderId = message.getLong("folderId");
            long messageId = message.getLong("messageId");
            int pageNumber = message.getInteger("pageNumber");
            int messagesPerPage = message.getInteger("messagesPerPage");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Starting synch for accountId ", accountId, " folderId ", folderId, " and messageId ", messageId}));
            }
            try {
                if (!password.equals("")) {
                    Mailbox mailbox = MailboxFactoryUtil.getMailbox(UserLocalServiceUtil.getUser((long)userId), AccountLocalServiceUtil.getAccount((long)accountId), password);
                    if (messageId != 0L) {
                        mailbox.synchronizeMessage(messageId);
                    } else if (folderId != 0L) {
                        if (pageNumber != 0) {
                            mailbox.synchronizePage(folderId, pageNumber, messagesPerPage);
                        } else {
                            mailbox.synchronizeFolder(folderId);
                        }
                    } else {
                        mailbox.synchronize();
                    }
                } else if (_log.isDebugEnabled()) {
                    _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Unable to acquire synch lock for accountId ", accountId, " and folderId ", folderId, " and messageId ", messageId}));
                }
            }
            catch (NoSuchAccountException nsae) {
                if (!_log.isDebugEnabled()) break block12;
                _log.debug((Object)("Skipping syncronization of accountId " + accountId));
            }
        }
    }
}

