/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.mail.reader.model.impl;

import com.liferay.mail.reader.model.Message;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.util.HashUtil;
import com.liferay.portal.kernel.util.StringBundler;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

import java.util.Date;

/**
 * The cache model class for representing Message in entity cache.
 *
 * @author Brian Wing Shun Chan
 * @generated
 */
public class MessageCacheModel implements CacheModel<Message>, Externalizable {

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof MessageCacheModel)) {
			return false;
		}

		MessageCacheModel messageCacheModel = (MessageCacheModel)object;

		if (messageId == messageCacheModel.messageId) {
			return true;
		}

		return false;
	}

	@Override
	public int hashCode() {
		return HashUtil.hash(0, messageId);
	}

	@Override
	public String toString() {
		StringBundler sb = new StringBundler(41);

		sb.append("{messageId=");
		sb.append(messageId);
		sb.append(", companyId=");
		sb.append(companyId);
		sb.append(", userId=");
		sb.append(userId);
		sb.append(", userName=");
		sb.append(userName);
		sb.append(", createDate=");
		sb.append(createDate);
		sb.append(", modifiedDate=");
		sb.append(modifiedDate);
		sb.append(", accountId=");
		sb.append(accountId);
		sb.append(", folderId=");
		sb.append(folderId);
		sb.append(", sender=");
		sb.append(sender);
		sb.append(", to=");
		sb.append(to);
		sb.append(", cc=");
		sb.append(cc);
		sb.append(", bcc=");
		sb.append(bcc);
		sb.append(", sentDate=");
		sb.append(sentDate);
		sb.append(", subject=");
		sb.append(subject);
		sb.append(", preview=");
		sb.append(preview);
		sb.append(", body=");
		sb.append(body);
		sb.append(", flags=");
		sb.append(flags);
		sb.append(", size=");
		sb.append(size);
		sb.append(", remoteMessageId=");
		sb.append(remoteMessageId);
		sb.append(", contentType=");
		sb.append(contentType);
		sb.append("}");

		return sb.toString();
	}

	@Override
	public Message toEntityModel() {
		MessageImpl messageImpl = new MessageImpl();

		messageImpl.setMessageId(messageId);
		messageImpl.setCompanyId(companyId);
		messageImpl.setUserId(userId);

		if (userName == null) {
			messageImpl.setUserName("");
		}
		else {
			messageImpl.setUserName(userName);
		}

		if (createDate == Long.MIN_VALUE) {
			messageImpl.setCreateDate(null);
		}
		else {
			messageImpl.setCreateDate(new Date(createDate));
		}

		if (modifiedDate == Long.MIN_VALUE) {
			messageImpl.setModifiedDate(null);
		}
		else {
			messageImpl.setModifiedDate(new Date(modifiedDate));
		}

		messageImpl.setAccountId(accountId);
		messageImpl.setFolderId(folderId);

		if (sender == null) {
			messageImpl.setSender("");
		}
		else {
			messageImpl.setSender(sender);
		}

		if (to == null) {
			messageImpl.setTo("");
		}
		else {
			messageImpl.setTo(to);
		}

		if (cc == null) {
			messageImpl.setCc("");
		}
		else {
			messageImpl.setCc(cc);
		}

		if (bcc == null) {
			messageImpl.setBcc("");
		}
		else {
			messageImpl.setBcc(bcc);
		}

		if (sentDate == Long.MIN_VALUE) {
			messageImpl.setSentDate(null);
		}
		else {
			messageImpl.setSentDate(new Date(sentDate));
		}

		if (subject == null) {
			messageImpl.setSubject("");
		}
		else {
			messageImpl.setSubject(subject);
		}

		if (preview == null) {
			messageImpl.setPreview("");
		}
		else {
			messageImpl.setPreview(preview);
		}

		if (body == null) {
			messageImpl.setBody("");
		}
		else {
			messageImpl.setBody(body);
		}

		if (flags == null) {
			messageImpl.setFlags("");
		}
		else {
			messageImpl.setFlags(flags);
		}

		messageImpl.setSize(size);
		messageImpl.setRemoteMessageId(remoteMessageId);

		if (contentType == null) {
			messageImpl.setContentType("");
		}
		else {
			messageImpl.setContentType(contentType);
		}

		messageImpl.resetOriginalValues();

		return messageImpl;
	}

	@Override
	public void readExternal(ObjectInput objectInput)
		throws ClassNotFoundException, IOException {

		messageId = objectInput.readLong();

		companyId = objectInput.readLong();

		userId = objectInput.readLong();
		userName = objectInput.readUTF();
		createDate = objectInput.readLong();
		modifiedDate = objectInput.readLong();

		accountId = objectInput.readLong();

		folderId = objectInput.readLong();
		sender = objectInput.readUTF();
		to = (String)objectInput.readObject();
		cc = (String)objectInput.readObject();
		bcc = (String)objectInput.readObject();
		sentDate = objectInput.readLong();
		subject = objectInput.readUTF();
		preview = objectInput.readUTF();
		body = (String)objectInput.readObject();
		flags = objectInput.readUTF();

		size = objectInput.readLong();

		remoteMessageId = objectInput.readLong();
		contentType = objectInput.readUTF();
	}

	@Override
	public void writeExternal(ObjectOutput objectOutput) throws IOException {
		objectOutput.writeLong(messageId);

		objectOutput.writeLong(companyId);

		objectOutput.writeLong(userId);

		if (userName == null) {
			objectOutput.writeUTF("");
		}
		else {
			objectOutput.writeUTF(userName);
		}

		objectOutput.writeLong(createDate);
		objectOutput.writeLong(modifiedDate);

		objectOutput.writeLong(accountId);

		objectOutput.writeLong(folderId);

		if (sender == null) {
			objectOutput.writeUTF("");
		}
		else {
			objectOutput.writeUTF(sender);
		}

		if (to == null) {
			objectOutput.writeObject("");
		}
		else {
			objectOutput.writeObject(to);
		}

		if (cc == null) {
			objectOutput.writeObject("");
		}
		else {
			objectOutput.writeObject(cc);
		}

		if (bcc == null) {
			objectOutput.writeObject("");
		}
		else {
			objectOutput.writeObject(bcc);
		}

		objectOutput.writeLong(sentDate);

		if (subject == null) {
			objectOutput.writeUTF("");
		}
		else {
			objectOutput.writeUTF(subject);
		}

		if (preview == null) {
			objectOutput.writeUTF("");
		}
		else {
			objectOutput.writeUTF(preview);
		}

		if (body == null) {
			objectOutput.writeObject("");
		}
		else {
			objectOutput.writeObject(body);
		}

		if (flags == null) {
			objectOutput.writeUTF("");
		}
		else {
			objectOutput.writeUTF(flags);
		}

		objectOutput.writeLong(size);

		objectOutput.writeLong(remoteMessageId);

		if (contentType == null) {
			objectOutput.writeUTF("");
		}
		else {
			objectOutput.writeUTF(contentType);
		}
	}

	public long messageId;
	public long companyId;
	public long userId;
	public String userName;
	public long createDate;
	public long modifiedDate;
	public long accountId;
	public long folderId;
	public String sender;
	public String to;
	public String cc;
	public String bcc;
	public long sentDate;
	public String subject;
	public String preview;
	public String body;
	public String flags;
	public long size;
	public long remoteMessageId;
	public String contentType;

}