/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mail.reader.service.persistence.impl;

import aQute.bnd.annotation.ProviderType;
import com.liferay.mail.reader.exception.NoSuchMessageException;
import com.liferay.mail.reader.model.Message;
import com.liferay.mail.reader.model.impl.MessageImpl;
import com.liferay.mail.reader.model.impl.MessageModelImpl;
import com.liferay.mail.reader.service.persistence.MessagePersistence;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.CompanyProvider;
import com.liferay.portal.kernel.service.persistence.CompanyProviderWrapper;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

@ProviderType
public class MessagePersistenceImpl
extends BasePersistenceImpl<Message>
implements MessagePersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = MessageImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByCompanyId;
    private FinderPath _finderPathWithoutPaginationFindByCompanyId;
    private FinderPath _finderPathCountByCompanyId;
    private static final String _FINDER_COLUMN_COMPANYID_COMPANYID_2 = "message.companyId = ?";
    private FinderPath _finderPathWithPaginationFindByFolderId;
    private FinderPath _finderPathWithoutPaginationFindByFolderId;
    private FinderPath _finderPathCountByFolderId;
    private static final String _FINDER_COLUMN_FOLDERID_FOLDERID_2 = "message.folderId = ?";
    private FinderPath _finderPathFetchByF_R;
    private FinderPath _finderPathCountByF_R;
    private static final String _FINDER_COLUMN_F_R_FOLDERID_2 = "message.folderId = ? AND ";
    private static final String _FINDER_COLUMN_F_R_REMOTEMESSAGEID_2 = "message.remoteMessageId = ?";
    @ServiceReference(type=CompanyProviderWrapper.class)
    protected CompanyProvider companyProvider;
    @ServiceReference(type=EntityCache.class)
    protected EntityCache entityCache;
    @ServiceReference(type=FinderCache.class)
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_MESSAGE = "SELECT message FROM Message message";
    private static final String _SQL_SELECT_MESSAGE_WHERE_PKS_IN = "SELECT message FROM Message message WHERE messageId IN (";
    private static final String _SQL_SELECT_MESSAGE_WHERE = "SELECT message FROM Message message WHERE ";
    private static final String _SQL_COUNT_MESSAGE = "SELECT COUNT(message) FROM Message message";
    private static final String _SQL_COUNT_MESSAGE_WHERE = "SELECT COUNT(message) FROM Message message WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "message.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No Message exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No Message exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(MessagePersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"to", "size"});

    public List<Message> findByCompanyId(long companyId) {
        return this.findByCompanyId(companyId, -1, -1, null);
    }

    public List<Message> findByCompanyId(long companyId, int start, int end) {
        return this.findByCompanyId(companyId, start, end, null);
    }

    public List<Message> findByCompanyId(long companyId, int start, int end, OrderByComparator<Message> orderByComparator) {
        return this.findByCompanyId(companyId, start, end, orderByComparator, true);
    }

    public List<Message> findByCompanyId(long companyId, int start, int end, OrderByComparator<Message> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByCompanyId;
            finderArgs = new Object[]{companyId};
        } else {
            finderPath = this._finderPathWithPaginationFindByCompanyId;
            finderArgs = new Object[]{companyId, start, end, orderByComparator};
        }
        List<Message> list = null;
        if (retrieveFromCache && (list = (List<Message>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (Message message : list) {
                if (companyId == message.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_MESSAGE_WHERE);
            query.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY message.sentDate ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(companyId);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public Message findByCompanyId_First(long companyId, OrderByComparator<Message> orderByComparator) throws NoSuchMessageException {
        Message message = this.fetchByCompanyId_First(companyId, orderByComparator);
        if (message != null) {
            return message;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append("}");
        throw new NoSuchMessageException(msg.toString());
    }

    public Message fetchByCompanyId_First(long companyId, OrderByComparator<Message> orderByComparator) {
        List<Message> list = this.findByCompanyId(companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Message findByCompanyId_Last(long companyId, OrderByComparator<Message> orderByComparator) throws NoSuchMessageException {
        Message message = this.fetchByCompanyId_Last(companyId, orderByComparator);
        if (message != null) {
            return message;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append("}");
        throw new NoSuchMessageException(msg.toString());
    }

    public Message fetchByCompanyId_Last(long companyId, OrderByComparator<Message> orderByComparator) {
        int count = this.countByCompanyId(companyId);
        if (count == 0) {
            return null;
        }
        List<Message> list = this.findByCompanyId(companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Message[] findByCompanyId_PrevAndNext(long messageId, long companyId, OrderByComparator<Message> orderByComparator) throws NoSuchMessageException {
        Message message = this.findByPrimaryKey(messageId);
        Session session = null;
        try {
            session = this.openSession();
            Message[] array = new MessageImpl[]{this.getByCompanyId_PrevAndNext(session, message, companyId, orderByComparator, true), message, this.getByCompanyId_PrevAndNext(session, message, companyId, orderByComparator, false)};
            Message[] messageArray = array;
            return messageArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Message getByCompanyId_PrevAndNext(Session session, Message message, long companyId, OrderByComparator<Message> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_MESSAGE_WHERE);
        query.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY message.sentDate ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)message)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Message)list.get(1);
        }
        return null;
    }

    public void removeByCompanyId(long companyId) {
        for (Message message : this.findByCompanyId(companyId, -1, -1, null)) {
            this.remove((BaseModel)message);
        }
    }

    public int countByCompanyId(long companyId) {
        FinderPath finderPath = this._finderPathCountByCompanyId;
        Object[] finderArgs = new Object[]{companyId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_MESSAGE_WHERE);
            query.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(companyId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<Message> findByFolderId(long folderId) {
        return this.findByFolderId(folderId, -1, -1, null);
    }

    public List<Message> findByFolderId(long folderId, int start, int end) {
        return this.findByFolderId(folderId, start, end, null);
    }

    public List<Message> findByFolderId(long folderId, int start, int end, OrderByComparator<Message> orderByComparator) {
        return this.findByFolderId(folderId, start, end, orderByComparator, true);
    }

    public List<Message> findByFolderId(long folderId, int start, int end, OrderByComparator<Message> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByFolderId;
            finderArgs = new Object[]{folderId};
        } else {
            finderPath = this._finderPathWithPaginationFindByFolderId;
            finderArgs = new Object[]{folderId, start, end, orderByComparator};
        }
        List<Message> list = null;
        if (retrieveFromCache && (list = (List<Message>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (Message message : list) {
                if (folderId == message.getFolderId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_MESSAGE_WHERE);
            query.append(_FINDER_COLUMN_FOLDERID_FOLDERID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY message.sentDate ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(folderId);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public Message findByFolderId_First(long folderId, OrderByComparator<Message> orderByComparator) throws NoSuchMessageException {
        Message message = this.fetchByFolderId_First(folderId, orderByComparator);
        if (message != null) {
            return message;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("folderId=");
        msg.append(folderId);
        msg.append("}");
        throw new NoSuchMessageException(msg.toString());
    }

    public Message fetchByFolderId_First(long folderId, OrderByComparator<Message> orderByComparator) {
        List<Message> list = this.findByFolderId(folderId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Message findByFolderId_Last(long folderId, OrderByComparator<Message> orderByComparator) throws NoSuchMessageException {
        Message message = this.fetchByFolderId_Last(folderId, orderByComparator);
        if (message != null) {
            return message;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("folderId=");
        msg.append(folderId);
        msg.append("}");
        throw new NoSuchMessageException(msg.toString());
    }

    public Message fetchByFolderId_Last(long folderId, OrderByComparator<Message> orderByComparator) {
        int count = this.countByFolderId(folderId);
        if (count == 0) {
            return null;
        }
        List<Message> list = this.findByFolderId(folderId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Message[] findByFolderId_PrevAndNext(long messageId, long folderId, OrderByComparator<Message> orderByComparator) throws NoSuchMessageException {
        Message message = this.findByPrimaryKey(messageId);
        Session session = null;
        try {
            session = this.openSession();
            Message[] array = new MessageImpl[]{this.getByFolderId_PrevAndNext(session, message, folderId, orderByComparator, true), message, this.getByFolderId_PrevAndNext(session, message, folderId, orderByComparator, false)};
            Message[] messageArray = array;
            return messageArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Message getByFolderId_PrevAndNext(Session session, Message message, long folderId, OrderByComparator<Message> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_MESSAGE_WHERE);
        query.append(_FINDER_COLUMN_FOLDERID_FOLDERID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY message.sentDate ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(folderId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)message)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Message)list.get(1);
        }
        return null;
    }

    public void removeByFolderId(long folderId) {
        for (Message message : this.findByFolderId(folderId, -1, -1, null)) {
            this.remove((BaseModel)message);
        }
    }

    public int countByFolderId(long folderId) {
        FinderPath finderPath = this._finderPathCountByFolderId;
        Object[] finderArgs = new Object[]{folderId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_MESSAGE_WHERE);
            query.append(_FINDER_COLUMN_FOLDERID_FOLDERID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(folderId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Message findByF_R(long folderId, long remoteMessageId) throws NoSuchMessageException {
        Message message = this.fetchByF_R(folderId, remoteMessageId);
        if (message == null) {
            StringBundler msg = new StringBundler(6);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("folderId=");
            msg.append(folderId);
            msg.append(", remoteMessageId=");
            msg.append(remoteMessageId);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)msg.toString());
            }
            throw new NoSuchMessageException(msg.toString());
        }
        return message;
    }

    public Message fetchByF_R(long folderId, long remoteMessageId) {
        return this.fetchByF_R(folderId, remoteMessageId, true);
    }

    public Message fetchByF_R(long folderId, long remoteMessageId, boolean retrieveFromCache) {
        Message message;
        Object[] finderArgs = new Object[]{folderId, remoteMessageId};
        Object result = null;
        if (retrieveFromCache) {
            result = this.finderCache.getResult(this._finderPathFetchByF_R, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof Message && (folderId != (message = (Message)result).getFolderId() || remoteMessageId != message.getRemoteMessageId())) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(4);
            query.append(_SQL_SELECT_MESSAGE_WHERE);
            query.append(_FINDER_COLUMN_F_R_FOLDERID_2);
            query.append(_FINDER_COLUMN_F_R_REMOTEMESSAGEID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(folderId);
                qPos.add(remoteMessageId);
                List list = q.list();
                if (list.isEmpty()) {
                    this.finderCache.putResult(this._finderPathFetchByF_R, finderArgs, (Object)list);
                } else {
                    if (list.size() > 1) {
                        Collections.sort(list, Collections.reverseOrder());
                        if (_log.isWarnEnabled()) {
                            _log.warn((Object)("MessagePersistenceImpl.fetchByF_R(long, long, boolean) with parameters (" + StringUtil.merge((Object[])finderArgs) + ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder."));
                        }
                    }
                    Message message2 = (Message)list.get(0);
                    result = message2;
                    this.cacheResult(message2);
                }
            }
            catch (Exception e) {
                this.finderCache.removeResult(this._finderPathFetchByF_R, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (Message)result;
    }

    public Message removeByF_R(long folderId, long remoteMessageId) throws NoSuchMessageException {
        Message message = this.findByF_R(folderId, remoteMessageId);
        return (Message)this.remove((BaseModel)message);
    }

    public int countByF_R(long folderId, long remoteMessageId) {
        FinderPath finderPath = this._finderPathCountByF_R;
        Object[] finderArgs = new Object[]{folderId, remoteMessageId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_MESSAGE_WHERE);
            query.append(_FINDER_COLUMN_F_R_FOLDERID_2);
            query.append(_FINDER_COLUMN_F_R_REMOTEMESSAGEID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(folderId);
                qPos.add(remoteMessageId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public MessagePersistenceImpl() {
        block2: {
            this.setModelClass(Message.class);
            try {
                Field field = BasePersistenceImpl.class.getDeclaredField("_dbColumnNames");
                field.setAccessible(true);
                HashMap<String, String> dbColumnNames = new HashMap<String, String>();
                dbColumnNames.put("to", "to_");
                dbColumnNames.put("size", "size_");
                field.set((Object)this, dbColumnNames);
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Object)e, (Throwable)e);
            }
        }
    }

    public void cacheResult(Message message) {
        this.entityCache.putResult(MessageModelImpl.ENTITY_CACHE_ENABLED, MessageImpl.class, (Serializable)Long.valueOf(message.getPrimaryKey()), (Serializable)message);
        this.finderCache.putResult(this._finderPathFetchByF_R, new Object[]{message.getFolderId(), message.getRemoteMessageId()}, (Object)message);
        message.resetOriginalValues();
    }

    public void cacheResult(List<Message> messages) {
        for (Message message : messages) {
            if (this.entityCache.getResult(MessageModelImpl.ENTITY_CACHE_ENABLED, MessageImpl.class, (Serializable)Long.valueOf(message.getPrimaryKey())) == null) {
                this.cacheResult(message);
                continue;
            }
            message.resetOriginalValues();
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(MessageImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(Message message) {
        this.entityCache.removeResult(MessageModelImpl.ENTITY_CACHE_ENABLED, MessageImpl.class, (Serializable)Long.valueOf(message.getPrimaryKey()));
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache((MessageModelImpl)message, true);
    }

    public void clearCache(List<Message> messages) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Message message : messages) {
            this.entityCache.removeResult(MessageModelImpl.ENTITY_CACHE_ENABLED, MessageImpl.class, (Serializable)Long.valueOf(message.getPrimaryKey()));
            this.clearUniqueFindersCache((MessageModelImpl)message, true);
        }
    }

    protected void cacheUniqueFindersCache(MessageModelImpl messageModelImpl) {
        Object[] args = new Object[]{messageModelImpl.getFolderId(), messageModelImpl.getRemoteMessageId()};
        this.finderCache.putResult(this._finderPathCountByF_R, args, (Object)1L, false);
        this.finderCache.putResult(this._finderPathFetchByF_R, args, (Object)messageModelImpl, false);
    }

    protected void clearUniqueFindersCache(MessageModelImpl messageModelImpl, boolean clearCurrent) {
        Object[] args;
        if (clearCurrent) {
            args = new Object[]{messageModelImpl.getFolderId(), messageModelImpl.getRemoteMessageId()};
            this.finderCache.removeResult(this._finderPathCountByF_R, args);
            this.finderCache.removeResult(this._finderPathFetchByF_R, args);
        }
        if ((messageModelImpl.getColumnBitmask() & this._finderPathFetchByF_R.getColumnBitmask()) != 0L) {
            args = new Object[]{messageModelImpl.getOriginalFolderId(), messageModelImpl.getOriginalRemoteMessageId()};
            this.finderCache.removeResult(this._finderPathCountByF_R, args);
            this.finderCache.removeResult(this._finderPathFetchByF_R, args);
        }
    }

    public Message create(long messageId) {
        MessageImpl message = new MessageImpl();
        message.setNew(true);
        message.setPrimaryKey(messageId);
        message.setCompanyId(this.companyProvider.getCompanyId());
        return message;
    }

    public Message remove(long messageId) throws NoSuchMessageException {
        return this.remove(Long.valueOf(messageId));
    }

    public Message remove(Serializable primaryKey) throws NoSuchMessageException {
        Session session = null;
        try {
            session = this.openSession();
            Message message = (Message)session.get(MessageImpl.class, primaryKey);
            if (message == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchMessageException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            Message message2 = (Message)this.remove((BaseModel)message);
            return message2;
        }
        catch (NoSuchMessageException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Message removeImpl(Message message) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)message)) {
                message = (Message)session.get(MessageImpl.class, message.getPrimaryKeyObj());
            }
            if (message != null) {
                session.delete((Object)message);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        if (message != null) {
            this.clearCache(message);
        }
        return message;
    }

    public Message updateImpl(Message message) {
        boolean isNew = message.isNew();
        if (!(message instanceof MessageModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(message.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)message);
                throw new IllegalArgumentException("Implement ModelWrapper in message proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom Message implementation " + message.getClass());
        }
        MessageModelImpl messageModelImpl = (MessageModelImpl)message;
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date now = new Date();
        if (isNew && message.getCreateDate() == null) {
            if (serviceContext == null) {
                message.setCreateDate(now);
            } else {
                message.setCreateDate(serviceContext.getCreateDate(now));
            }
        }
        if (!messageModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                message.setModifiedDate(now);
            } else {
                message.setModifiedDate(serviceContext.getModifiedDate(now));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (message.isNew()) {
                session.save((Object)message);
                message.setNew(false);
            } else {
                message = (Message)session.merge((Object)message);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!MessageModelImpl.COLUMN_BITMASK_ENABLED) {
            this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            Object[] args = new Object[]{messageModelImpl.getCompanyId()};
            this.finderCache.removeResult(this._finderPathCountByCompanyId, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByCompanyId, args);
            args = new Object[]{messageModelImpl.getFolderId()};
            this.finderCache.removeResult(this._finderPathCountByFolderId, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByFolderId, args);
            this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindAll, FINDER_ARGS_EMPTY);
        } else {
            Object[] args;
            if ((messageModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByCompanyId.getColumnBitmask()) != 0L) {
                args = new Object[]{messageModelImpl.getOriginalCompanyId()};
                this.finderCache.removeResult(this._finderPathCountByCompanyId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByCompanyId, args);
                args = new Object[]{messageModelImpl.getCompanyId()};
                this.finderCache.removeResult(this._finderPathCountByCompanyId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByCompanyId, args);
            }
            if ((messageModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByFolderId.getColumnBitmask()) != 0L) {
                args = new Object[]{messageModelImpl.getOriginalFolderId()};
                this.finderCache.removeResult(this._finderPathCountByFolderId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByFolderId, args);
                args = new Object[]{messageModelImpl.getFolderId()};
                this.finderCache.removeResult(this._finderPathCountByFolderId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByFolderId, args);
            }
        }
        this.entityCache.putResult(MessageModelImpl.ENTITY_CACHE_ENABLED, MessageImpl.class, (Serializable)Long.valueOf(message.getPrimaryKey()), (Serializable)message, false);
        this.clearUniqueFindersCache(messageModelImpl, false);
        this.cacheUniqueFindersCache(messageModelImpl);
        message.resetOriginalValues();
        return message;
    }

    public Message findByPrimaryKey(Serializable primaryKey) throws NoSuchMessageException {
        Message message = this.fetchByPrimaryKey(primaryKey);
        if (message == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchMessageException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return message;
    }

    public Message findByPrimaryKey(long messageId) throws NoSuchMessageException {
        return this.findByPrimaryKey(Long.valueOf(messageId));
    }

    public Message fetchByPrimaryKey(Serializable primaryKey) {
        Serializable serializable = this.entityCache.getResult(MessageModelImpl.ENTITY_CACHE_ENABLED, MessageImpl.class, primaryKey);
        if (serializable == nullModel) {
            return null;
        }
        Message message = (Message)serializable;
        if (message == null) {
            Session session = null;
            try {
                session = this.openSession();
                message = (Message)session.get(MessageImpl.class, primaryKey);
                if (message != null) {
                    this.cacheResult(message);
                } else {
                    this.entityCache.putResult(MessageModelImpl.ENTITY_CACHE_ENABLED, MessageImpl.class, primaryKey, (Serializable)nullModel);
                }
            }
            catch (Exception e) {
                this.entityCache.removeResult(MessageModelImpl.ENTITY_CACHE_ENABLED, MessageImpl.class, primaryKey);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return message;
    }

    public Message fetchByPrimaryKey(long messageId) {
        return this.fetchByPrimaryKey(Long.valueOf(messageId));
    }

    public Map<Serializable, Message> fetchByPrimaryKeys(Set<Serializable> primaryKeys) {
        Session session;
        if (primaryKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Serializable, Message> map = new HashMap<Serializable, Message>();
        if (primaryKeys.size() == 1) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            Serializable primaryKey = iterator.next();
            Message message = this.fetchByPrimaryKey(primaryKey);
            if (message != null) {
                map.put(primaryKey, message);
            }
            return map;
        }
        HashSet<Serializable> uncachedPrimaryKeys = null;
        for (Serializable serializable : primaryKeys) {
            Serializable serializable2 = this.entityCache.getResult(MessageModelImpl.ENTITY_CACHE_ENABLED, MessageImpl.class, serializable);
            if (serializable2 == nullModel) continue;
            if (serializable2 == null) {
                if (uncachedPrimaryKeys == null) {
                    uncachedPrimaryKeys = new HashSet<Serializable>();
                }
                uncachedPrimaryKeys.add(serializable);
                continue;
            }
            map.put(serializable, (Message)serializable2);
        }
        if (uncachedPrimaryKeys == null) {
            return map;
        }
        StringBundler query = new StringBundler(uncachedPrimaryKeys.size() * 2 + 1);
        query.append(_SQL_SELECT_MESSAGE_WHERE_PKS_IN);
        for (Serializable serializable : uncachedPrimaryKeys) {
            query.append(((Long)serializable).longValue());
            query.append(",");
        }
        query.setIndex(query.index() - 1);
        query.append(")");
        String string = query.toString();
        Session session2 = null;
        try {
            session = this.openSession();
            Query q = session.createQuery(string);
            for (Message message : q.list()) {
                map.put(message.getPrimaryKeyObj(), message);
                this.cacheResult(message);
                uncachedPrimaryKeys.remove(message.getPrimaryKeyObj());
            }
            for (Serializable serializable : uncachedPrimaryKeys) {
                this.entityCache.putResult(MessageModelImpl.ENTITY_CACHE_ENABLED, MessageImpl.class, serializable, (Serializable)nullModel);
            }
        }
        catch (Exception e) {
            try {
                throw this.processException(e);
            }
            catch (Throwable throwable) {
                this.closeSession(session2);
                throw throwable;
            }
        }
        this.closeSession(session);
        return map;
    }

    public List<Message> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<Message> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<Message> findAll(int start, int end, OrderByComparator<Message> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<Message> findAll(int start, int end, OrderByComparator<Message> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindAll;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (retrieveFromCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                query.append(_SQL_SELECT_MESSAGE);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_MESSAGE;
                if (pagination) {
                    sql = sql.concat(" ORDER BY message.sentDate ASC");
                }
            }
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (Message message : this.findAll()) {
            this.remove((BaseModel)message);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_MESSAGE);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return MessageModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
        this._finderPathWithPaginationFindAll = new FinderPath(MessageModelImpl.ENTITY_CACHE_ENABLED, MessageModelImpl.FINDER_CACHE_ENABLED, MessageImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
        this._finderPathWithoutPaginationFindAll = new FinderPath(MessageModelImpl.ENTITY_CACHE_ENABLED, MessageModelImpl.FINDER_CACHE_ENABLED, MessageImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
        this._finderPathCountAll = new FinderPath(MessageModelImpl.ENTITY_CACHE_ENABLED, MessageModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
        this._finderPathWithPaginationFindByCompanyId = new FinderPath(MessageModelImpl.ENTITY_CACHE_ENABLED, MessageModelImpl.FINDER_CACHE_ENABLED, MessageImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByCompanyId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByCompanyId = new FinderPath(MessageModelImpl.ENTITY_CACHE_ENABLED, MessageModelImpl.FINDER_CACHE_ENABLED, MessageImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByCompanyId", new String[]{Long.class.getName()}, 9L);
        this._finderPathCountByCompanyId = new FinderPath(MessageModelImpl.ENTITY_CACHE_ENABLED, MessageModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCompanyId", new String[]{Long.class.getName()});
        this._finderPathWithPaginationFindByFolderId = new FinderPath(MessageModelImpl.ENTITY_CACHE_ENABLED, MessageModelImpl.FINDER_CACHE_ENABLED, MessageImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByFolderId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByFolderId = new FinderPath(MessageModelImpl.ENTITY_CACHE_ENABLED, MessageModelImpl.FINDER_CACHE_ENABLED, MessageImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByFolderId", new String[]{Long.class.getName()}, 10L);
        this._finderPathCountByFolderId = new FinderPath(MessageModelImpl.ENTITY_CACHE_ENABLED, MessageModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByFolderId", new String[]{Long.class.getName()});
        this._finderPathFetchByF_R = new FinderPath(MessageModelImpl.ENTITY_CACHE_ENABLED, MessageModelImpl.FINDER_CACHE_ENABLED, MessageImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByF_R", new String[]{Long.class.getName(), Long.class.getName()}, 6L);
        this._finderPathCountByF_R = new FinderPath(MessageModelImpl.ENTITY_CACHE_ENABLED, MessageModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByF_R", new String[]{Long.class.getName(), Long.class.getName()});
    }

    public void destroy() {
        this.entityCache.removeCache(MessageImpl.class.getName());
        this.finderCache.removeCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}

