/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mail.reader.service.persistence.impl;

import aQute.bnd.annotation.ProviderType;
import com.liferay.mail.reader.exception.NoSuchAttachmentException;
import com.liferay.mail.reader.model.Attachment;
import com.liferay.mail.reader.model.impl.AttachmentImpl;
import com.liferay.mail.reader.model.impl.AttachmentModelImpl;
import com.liferay.mail.reader.service.persistence.AttachmentPersistence;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.service.persistence.CompanyProvider;
import com.liferay.portal.kernel.service.persistence.CompanyProviderWrapper;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

@ProviderType
public class AttachmentPersistenceImpl
extends BasePersistenceImpl<Attachment>
implements AttachmentPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = AttachmentImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByMessageId;
    private FinderPath _finderPathWithoutPaginationFindByMessageId;
    private FinderPath _finderPathCountByMessageId;
    private static final String _FINDER_COLUMN_MESSAGEID_MESSAGEID_2 = "attachment.messageId = ?";
    @ServiceReference(type=CompanyProviderWrapper.class)
    protected CompanyProvider companyProvider;
    @ServiceReference(type=EntityCache.class)
    protected EntityCache entityCache;
    @ServiceReference(type=FinderCache.class)
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_ATTACHMENT = "SELECT attachment FROM Attachment attachment";
    private static final String _SQL_SELECT_ATTACHMENT_WHERE_PKS_IN = "SELECT attachment FROM Attachment attachment WHERE attachmentId IN (";
    private static final String _SQL_SELECT_ATTACHMENT_WHERE = "SELECT attachment FROM Attachment attachment WHERE ";
    private static final String _SQL_COUNT_ATTACHMENT = "SELECT COUNT(attachment) FROM Attachment attachment";
    private static final String _SQL_COUNT_ATTACHMENT_WHERE = "SELECT COUNT(attachment) FROM Attachment attachment WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "attachment.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No Attachment exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No Attachment exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(AttachmentPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"size"});

    public List<Attachment> findByMessageId(long messageId) {
        return this.findByMessageId(messageId, -1, -1, null);
    }

    public List<Attachment> findByMessageId(long messageId, int start, int end) {
        return this.findByMessageId(messageId, start, end, null);
    }

    public List<Attachment> findByMessageId(long messageId, int start, int end, OrderByComparator<Attachment> orderByComparator) {
        return this.findByMessageId(messageId, start, end, orderByComparator, true);
    }

    public List<Attachment> findByMessageId(long messageId, int start, int end, OrderByComparator<Attachment> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByMessageId;
            finderArgs = new Object[]{messageId};
        } else {
            finderPath = this._finderPathWithPaginationFindByMessageId;
            finderArgs = new Object[]{messageId, start, end, orderByComparator};
        }
        List<Attachment> list = null;
        if (retrieveFromCache && (list = (List<Attachment>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (Attachment attachment : list) {
                if (messageId == attachment.getMessageId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_ATTACHMENT_WHERE);
            query.append(_FINDER_COLUMN_MESSAGEID_MESSAGEID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY attachment.attachmentId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(messageId);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public Attachment findByMessageId_First(long messageId, OrderByComparator<Attachment> orderByComparator) throws NoSuchAttachmentException {
        Attachment attachment = this.fetchByMessageId_First(messageId, orderByComparator);
        if (attachment != null) {
            return attachment;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("messageId=");
        msg.append(messageId);
        msg.append("}");
        throw new NoSuchAttachmentException(msg.toString());
    }

    public Attachment fetchByMessageId_First(long messageId, OrderByComparator<Attachment> orderByComparator) {
        List<Attachment> list = this.findByMessageId(messageId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Attachment findByMessageId_Last(long messageId, OrderByComparator<Attachment> orderByComparator) throws NoSuchAttachmentException {
        Attachment attachment = this.fetchByMessageId_Last(messageId, orderByComparator);
        if (attachment != null) {
            return attachment;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("messageId=");
        msg.append(messageId);
        msg.append("}");
        throw new NoSuchAttachmentException(msg.toString());
    }

    public Attachment fetchByMessageId_Last(long messageId, OrderByComparator<Attachment> orderByComparator) {
        int count = this.countByMessageId(messageId);
        if (count == 0) {
            return null;
        }
        List<Attachment> list = this.findByMessageId(messageId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Attachment[] findByMessageId_PrevAndNext(long attachmentId, long messageId, OrderByComparator<Attachment> orderByComparator) throws NoSuchAttachmentException {
        Attachment attachment = this.findByPrimaryKey(attachmentId);
        Session session = null;
        try {
            session = this.openSession();
            Attachment[] array = new AttachmentImpl[]{this.getByMessageId_PrevAndNext(session, attachment, messageId, orderByComparator, true), attachment, this.getByMessageId_PrevAndNext(session, attachment, messageId, orderByComparator, false)};
            Attachment[] attachmentArray = array;
            return attachmentArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Attachment getByMessageId_PrevAndNext(Session session, Attachment attachment, long messageId, OrderByComparator<Attachment> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_ATTACHMENT_WHERE);
        query.append(_FINDER_COLUMN_MESSAGEID_MESSAGEID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY attachment.attachmentId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(messageId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)attachment)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Attachment)list.get(1);
        }
        return null;
    }

    public void removeByMessageId(long messageId) {
        for (Attachment attachment : this.findByMessageId(messageId, -1, -1, null)) {
            this.remove((BaseModel)attachment);
        }
    }

    public int countByMessageId(long messageId) {
        FinderPath finderPath = this._finderPathCountByMessageId;
        Object[] finderArgs = new Object[]{messageId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_ATTACHMENT_WHERE);
            query.append(_FINDER_COLUMN_MESSAGEID_MESSAGEID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(messageId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public AttachmentPersistenceImpl() {
        block2: {
            this.setModelClass(Attachment.class);
            try {
                Field field = BasePersistenceImpl.class.getDeclaredField("_dbColumnNames");
                field.setAccessible(true);
                HashMap<String, String> dbColumnNames = new HashMap<String, String>();
                dbColumnNames.put("size", "size_");
                field.set((Object)this, dbColumnNames);
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Object)e, (Throwable)e);
            }
        }
    }

    public void cacheResult(Attachment attachment) {
        this.entityCache.putResult(AttachmentModelImpl.ENTITY_CACHE_ENABLED, AttachmentImpl.class, (Serializable)Long.valueOf(attachment.getPrimaryKey()), (Serializable)attachment);
        attachment.resetOriginalValues();
    }

    public void cacheResult(List<Attachment> attachments) {
        for (Attachment attachment : attachments) {
            if (this.entityCache.getResult(AttachmentModelImpl.ENTITY_CACHE_ENABLED, AttachmentImpl.class, (Serializable)Long.valueOf(attachment.getPrimaryKey())) == null) {
                this.cacheResult(attachment);
                continue;
            }
            attachment.resetOriginalValues();
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(AttachmentImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(Attachment attachment) {
        this.entityCache.removeResult(AttachmentModelImpl.ENTITY_CACHE_ENABLED, AttachmentImpl.class, (Serializable)Long.valueOf(attachment.getPrimaryKey()));
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(List<Attachment> attachments) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Attachment attachment : attachments) {
            this.entityCache.removeResult(AttachmentModelImpl.ENTITY_CACHE_ENABLED, AttachmentImpl.class, (Serializable)Long.valueOf(attachment.getPrimaryKey()));
        }
    }

    public Attachment create(long attachmentId) {
        AttachmentImpl attachment = new AttachmentImpl();
        attachment.setNew(true);
        attachment.setPrimaryKey(attachmentId);
        attachment.setCompanyId(this.companyProvider.getCompanyId());
        return attachment;
    }

    public Attachment remove(long attachmentId) throws NoSuchAttachmentException {
        return this.remove(Long.valueOf(attachmentId));
    }

    public Attachment remove(Serializable primaryKey) throws NoSuchAttachmentException {
        Session session = null;
        try {
            session = this.openSession();
            Attachment attachment = (Attachment)session.get(AttachmentImpl.class, primaryKey);
            if (attachment == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchAttachmentException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            Attachment attachment2 = (Attachment)this.remove((BaseModel)attachment);
            return attachment2;
        }
        catch (NoSuchAttachmentException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Attachment removeImpl(Attachment attachment) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)attachment)) {
                attachment = (Attachment)session.get(AttachmentImpl.class, attachment.getPrimaryKeyObj());
            }
            if (attachment != null) {
                session.delete((Object)attachment);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        if (attachment != null) {
            this.clearCache(attachment);
        }
        return attachment;
    }

    public Attachment updateImpl(Attachment attachment) {
        boolean isNew = attachment.isNew();
        if (!(attachment instanceof AttachmentModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(attachment.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)attachment);
                throw new IllegalArgumentException("Implement ModelWrapper in attachment proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom Attachment implementation " + attachment.getClass());
        }
        AttachmentModelImpl attachmentModelImpl = (AttachmentModelImpl)attachment;
        Session session = null;
        try {
            session = this.openSession();
            if (attachment.isNew()) {
                session.save((Object)attachment);
                attachment.setNew(false);
            } else {
                attachment = (Attachment)session.merge((Object)attachment);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!AttachmentModelImpl.COLUMN_BITMASK_ENABLED) {
            this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            Object[] args = new Object[]{attachmentModelImpl.getMessageId()};
            this.finderCache.removeResult(this._finderPathCountByMessageId, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByMessageId, args);
            this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindAll, FINDER_ARGS_EMPTY);
        } else if ((attachmentModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByMessageId.getColumnBitmask()) != 0L) {
            Object[] args = new Object[]{attachmentModelImpl.getOriginalMessageId()};
            this.finderCache.removeResult(this._finderPathCountByMessageId, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByMessageId, args);
            args = new Object[]{attachmentModelImpl.getMessageId()};
            this.finderCache.removeResult(this._finderPathCountByMessageId, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByMessageId, args);
        }
        this.entityCache.putResult(AttachmentModelImpl.ENTITY_CACHE_ENABLED, AttachmentImpl.class, (Serializable)Long.valueOf(attachment.getPrimaryKey()), (Serializable)attachment, false);
        attachment.resetOriginalValues();
        return attachment;
    }

    public Attachment findByPrimaryKey(Serializable primaryKey) throws NoSuchAttachmentException {
        Attachment attachment = this.fetchByPrimaryKey(primaryKey);
        if (attachment == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchAttachmentException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return attachment;
    }

    public Attachment findByPrimaryKey(long attachmentId) throws NoSuchAttachmentException {
        return this.findByPrimaryKey(Long.valueOf(attachmentId));
    }

    public Attachment fetchByPrimaryKey(Serializable primaryKey) {
        Serializable serializable = this.entityCache.getResult(AttachmentModelImpl.ENTITY_CACHE_ENABLED, AttachmentImpl.class, primaryKey);
        if (serializable == nullModel) {
            return null;
        }
        Attachment attachment = (Attachment)serializable;
        if (attachment == null) {
            Session session = null;
            try {
                session = this.openSession();
                attachment = (Attachment)session.get(AttachmentImpl.class, primaryKey);
                if (attachment != null) {
                    this.cacheResult(attachment);
                } else {
                    this.entityCache.putResult(AttachmentModelImpl.ENTITY_CACHE_ENABLED, AttachmentImpl.class, primaryKey, (Serializable)nullModel);
                }
            }
            catch (Exception e) {
                this.entityCache.removeResult(AttachmentModelImpl.ENTITY_CACHE_ENABLED, AttachmentImpl.class, primaryKey);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return attachment;
    }

    public Attachment fetchByPrimaryKey(long attachmentId) {
        return this.fetchByPrimaryKey(Long.valueOf(attachmentId));
    }

    public Map<Serializable, Attachment> fetchByPrimaryKeys(Set<Serializable> primaryKeys) {
        Session session;
        if (primaryKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Serializable, Attachment> map = new HashMap<Serializable, Attachment>();
        if (primaryKeys.size() == 1) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            Serializable primaryKey = iterator.next();
            Attachment attachment = this.fetchByPrimaryKey(primaryKey);
            if (attachment != null) {
                map.put(primaryKey, attachment);
            }
            return map;
        }
        HashSet<Serializable> uncachedPrimaryKeys = null;
        for (Serializable serializable : primaryKeys) {
            Serializable serializable2 = this.entityCache.getResult(AttachmentModelImpl.ENTITY_CACHE_ENABLED, AttachmentImpl.class, serializable);
            if (serializable2 == nullModel) continue;
            if (serializable2 == null) {
                if (uncachedPrimaryKeys == null) {
                    uncachedPrimaryKeys = new HashSet<Serializable>();
                }
                uncachedPrimaryKeys.add(serializable);
                continue;
            }
            map.put(serializable, (Attachment)serializable2);
        }
        if (uncachedPrimaryKeys == null) {
            return map;
        }
        StringBundler query = new StringBundler(uncachedPrimaryKeys.size() * 2 + 1);
        query.append(_SQL_SELECT_ATTACHMENT_WHERE_PKS_IN);
        for (Serializable serializable : uncachedPrimaryKeys) {
            query.append(((Long)serializable).longValue());
            query.append(",");
        }
        query.setIndex(query.index() - 1);
        query.append(")");
        String string = query.toString();
        Session session2 = null;
        try {
            session = this.openSession();
            Query q = session.createQuery(string);
            for (Attachment attachment : q.list()) {
                map.put(attachment.getPrimaryKeyObj(), attachment);
                this.cacheResult(attachment);
                uncachedPrimaryKeys.remove(attachment.getPrimaryKeyObj());
            }
            for (Serializable serializable : uncachedPrimaryKeys) {
                this.entityCache.putResult(AttachmentModelImpl.ENTITY_CACHE_ENABLED, AttachmentImpl.class, serializable, (Serializable)nullModel);
            }
        }
        catch (Exception e) {
            try {
                throw this.processException(e);
            }
            catch (Throwable throwable) {
                this.closeSession(session2);
                throw throwable;
            }
        }
        this.closeSession(session);
        return map;
    }

    public List<Attachment> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<Attachment> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<Attachment> findAll(int start, int end, OrderByComparator<Attachment> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<Attachment> findAll(int start, int end, OrderByComparator<Attachment> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindAll;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (retrieveFromCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                query.append(_SQL_SELECT_ATTACHMENT);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_ATTACHMENT;
                if (pagination) {
                    sql = sql.concat(" ORDER BY attachment.attachmentId ASC");
                }
            }
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (Attachment attachment : this.findAll()) {
            this.remove((BaseModel)attachment);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_ATTACHMENT);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return AttachmentModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
        this._finderPathWithPaginationFindAll = new FinderPath(AttachmentModelImpl.ENTITY_CACHE_ENABLED, AttachmentModelImpl.FINDER_CACHE_ENABLED, AttachmentImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
        this._finderPathWithoutPaginationFindAll = new FinderPath(AttachmentModelImpl.ENTITY_CACHE_ENABLED, AttachmentModelImpl.FINDER_CACHE_ENABLED, AttachmentImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
        this._finderPathCountAll = new FinderPath(AttachmentModelImpl.ENTITY_CACHE_ENABLED, AttachmentModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
        this._finderPathWithPaginationFindByMessageId = new FinderPath(AttachmentModelImpl.ENTITY_CACHE_ENABLED, AttachmentModelImpl.FINDER_CACHE_ENABLED, AttachmentImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByMessageId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByMessageId = new FinderPath(AttachmentModelImpl.ENTITY_CACHE_ENABLED, AttachmentModelImpl.FINDER_CACHE_ENABLED, AttachmentImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByMessageId", new String[]{Long.class.getName()}, 1L);
        this._finderPathCountByMessageId = new FinderPath(AttachmentModelImpl.ENTITY_CACHE_ENABLED, AttachmentModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByMessageId", new String[]{Long.class.getName()});
    }

    public void destroy() {
        this.entityCache.removeCache(AttachmentImpl.class.getName());
        this.finderCache.removeCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}

