/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mail.reader.service.impl;

import com.liferay.mail.reader.model.Folder;
import com.liferay.mail.reader.service.base.FolderLocalServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import java.util.Date;
import java.util.List;

public class FolderLocalServiceImpl
extends FolderLocalServiceBaseImpl {
    public Folder addFolder(long userId, long accountId, String fullName, String displayName, int remoteMessageCount) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        Date now = new Date();
        long folderId = this.counterLocalService.increment();
        Folder folder = this.folderPersistence.create(folderId);
        folder.setCompanyId(user.getCompanyId());
        folder.setUserId(user.getUserId());
        folder.setUserName(user.getFullName());
        folder.setCreateDate(now);
        folder.setModifiedDate(now);
        folder.setAccountId(accountId);
        folder.setFullName(fullName);
        folder.setDisplayName(displayName);
        folder.setRemoteMessageCount(remoteMessageCount);
        this.folderPersistence.update((BaseModel)folder);
        return folder;
    }

    @Override
    public Folder deleteFolder(Folder folder) throws PortalException {
        this.folderPersistence.remove((BaseModel)folder);
        this.messageLocalService.deleteMessages(folder.getFolderId());
        Indexer indexer = IndexerRegistryUtil.getIndexer(Folder.class);
        indexer.delete((Object)folder);
        return folder;
    }

    @Override
    public Folder deleteFolder(long folderId) throws PortalException {
        Folder folder = this.folderPersistence.findByPrimaryKey(folderId);
        return this.deleteFolder(folder);
    }

    public void deleteFolders(long accountId) throws PortalException {
        List folders = this.folderPersistence.findByAccountId(accountId);
        for (Folder folder : folders) {
            this.deleteFolder(folder);
        }
    }

    public Folder getFolder(long accountId, String fullName) throws PortalException {
        return this.folderPersistence.findByA_F(accountId, fullName);
    }

    public List<Folder> getFolders(long accountId) {
        return this.folderPersistence.findByAccountId(accountId);
    }

    public int getLocalPageCount(long folderId, int messagesPerPage) {
        int localMessageCount = this.messagePersistence.countByFolderId(folderId);
        return (int)Math.ceil((double)localMessageCount / (double)messagesPerPage);
    }

    public int getPercentDownloaded(long folderId) throws PortalException {
        Folder folder = this.folderPersistence.findByPrimaryKey(folderId);
        int remoteMessageCount = folder.getRemoteMessageCount();
        if (remoteMessageCount == 0) {
            return 100;
        }
        int localMessageCount = this.messagePersistence.countByFolderId(folderId);
        return (int)((double)localMessageCount / (double)remoteMessageCount * 100.0);
    }

    public int getRemotePageCount(long folderId, int messagesPerPage) throws PortalException {
        Folder folder = this.folderPersistence.findByPrimaryKey(folderId);
        int remoteMessageCount = folder.getRemoteMessageCount();
        return (int)Math.ceil((double)remoteMessageCount / (double)messagesPerPage);
    }

    public Folder updateFolder(long folderId, String fullName, String displayName, int remoteMessageCount) throws PortalException {
        Folder folder = this.folderPersistence.findByPrimaryKey(folderId);
        folder.setModifiedDate(new Date());
        folder.setFullName(fullName);
        folder.setDisplayName(displayName);
        folder.setRemoteMessageCount(remoteMessageCount);
        this.folderPersistence.update((BaseModel)folder);
        return folder;
    }
}

