/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mail.reader.mailbox;

import com.liferay.mail.reader.model.Account;
import com.liferay.mail.reader.service.AccountLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class PasswordRetriever {
    private final HttpServletRequest _request;

    public PasswordRetriever(HttpServletRequest request) {
        if (request == null) {
            throw new IllegalStateException("Request is null");
        }
        this._request = request;
    }

    public String getPassword(long accountId) throws PortalException {
        Account account = AccountLocalServiceUtil.getAccount((long)accountId);
        if (account.isSavePassword()) {
            return account.getPasswordDecrypted();
        }
        HttpSession session = this._request.getSession();
        return (String)session.getAttribute(this.encodeKey(accountId));
    }

    public void removePassword(long accountId) {
        HttpSession session = this._request.getSession();
        session.removeAttribute(this.encodeKey(accountId));
    }

    public void setPassword(long accountId, String password) {
        HttpSession session = this._request.getSession();
        session.setAttribute(this.encodeKey(accountId), (Object)password);
    }

    protected String encodeKey(long accountId) {
        return PasswordRetriever.class.getName().concat("#").concat(String.valueOf(accountId));
    }
}

