/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mail.reader.mailbox;

import com.liferay.mail.reader.attachment.AttachmentHandler;
import com.liferay.mail.reader.attachment.DefaultAttachmentHandler;
import com.liferay.mail.reader.exception.MailException;
import com.liferay.mail.reader.exception.NoSuchFolderException;
import com.liferay.mail.reader.exception.NoSuchMessageException;
import com.liferay.mail.reader.internal.imap.IMAPAccessor;
import com.liferay.mail.reader.internal.imap.IMAPConnection;
import com.liferay.mail.reader.internal.util.AccountLock;
import com.liferay.mail.reader.mailbox.BaseMailbox;
import com.liferay.mail.reader.model.Account;
import com.liferay.mail.reader.model.Attachment;
import com.liferay.mail.reader.model.Folder;
import com.liferay.mail.reader.model.MailFile;
import com.liferay.mail.reader.model.Message;
import com.liferay.mail.reader.model.MessagesDisplay;
import com.liferay.mail.reader.service.AccountLocalServiceUtil;
import com.liferay.mail.reader.service.AttachmentLocalServiceUtil;
import com.liferay.mail.reader.service.FolderLocalServiceUtil;
import com.liferay.mail.reader.service.MessageLocalServiceUtil;
import com.liferay.petra.mail.InternetAddressUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.mail.Address;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

public class IMAPMailbox
extends BaseMailbox {
    private static final Log _log = LogFactoryUtil.getLog(IMAPMailbox.class);
    private final IMAPAccessor _imapAccessor;

    public IMAPMailbox(User user, Account account, String password) {
        this.setUser(user);
        this.setAccount(account);
        this._imapAccessor = account != null ? new IMAPAccessor(user, account, password) : null;
    }

    @Override
    public Folder addFolder(String displayName) throws PortalException {
        String[] names = this._imapAccessor.addFolder(displayName);
        return FolderLocalServiceUtil.addFolder((long)this.user.getUserId(), (long)this.account.getAccountId(), (String)names[0], (String)names[1], (int)0);
    }

    @Override
    public void deleteAttachment(long attachmentId) throws PortalException {
        AttachmentLocalServiceUtil.deleteAttachment((long)attachmentId);
    }

    @Override
    public void deleteFolder(long folderId) throws PortalException {
        if (this.account.getDraftFolderId() == folderId || this.account.getInboxFolderId() == folderId || this.account.getSentFolderId() == folderId || this.account.getTrashFolderId() == folderId) {
            throw new MailException(12);
        }
        this._imapAccessor.deleteFolder(folderId);
        FolderLocalServiceUtil.deleteFolder((long)folderId);
    }

    @Override
    public void deleteMessages(long folderId, long[] messageIds) throws PortalException {
        if (this.account.getDraftFolderId() != folderId && this.account.getTrashFolderId() != folderId) {
            Folder trashFolder = FolderLocalServiceUtil.getFolder((long)this.account.getTrashFolderId());
            this._imapAccessor.moveMessages(folderId, trashFolder.getFolderId(), messageIds, true);
        } else {
            this._imapAccessor.deleteMessages(folderId, messageIds);
        }
    }

    @Override
    public AttachmentHandler getAttachment(long attachmentId) throws IOException, PortalException {
        Attachment attachment = AttachmentLocalServiceUtil.getAttachment((long)attachmentId);
        Message message = MessageLocalServiceUtil.getMessage((long)attachment.getMessageId());
        if (this.account.getDraftFolderId() == attachment.getFolderId()) {
            return new DefaultAttachmentHandler(AttachmentLocalServiceUtil.getInputStream((long)attachmentId), null);
        }
        return this._imapAccessor.getAttachment(attachment.getFolderId(), message.getRemoteMessageId(), attachment.getContentPath());
    }

    @Override
    public Message getMessage(long folderId, String keywords, int messageNumber, String orderByField, String orderByType) throws PortalException {
        MessagesDisplay messagesDisplay = this.getMessagesDisplay(folderId, keywords, messageNumber, 1, orderByField, orderByType);
        List messages = messagesDisplay.getMessages();
        return (Message)messages.get(0);
    }

    @Override
    public MessagesDisplay getMessagesDisplay(long folderId, String keywords, int pageNumber, int messagesPerPage, String orderByField, String orderByType) throws PortalException {
        if (orderByField.equals("address")) {
            orderByField = "sender";
            if (this.account.getSentFolderId() == folderId) {
                orderByField = "to";
            }
        } else if (!(orderByField.equals("sentDate") || orderByField.equals("size") || orderByField.equals("subject"))) {
            orderByField = "sentDate";
        }
        ArrayList messages = new ArrayList(messagesPerPage);
        int messageCount = MessageLocalServiceUtil.populateMessages(messages, (long)folderId, (String)keywords, (int)pageNumber, (int)messagesPerPage, (String)orderByField, (String)orderByType);
        if (Validator.isNull((String)keywords) && this.account.getDraftFolderId() != folderId) {
            Folder folder = FolderLocalServiceUtil.getFolder((long)folderId);
            messageCount = folder.getRemoteMessageCount();
        }
        return new MessagesDisplay(messages, pageNumber, messagesPerPage, messageCount);
    }

    @Override
    public boolean hasNewMessages(long folderId) throws PortalException {
        return this._imapAccessor.hasNewMessages(folderId);
    }

    @Override
    public void moveMessages(long folderId, long[] messageIds) throws PortalException {
        for (long messageId : messageIds) {
            Message message = MessageLocalServiceUtil.getMessage((long)messageId);
            Account account = AccountLocalServiceUtil.getAccount((long)message.getAccountId());
            long sourceFolderId = message.getFolderId();
            if (account.getDraftFolderId() == sourceFolderId || account.getSentFolderId() == sourceFolderId) {
                throw new MailException(9);
            }
            this._imapAccessor.moveMessages(sourceFolderId, folderId, new long[]{messageId}, true);
        }
    }

    @Override
    public InternetAddress[] parseAddresses(String addresses) throws PortalException {
        InternetAddress[] internetAddresses = new InternetAddress[]{};
        try {
            for (InternetAddress internetAddress : internetAddresses = InternetAddress.parse((String)addresses, (boolean)true)) {
                if (Validator.isEmailAddress((String)internetAddress.getAddress())) continue;
                StringBundler sb = new StringBundler(4);
                sb.append(internetAddress.getPersonal());
                sb.append("<");
                sb.append(internetAddress.getAddress());
                sb.append(">");
                throw new MailException(14, sb.toString());
            }
        }
        catch (AddressException ae) {
            throw new MailException(14, (Throwable)ae, addresses);
        }
        return internetAddresses;
    }

    @Override
    public void renameFolder(long folderId, String displayName) throws PortalException {
        Folder folder = FolderLocalServiceUtil.getFolder((long)folderId);
        String[] names = this._imapAccessor.renameFolder(folderId, displayName);
        FolderLocalServiceUtil.updateFolder((long)folderId, (String)names[0], (String)names[1], (int)folder.getRemoteMessageCount());
    }

    @Override
    public Message saveDraft(long accountId, long messageId, String to, String cc, String bcc, String subject, String body, List<MailFile> mailFiles) throws PortalException {
        Account account = AccountLocalServiceUtil.getAccount((long)accountId);
        StringBundler sb = new StringBundler(4);
        sb.append(this.user.getFullName());
        sb.append(" <");
        sb.append(account.getAddress());
        sb.append(">");
        String sender = sb.toString();
        InternetAddress[] toAddresses = this.parseAddresses(to);
        InternetAddress[] ccAddresses = this.parseAddresses(cc);
        InternetAddress[] bccAddresses = this.parseAddresses(bcc);
        if (toAddresses.length == 0 && ccAddresses.length == 0 && bccAddresses.length == 0) {
            throw new MailException(13);
        }
        Message message = null;
        message = messageId != 0L ? MessageLocalServiceUtil.updateMessage((long)messageId, (long)account.getDraftFolderId(), (String)sender, (String)InternetAddressUtil.toString((Address[])toAddresses), (String)InternetAddressUtil.toString((Address[])ccAddresses), (String)InternetAddressUtil.toString((Address[])bccAddresses), null, (String)subject, (String)body, (String)String.valueOf(3), (long)0L) : MessageLocalServiceUtil.addMessage((long)this.user.getUserId(), (long)account.getDraftFolderId(), (String)sender, (String)to, (String)cc, (String)bcc, null, (String)subject, (String)body, (String)String.valueOf(3), (long)0L, null);
        if (mailFiles == null) {
            return message;
        }
        for (MailFile mailFile : mailFiles) {
            AttachmentLocalServiceUtil.addAttachment((long)this.user.getUserId(), (long)message.getMessageId(), null, (String)mailFile.getFileName(), (long)mailFile.getSize(), (File)mailFile.getFile());
        }
        return message;
    }

    @Override
    public void sendMessage(long accountId, long messageId) throws PortalException {
        Account account = AccountLocalServiceUtil.getAccount((long)accountId);
        Message message = MessageLocalServiceUtil.getMessage((long)messageId);
        InternetAddress[] toAddresses = this.parseAddresses(message.getTo());
        InternetAddress[] ccAddresses = this.parseAddresses(message.getCc());
        InternetAddress[] bccAddresses = this.parseAddresses(message.getBcc());
        if (toAddresses.length == 0 && ccAddresses.length == 0 && bccAddresses.length == 0) {
            throw new MailException(13);
        }
        List attachments = AttachmentLocalServiceUtil.getAttachments((long)messageId);
        ArrayList<MailFile> mailFiles = new ArrayList<MailFile>();
        for (Attachment attachment : attachments) {
            File file = AttachmentLocalServiceUtil.getFile((long)attachment.getAttachmentId());
            MailFile mailFile = new MailFile(file, attachment.getFileName(), attachment.getSize());
            mailFiles.add(mailFile);
        }
        this._imapAccessor.sendMessage(account.getPersonalName(), account.getAddress(), (Address[])toAddresses, (Address[])ccAddresses, (Address[])bccAddresses, message.getSubject(), message.getBody(), mailFiles);
        MessageLocalServiceUtil.deleteMessage((long)messageId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void synchronize() throws PortalException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Synchronizing all folders for accountId " + this.account.getAccountId()));
        }
        this.updateFolders();
        List folders = FolderLocalServiceUtil.getFolders((long)this.account.getAccountId());
        String key = AccountLock.getKey(this.user.getUserId(), this.account.getAccountId());
        if (AccountLock.acquireLock(key)) {
            try {
                for (Folder folder : folders) {
                    this._imapAccessor.storeEnvelopes(folder.getFolderId(), true);
                }
            }
            finally {
                AccountLock.releaseLock(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void synchronizeFolder(long folderId) throws PortalException {
        String key;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Synchronizing folder " + folderId));
        }
        if (AccountLock.acquireLock(key = AccountLock.getKey(this.user.getUserId(), this.account.getAccountId()))) {
            try {
                this._imapAccessor.storeEnvelopes(folderId, false);
            }
            finally {
                AccountLock.releaseLock(key);
            }
        }
    }

    @Override
    public void synchronizeMessage(long messageId) throws PortalException {
        Message message = MessageLocalServiceUtil.getMessage((long)messageId);
        long remoteMessageId = message.getRemoteMessageId();
        if (remoteMessageId == 0L) {
            return;
        }
        try {
            this._imapAccessor.storeContents(message.getFolderId(), new long[]{message.getRemoteMessageId()});
        }
        catch (IOException ioe) {
            throw new MailException((Throwable)ioe);
        }
    }

    @Override
    public void synchronizePage(long folderId, int pageNumber, int messagesPerPage) throws PortalException {
        long[] remoteMessageIds = this._imapAccessor.getMessageUIDs(folderId, pageNumber, messagesPerPage);
        ArrayList<Long> missingRemoteMessageIdsList = new ArrayList<Long>();
        for (long remoteMessageId : remoteMessageIds) {
            try {
                MessageLocalServiceUtil.getMessage((long)folderId, (long)remoteMessageId);
            }
            catch (NoSuchMessageException nsme) {
                missingRemoteMessageIdsList.add(remoteMessageId);
            }
        }
        if (!missingRemoteMessageIdsList.isEmpty()) {
            long[] missingRemoteMessageIds = ArrayUtil.toArray((Long[])missingRemoteMessageIdsList.toArray(new Long[missingRemoteMessageIdsList.size()]));
            this._imapAccessor.storeEnvelopes(folderId, missingRemoteMessageIds);
        }
    }

    @Override
    public void updateFlags(long folderId, long[] messageIds, int flag, boolean value) throws PortalException {
        Folder folder = FolderLocalServiceUtil.getFolder((long)folderId);
        Account account = AccountLocalServiceUtil.getAccount((long)folder.getAccountId());
        for (long messageId : messageIds) {
            MessageLocalServiceUtil.updateFlag((long)messageId, (int)flag, (boolean)value);
        }
        if (account.getDraftFolderId() == folderId) {
            this._imapAccessor.updateFlags(folderId, messageIds, flag, value, false);
        } else {
            this._imapAccessor.updateFlags(folderId, messageIds, flag, value, true);
        }
    }

    @Override
    public void updateFolders() throws PortalException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Updating folders");
        }
        List<javax.mail.Folder> jxFolders = this._imapAccessor.getFolders();
        for (javax.mail.Folder jxFolder : jxFolders) {
            try {
                FolderLocalServiceUtil.getFolder((long)this.account.getAccountId(), (String)jxFolder.getFullName());
            }
            catch (NoSuchFolderException nsfe) {
                FolderLocalServiceUtil.addFolder((long)this.user.getUserId(), (long)this.account.getAccountId(), (String)jxFolder.getFullName(), (String)jxFolder.getName(), (int)0);
            }
        }
        long draftFolderId = this.account.getDraftFolderId();
        long inboxFolderId = this.account.getInboxFolderId();
        long sentFolderId = this.account.getSentFolderId();
        long trashFolderId = this.account.getTrashFolderId();
        if (draftFolderId <= 0L) {
            draftFolderId = this.getFolderId("draft");
        }
        if (inboxFolderId <= 0L) {
            inboxFolderId = this.getFolderId("inbox");
        }
        if (sentFolderId <= 0L) {
            sentFolderId = this.getFolderId("sent");
        }
        if (sentFolderId <= 0L) {
            sentFolderId = this.getFolderId("sent-mail");
        }
        if (trashFolderId <= 0L) {
            trashFolderId = this.getFolderId("trash");
        }
        this.updateFolders(inboxFolderId, draftFolderId, sentFolderId, trashFolderId);
    }

    @Override
    public void validateAccount(String incomingHostName, int incomingPort, boolean incomingSecure, String outgoingHostName, int outgoingPort, boolean outgoingSecure, String login, String password) throws PortalException {
        IMAPConnection imapConnection = new IMAPConnection(incomingHostName, incomingPort, incomingSecure, outgoingHostName, outgoingPort, outgoingSecure, login, password);
        imapConnection.testConnection();
    }

    protected long getFolderId(String type) {
        ArrayList words = new ArrayList();
        for (Locale locale : LanguageUtil.getAvailableLocales()) {
            String translation = StringUtil.toLowerCase((String)LanguageUtil.get((Locale)locale, (String)type));
            words.addAll(ListUtil.toList((Object[])translation.split(" ")));
        }
        List folders = FolderLocalServiceUtil.getFolders((long)this.account.getAccountId());
        for (String word : words) {
            for (Folder folder : folders) {
                String folderName = StringUtil.toLowerCase((String)folder.getDisplayName());
                if (!folderName.contains(word)) continue;
                return folder.getFolderId();
            }
        }
        return 0L;
    }
}

