/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mail.reader.internal.model.listener;

import com.liferay.mail.reader.mailbox.Mailbox;
import com.liferay.mail.reader.mailbox.MailboxFactoryUtil;
import com.liferay.mail.reader.model.Account;
import com.liferay.mail.reader.service.AccountLocalServiceUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.User;
import java.util.List;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={ModelListener.class})
public class UserModelListener
extends BaseModelListener<User> {
    private static final Log _log = LogFactoryUtil.getLog(UserModelListener.class);

    public void onAfterRemove(User user) {
        try {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Removing mail accounts for user " + user.getUserId()));
            }
            List accounts = AccountLocalServiceUtil.getAccounts((long)user.getUserId());
            for (Account account : accounts) {
                Mailbox mailbox = MailboxFactoryUtil.getMailbox(user.getUserId(), account.getAccountId(), "");
                mailbox.deleteAccount();
            }
        }
        catch (Exception e) {
            _log.error((Object)("Unable to remove mail accounts for user " + user.getUserId()));
        }
    }
}

