/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mail.reader.internal.imap;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringBundler;
import javax.mail.event.ConnectionEvent;

public class ConnectionListener
implements javax.mail.event.ConnectionListener {
    private static final Log _log = LogFactoryUtil.getLog(ConnectionListener.class);
    private final String _service;
    private long _startTime;

    public ConnectionListener(String service) {
        this._service = service;
    }

    public void closed(ConnectionEvent connectionEvent) {
        if (_log.isDebugEnabled()) {
            long uptime = (System.currentTimeMillis() - this._startTime) / 1000L;
            _log.debug((Object)StringBundler.concat((String[])new String[]{"Closed ", this._service, " after ", String.valueOf(uptime), "seconds"}));
        }
    }

    public void disconnected(ConnectionEvent connectionEvent) {
        if (_log.isDebugEnabled()) {
            long uptime = (System.currentTimeMillis() - this._startTime) / 1000L;
            _log.debug((Object)StringBundler.concat((String[])new String[]{"Disconnected ", this._service, " after ", String.valueOf(uptime), "seconds"}));
        }
    }

    public void opened(ConnectionEvent connectionEvent) {
        this._startTime = System.currentTimeMillis();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Opened " + this._service));
        }
    }
}

