/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.lcs.messaging;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.liferay.lcs.messaging.TransportMetadata;
import java.io.IOException;
import java.io.Serializable;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(include=JsonTypeInfo.As.PROPERTY, property="class", use=JsonTypeInfo.Id.CLASS)
public abstract class Message
implements Serializable {
    public static final String PROTOCOL_VERSION_1_0 = "1.0";
    public static final String PROTOCOL_VERSION_1_1 = "1.1";
    public static final String PROTOCOL_VERSION_1_2 = "1.2";
    public static final String PROTOCOL_VERSION_1_3 = "1.3";
    public static final String PROTOCOL_VERSION_1_4 = "1.4";
    public static final String PROTOCOL_VERSION_1_5 = "1.5";
    public static final String PROTOCOL_VERSION_1_6 = "1.6";
    public static final String PROTOCOL_VERSION_1_7 = "1.7";
    public static final String PROTOCOL_VERSION_1_8 = "1.8";
    public static final String PROTOCOL_VERSION_CURRENT = "1.8";
    private static final ObjectMapper _objectMapper = new ObjectMapper(){
        {
            this.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
            TypeFactory typeFactory = TypeFactory.defaultInstance();
            typeFactory = typeFactory.withClassLoader(Message.class.getClassLoader());
            this.setTypeFactory(typeFactory);
        }
    };
    private long _createTime = System.currentTimeMillis();
    private long _deliveryTag;
    private int _errorCode;
    private String _errorMessage;
    private String _key;
    private String _protocolVersion = "1.8";
    private String _queueName;
    private String _toString;
    private TransportMetadata _transportMetadata;

    public static <T extends Message> T createMessage(String json) {
        return Message.createMessage(json, Message.class);
    }

    public static <T extends Message> T createMessage(String json, Class clazz) {
        try {
            return (T)((Message)_objectMapper.readValue(json, clazz));
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public long getCreateTime() {
        return this._createTime;
    }

    @JsonIgnore
    public long getDeliveryTag() {
        return this._deliveryTag;
    }

    public int getErrorCode() {
        return this._errorCode;
    }

    public String getErrorMessage() {
        return this._errorMessage;
    }

    public String getKey() {
        return this._key;
    }

    public String getProtocolVersion() {
        return this._protocolVersion;
    }

    @JsonIgnore
    public String getQueueName() {
        return this._queueName;
    }

    @JsonIgnore
    public String getSignatureString() {
        StringBuilder sb = new StringBuilder();
        Class<?> messageClass = this.getClass();
        sb.append(messageClass.getName());
        sb.append(this.getCreateTime());
        sb.append(this.getKey());
        sb.append(this.getProtocolVersion());
        return sb.toString();
    }

    @JsonIgnore
    public <T extends TransportMetadata> T getTransportMetadata() {
        return (T)this._transportMetadata;
    }

    public void setCreateTime(long createTime) {
        this._createTime = createTime;
        this._toString = null;
    }

    public void setDeliveryTag(long deliveryTag) {
        this._deliveryTag = deliveryTag;
    }

    public void setErrorCode(int errorCode) {
        this._errorCode = errorCode;
    }

    public void setErrorMessage(String errorMessage) {
        this._errorMessage = errorMessage;
    }

    public void setKey(String key) {
        this._key = key;
        this._toString = null;
    }

    public void setProtocolVersion(String protocolVersion) {
        this._protocolVersion = protocolVersion;
    }

    public void setQueueName(String queueName) {
        this._queueName = queueName;
    }

    public void setTransportMetadata(TransportMetadata transportMetadata) {
        this._transportMetadata = transportMetadata;
    }

    public String toJSON() {
        try {
            return _objectMapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException jpe) {
            throw new RuntimeException(jpe);
        }
    }

    public String toString() {
        if (this._toString != null) {
            return this._toString;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{className=");
        Class<?> clazz = this.getClass();
        sb.append(clazz.getName());
        sb.append(", createTime=");
        sb.append(this._createTime);
        sb.append(", key=");
        sb.append(this._key);
        sb.append("}");
        this._toString = sb.toString();
        return this._toString;
    }
}

