/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.lcs.messaging.internal.security;

import com.liferay.lcs.messaging.CommandMessage;
import com.liferay.lcs.messaging.Message;
import com.liferay.lcs.messaging.security.DigitalSignature;
import com.liferay.lcs.messaging.security.exception.DigitalSignatureException;
import com.liferay.lcs.security.KeyStoreAdvisor;
import com.liferay.lcs.security.KeyStoreFactory;
import java.security.KeyStore;
import java.security.Signature;
import java.security.cert.Certificate;
import javax.xml.bind.DatatypeConverter;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={DigitalSignature.class})
public class DigitalSignatureImpl
implements DigitalSignature {
    private String _keyAlias;
    private KeyStore _keyStore;
    private final KeyStoreAdvisor _keyStoreAdvisor = new KeyStoreAdvisor();
    private String _keyStorePassword = "_k3y#5t0r3-p45S";
    private String _keyStorePath;
    private String _keyStoreType;
    private String _signingAlgorithm;

    @Override
    public String getSignature(int buildNumber, String value) {
        try {
            return this.doGetSignature(buildNumber, value.getBytes());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to sign value", e);
        }
    }

    public void setKeyName(String keyName) {
        this._keyAlias = keyName;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this._keyStorePassword = keyStorePassword;
    }

    public void setKeyStorePath(String keyStorePath) {
        this._keyStorePath = keyStorePath;
    }

    public void setKeyStoreType(String keyStoreType) {
        this._keyStoreType = keyStoreType;
    }

    public void setSigningAlgorithm(String signingAlgorithm) {
        this._signingAlgorithm = signingAlgorithm;
    }

    @Override
    public void signMessage(int buildNumber, Message message) {
        if (!(message instanceof CommandMessage)) {
            return;
        }
        CommandMessage commandMessage = (CommandMessage)message;
        try {
            commandMessage.setSignature(this.doGetSignature(buildNumber, this.getBytes(commandMessage)));
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to sign message", e);
        }
    }

    @Override
    public void signMessage(Message message) {
        if (!(message instanceof CommandMessage)) {
            return;
        }
        CommandMessage commandMessage = (CommandMessage)message;
        try {
            commandMessage.setSignature(this.doGetSignature(0, this.getBytes(commandMessage)));
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to sign message", e);
        }
    }

    @Override
    public boolean verifyMessage(int buildNumber, Message message) throws DigitalSignatureException {
        if (!(message instanceof CommandMessage)) {
            return true;
        }
        CommandMessage commandMessage = (CommandMessage)message;
        try {
            return this.doVerifyMessage(buildNumber, this.getBytes(commandMessage), commandMessage.getSignature());
        }
        catch (Exception e) {
            throw new DigitalSignatureException("Unable to verify message", e);
        }
    }

    @Override
    public boolean verifyValue(String value, String signature) throws DigitalSignatureException {
        try {
            return this.doVerifyMessage(0, value.getBytes(), signature);
        }
        catch (Exception e) {
            throw new DigitalSignatureException("Unable to verify message", e);
        }
    }

    protected String doGetSignature(int buildNumber, byte[] data) throws Exception {
        Signature signature = Signature.getInstance(this._signingAlgorithm);
        KeyStore.PasswordProtection protectionParameter = new KeyStore.PasswordProtection(this._keyStorePassword.toCharArray());
        KeyStore keyStore = this.getKeyStore();
        String keyAlias = this._keyStoreAdvisor.getKeyAlias(buildNumber, this._keyAlias, keyStore);
        KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(keyAlias, protectionParameter);
        signature.initSign(privateKeyEntry.getPrivateKey());
        signature.update(data);
        return DatatypeConverter.printBase64Binary((byte[])signature.sign());
    }

    protected boolean doVerifyMessage(int buildNumber, byte[] data, String signature) throws Exception {
        Signature signatureInstance = Signature.getInstance(this._signingAlgorithm);
        KeyStore keyStore = this.getKeyStore();
        String keyAlias = this._keyStoreAdvisor.getKeyAlias(buildNumber, this._keyAlias, keyStore);
        Certificate certificate = keyStore.getCertificate(keyAlias);
        signatureInstance.initVerify(certificate);
        signatureInstance.update(data);
        return signatureInstance.verify(DatatypeConverter.parseBase64Binary((String)signature));
    }

    protected byte[] getBytes(CommandMessage commandMessage) {
        String signatureString = commandMessage.getSignatureString();
        return signatureString.getBytes();
    }

    protected KeyStore getKeyStore() throws Exception {
        if (this._keyStore != null) {
            return this._keyStore;
        }
        this._keyStore = KeyStoreFactory.getInstance((String)this._keyStorePath, (String)this._keyStoreType, (String)this._keyStorePassword);
        return this._keyStore;
    }
}

