/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.service;

import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.client.extension.model.ClientExtensionEntryRel;
import com.liferay.client.extension.service.ClientExtensionEntryRelLocalService;
import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.fragment.cache.FragmentEntryLinkCache;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.processor.PortletRegistry;
import com.liferay.fragment.service.FragmentEntryLinkLocalService;
import com.liferay.friendly.url.model.FriendlyURLEntry;
import com.liferay.friendly.url.service.FriendlyURLEntryLocalService;
import com.liferay.layout.friendly.url.LayoutFriendlyURLEntryHelper;
import com.liferay.layout.model.LayoutClassedModelUsage;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.model.LayoutPageTemplateStructure;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalService;
import com.liferay.layout.page.template.service.LayoutPageTemplateStructureLocalService;
import com.liferay.layout.seo.model.LayoutSEOEntry;
import com.liferay.layout.seo.service.LayoutSEOEntryLocalService;
import com.liferay.layout.service.LayoutClassedModelUsageLocalService;
import com.liferay.layout.util.structure.DeletedLayoutStructureItem;
import com.liferay.layout.util.structure.FragmentStyledLayoutStructureItem;
import com.liferay.layout.util.structure.LayoutStructure;
import com.liferay.layout.util.structure.LayoutStructureItem;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.comment.CommentManager;
import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletPreferencesIds;
import com.liferay.portal.kernel.model.RoleModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactory;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.security.auth.GuestOrUserUtil;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.ImageLocalService;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.service.PortletPreferencesLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.ServiceWrapper;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.CopyLayoutThreadLocal;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.exportimport.staging.StagingAdvicesThreadLocal;
import com.liferay.segments.model.SegmentsExperience;
import com.liferay.segments.model.SegmentsExperienceModel;
import com.liferay.segments.service.SegmentsExperienceLocalService;
import com.liferay.sites.kernel.util.Sites;
import jakarta.portlet.PortletPreferences;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ServiceWrapper.class})
public class LayoutLocalServiceWrapper
extends com.liferay.portal.kernel.service.LayoutLocalServiceWrapper {
    private static final Log _log = LogFactoryUtil.getLog(LayoutLocalServiceWrapper.class);
    private static final TransactionConfig _transactionConfig = TransactionConfig.Factory.create((Propagation)Propagation.REQUIRED, (Class[])new Class[]{Exception.class}, (Class[])new Class[0]);
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private AssetTagLocalService _assetTagLocalService;
    @Reference
    private ClientExtensionEntryRelLocalService _clientExtensionEntryRelLocalService;
    @Reference
    private CommentManager _commentManager;
    @Reference
    private CounterLocalService _counterLocalService;
    @Reference
    private FragmentEntryLinkCache _fragmentEntryLinkCache;
    @Reference
    private FragmentEntryLinkLocalService _fragmentEntryLinkLocalService;
    @Reference
    private FriendlyURLEntryLocalService _friendlyURLEntryLocalService;
    @Reference
    private ImageLocalService _imageLocalService;
    @Reference
    private LayoutClassedModelUsageLocalService _layoutClassedModelUsageLocalService;
    @Reference
    private LayoutFriendlyURLEntryHelper _layoutFriendlyURLEntryHelper;
    @Reference
    private LayoutPageTemplateEntryLocalService _layoutPageTemplateEntryLocalService;
    @Reference
    private LayoutPageTemplateStructureLocalService _layoutPageTemplateStructureLocalService;
    @Reference
    private LayoutSEOEntryLocalService _layoutSEOEntryLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private PortletLocalService _portletLocalService;
    @Reference
    private PortletPreferencesFactory _portletPreferencesFactory;
    @Reference
    private PortletPreferencesLocalService _portletPreferencesLocalService;
    @Reference
    private PortletRegistry _portletRegistry;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private SegmentsExperienceLocalService _segmentsExperienceLocalService;
    @Reference
    private Sites _sites;
    @Reference
    private UserLocalService _userLocalService;

    public Layout copyLayoutContent(Layout sourceLayout, Layout targetLayout) throws Exception {
        List segmentsExperiences = this._segmentsExperienceLocalService.getSegmentsExperiences(sourceLayout.getGroupId(), sourceLayout.getPlid());
        long[] sourceSegmentsExperiencesIds = TransformUtil.transformToLongArray((Collection)segmentsExperiences, SegmentsExperienceModel::getSegmentsExperienceId);
        long[] targetSegmentsExperiencesIds = TransformUtil.transformToLongArray((Collection)segmentsExperiences, segmentsExperience -> {
            SegmentsExperience targetSegmentsExperience = this._segmentsExperienceLocalService.fetchSegmentsExperience(targetLayout.getGroupId(), segmentsExperience.getSegmentsExperienceKey(), targetLayout.getPlid());
            if (targetSegmentsExperience == null) {
                return null;
            }
            return targetSegmentsExperience.getSegmentsExperienceId();
        });
        return this._copyLayoutContent(false, sourceLayout, sourceSegmentsExperiencesIds, targetLayout, targetSegmentsExperiencesIds);
    }

    public Layout copyLayoutContent(long sourceSegmentsExperienceId, Layout sourceLayout, long targetSegmentsExperienceId, Layout targetLayout) throws Exception {
        return this._copyLayoutContent(true, sourceLayout, new long[]{sourceSegmentsExperienceId}, targetLayout, new long[]{targetSegmentsExperienceId});
    }

    public Layout fetchLayoutByFriendlyURL(long groupId, boolean privateLayout, String friendlyURL) {
        Layout layout = super.fetchLayoutByFriendlyURL(groupId, privateLayout, friendlyURL);
        if (layout != null) {
            return layout;
        }
        return this._fetchLayoutByFriendlyURL(groupId, privateLayout, friendlyURL);
    }

    public Layout getFriendlyURLLayout(long groupId, boolean privateLayout, String friendlyURL) throws PortalException {
        try {
            return super.getFriendlyURLLayout(groupId, privateLayout, friendlyURL);
        }
        catch (NoSuchLayoutException noSuchLayoutException) {
            Layout layout = this._fetchLayoutByFriendlyURL(groupId, privateLayout, friendlyURL);
            if (layout != null) {
                return layout;
            }
            throw noSuchLayoutException;
        }
    }

    public void updateLayoutContent(String data, Layout layout, long segmentsExperienceId) throws Exception {
        boolean copyLayout = CopyLayoutThreadLocal.isCopyLayout();
        ServiceContext currentServiceContext = ServiceContextThreadLocal.getServiceContext();
        try (SafeCloseable safeCloseable = CTCollectionThreadLocal.setCTCollectionIdWithSafeCloseable((long)layout.getCtCollectionId());){
            CopyLayoutThreadLocal.setCopyLayout((boolean)true);
            User user = this._getUser(0L, 0L, currentServiceContext);
            if (currentServiceContext == null || currentServiceContext.getUserId() != user.getUserId()) {
                ServiceContext serviceContext = new ServiceContext();
                serviceContext.setCompanyId(layout.getCompanyId());
                serviceContext.setUserId(user.getUserId());
                ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
            }
            TransactionInvokerUtil.invoke((TransactionConfig)_transactionConfig, () -> {
                this._layoutPageTemplateStructureLocalService.updateLayoutPageTemplateStructureData(user.getUserId(), layout.getGroupId(), layout.getPlid(), segmentsExperienceId, data);
                return null;
            });
        }
        catch (Throwable throwable) {
            if (_log.isDebugEnabled()) {
                _log.debug(throwable);
            }
            throw new Exception(throwable);
        }
        finally {
            CopyLayoutThreadLocal.setCopyLayout((boolean)copyLayout);
            ServiceContextThreadLocal.pushServiceContext((ServiceContext)currentServiceContext);
        }
    }

    private void _cleanDeletedSegmentsExperiences(Map<Long, Long> segmentsExperienceIdsMap, Layout targetLayout) throws Exception {
        List targetSegmentsExperiences = this._segmentsExperienceLocalService.getSegmentsExperiences(targetLayout.getGroupId(), targetLayout.getPlid());
        for (SegmentsExperience targetSegmentsExperience : targetSegmentsExperiences) {
            if (segmentsExperienceIdsMap.containsValue(targetSegmentsExperience.getSegmentsExperienceId())) continue;
            this._segmentsExperienceLocalService.deleteSegmentsExperience(targetSegmentsExperience.getSegmentsExperienceId());
        }
    }

    private void _copyAssetCategoryIdsAndAssetTagNames(Layout sourceLayout, Layout targetLayout, long userId) throws Exception {
        if (sourceLayout.isDraftLayout() || targetLayout.isDraftLayout()) {
            return;
        }
        this.updateAsset(userId, targetLayout, this._assetCategoryLocalService.getCategoryIds(Layout.class.getName(), sourceLayout.getPlid()), this._assetTagLocalService.getTagNames(Layout.class.getName(), sourceLayout.getPlid()));
    }

    private void _copyLayoutClassedModelUsages(Layout sourceLayout, Layout targetLayout) {
        long[] classNameIds = new long[]{this._portal.getClassNameId(FragmentEntryLink.class.getName()), this._portal.getClassNameId(LayoutPageTemplateStructure.class.getName())};
        List sourceLayoutLayoutClassedModelUsages = this._layoutClassedModelUsageLocalService.getLayoutClassedModelUsagesByPlid(sourceLayout.getPlid());
        this._deleteLayoutClassedModelUsages(classNameIds, sourceLayoutLayoutClassedModelUsages, targetLayout);
        List targetLayoutLayoutClassedModelUsages = this._layoutClassedModelUsageLocalService.getLayoutClassedModelUsagesByPlid(targetLayout.getPlid());
        for (LayoutClassedModelUsage sourceLayoutLayoutClassedModelUsage : sourceLayoutLayoutClassedModelUsages) {
            if (ArrayUtil.contains((long[])classNameIds, (long)sourceLayoutLayoutClassedModelUsage.getContainerType()) || this._hasLayoutClassedModelUsage(targetLayoutLayoutClassedModelUsages, sourceLayoutLayoutClassedModelUsage)) continue;
            this._layoutClassedModelUsageLocalService.addLayoutClassedModelUsage(sourceLayoutLayoutClassedModelUsage.getGroupId(), sourceLayoutLayoutClassedModelUsage.getClassExternalReferenceCode(), sourceLayoutLayoutClassedModelUsage.getClassNameId(), sourceLayoutLayoutClassedModelUsage.getClassPK(), sourceLayoutLayoutClassedModelUsage.getContainerKey(), sourceLayoutLayoutClassedModelUsage.getContainerType(), targetLayout.getPlid(), ServiceContextThreadLocal.getServiceContext());
        }
    }

    private Layout _copyLayoutContent(boolean copySegmentsExperience, Layout sourceLayout, long[] sourceSegmentsExperiencesIds, Layout targetLayout, long[] targetSegmentsExperiencesIds) throws Exception {
        boolean copyLayout = CopyLayoutThreadLocal.isCopyLayout();
        ServiceContext currentServiceContext = ServiceContextThreadLocal.getServiceContext();
        long ctCollectionId = sourceLayout.getCtCollectionId();
        if (ctCollectionId == 0L) {
            ctCollectionId = targetLayout.getCtCollectionId();
        }
        if (ctCollectionId == 0L) {
            ctCollectionId = CTCollectionThreadLocal.getCTCollectionId();
        }
        try {
            Layout layout;
            block15: {
                SafeCloseable safeCloseable = CTCollectionThreadLocal.setCTCollectionIdWithSafeCloseable((long)ctCollectionId);
                try {
                    CopyLayoutThreadLocal.setCopyLayout((boolean)true);
                    User user = this._getUser(sourceLayout.getUserId(), targetLayout.getUserId(), currentServiceContext);
                    if (currentServiceContext == null || currentServiceContext.getUserId() != user.getUserId()) {
                        ServiceContext serviceContext = new ServiceContext();
                        serviceContext.setCompanyId(targetLayout.getCompanyId());
                        serviceContext.setUserId(user.getUserId());
                        ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
                    }
                    layout = (Layout)TransactionInvokerUtil.invoke((TransactionConfig)_transactionConfig, (Callable)new CopyLayoutCallable(copySegmentsExperience, sourceLayout, sourceSegmentsExperiencesIds, targetLayout, targetSegmentsExperiencesIds, user));
                    if (safeCloseable == null) break block15;
                }
                catch (Throwable throwable) {
                    try {
                        if (safeCloseable != null) {
                            try {
                                safeCloseable.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable throwable3) {
                        if (_log.isDebugEnabled()) {
                            _log.debug(throwable3);
                        }
                        throw new Exception(throwable3);
                    }
                }
                safeCloseable.close();
            }
            return layout;
        }
        finally {
            CopyLayoutThreadLocal.setCopyLayout((boolean)copyLayout);
            ServiceContextThreadLocal.pushServiceContext((ServiceContext)currentServiceContext);
        }
    }

    private void _copyLayoutPageTemplateStructure(Map<String, String> instanceIdsMap, boolean masterLayoutCopy, Layout sourceLayout, long[] sourceSegmentsExperiencesIds, Layout targetLayout, long[] targetSegmentsExperiencesIds, User user) throws Exception {
        Map<Long, FragmentEntryLink> fragmentEntryLinksMap = this._getFragmentEntryLinksMap(sourceLayout, sourceSegmentsExperiencesIds, targetLayout);
        LayoutPageTemplateStructure layoutPageTemplateStructure = this._layoutPageTemplateStructureLocalService.fetchLayoutPageTemplateStructure(sourceLayout.getGroupId(), sourceLayout.getPlid());
        Set<Long> targetFragmentEntryLinkIds = this._getTargetFragmentEntryLinkIds(targetSegmentsExperiencesIds, targetLayout);
        LayoutPageTemplateStructure targetLayoutPageTemplateStructure = this._layoutPageTemplateStructureLocalService.fetchLayoutPageTemplateStructure(targetLayout.getGroupId(), targetLayout.getPlid());
        if (targetLayoutPageTemplateStructure == null) {
            this._layoutPageTemplateStructureLocalService.addLayoutPageTemplateStructure(user.getUserId(), targetLayout.getGroupId(), targetLayout.getPlid(), this._segmentsExperienceLocalService.fetchDefaultSegmentsExperienceId(targetLayout.getPlid()), null, ServiceContextThreadLocal.getServiceContext());
        }
        Map<Long, Long> segmentsExperienceIdsMap = this._getSegmentsExperienceIds(sourceSegmentsExperiencesIds, targetLayout, user);
        this._cleanDeletedSegmentsExperiences(segmentsExperienceIdsMap, targetLayout);
        for (Map.Entry<Long, Long> entry : segmentsExperienceIdsMap.entrySet()) {
            String data = layoutPageTemplateStructure.getData(entry.getKey().longValue());
            if (Validator.isNull((String)data)) {
                this._segmentsExperienceLocalService.deleteSegmentsExperience(entry.getKey().longValue());
                continue;
            }
            JSONObject dataJSONObject = this._processDataJSONObject(instanceIdsMap, LayoutStructure.of((String)data), masterLayoutCopy, sourceLayout, fragmentEntryLinksMap, targetLayout, targetFragmentEntryLinkIds, entry.getValue(), user);
            this._layoutPageTemplateStructureLocalService.updateLayoutPageTemplateStructureData(user.getUserId(), targetLayout.getGroupId(), targetLayout.getPlid(), entry.getValue().longValue(), dataJSONObject.toString());
            SegmentsExperience targetSegmentsExperience = this._segmentsExperienceLocalService.fetchSegmentsExperience(entry.getValue().longValue());
            SegmentsExperience sourceSegmentsExperience = this._segmentsExperienceLocalService.fetchSegmentsExperience(entry.getKey().longValue());
            targetSegmentsExperience.setPriority(sourceSegmentsExperience.getPriority());
            this._segmentsExperienceLocalService.updateSegmentsExperience(targetSegmentsExperience);
        }
        this._fragmentEntryLinkLocalService.deleteFragmentEntryLinks(ArrayUtil.toLongArray(targetFragmentEntryLinkIds));
    }

    private void _copyLayoutPageTemplateStructureFromSegmentsExperience(Map<String, String> instanceIdsMap, boolean masterLayoutCopy, Layout sourceLayout, long sourceSegmentsExperienceId, Layout targetLayout, long targetSegmentsExperienceId, User user) throws Exception {
        LayoutPageTemplateStructure layoutPageTemplateStructure = this._layoutPageTemplateStructureLocalService.fetchLayoutPageTemplateStructure(sourceLayout.getGroupId(), sourceLayout.getPlid());
        String data = layoutPageTemplateStructure.getData(sourceSegmentsExperienceId);
        if (Validator.isNull((String)data)) {
            return;
        }
        this._updateLayoutPageTemplateStructureData(data, instanceIdsMap, masterLayoutCopy, sourceLayout, sourceSegmentsExperienceId, targetLayout, targetSegmentsExperienceId, user);
    }

    private void _copyLayoutSEOEntry(Layout sourceLayout, Layout targetLayout, long userId) throws Exception {
        if (sourceLayout.isDraftLayout() || targetLayout.isDraftLayout()) {
            return;
        }
        LayoutSEOEntry layoutSEOEntry = this._layoutSEOEntryLocalService.fetchLayoutSEOEntry(sourceLayout.getGroupId(), sourceLayout.isPrivateLayout(), sourceLayout.getLayoutId());
        if (layoutSEOEntry == null) {
            LayoutSEOEntry targetLayoutSEOEntry = this._layoutSEOEntryLocalService.fetchLayoutSEOEntry(targetLayout.getGroupId(), targetLayout.isPrivateLayout(), targetLayout.getLayoutId());
            if (targetLayoutSEOEntry != null) {
                this._layoutSEOEntryLocalService.deleteLayoutSEOEntry(targetLayout.getGroupId(), targetLayout.isPrivateLayout(), targetLayout.getLayoutId());
            }
            return;
        }
        this._layoutSEOEntryLocalService.copyLayoutSEOEntry(userId, targetLayout.getGroupId(), targetLayout.isPrivateLayout(), targetLayout.getLayoutId(), layoutSEOEntry, ServiceContextThreadLocal.getServiceContext());
    }

    private void _copyPortletPermissions(List<String> portletIds, Layout sourceLayout, Layout targetLayout) throws Exception {
        for (String portletId : portletIds) {
            String resourceName = PortletIdCodec.decodePortletName((String)portletId);
            String sourceResourcePrimKey = PortletPermissionUtil.getPrimaryKey((long)sourceLayout.getPlid(), (String)portletId);
            Map sourceRoleIdsToActionIds = this._resourcePermissionLocalService.getAvailableResourcePermissionActionIds(targetLayout.getCompanyId(), resourceName, 4, sourceResourcePrimKey, (Collection)ResourceActionsUtil.getPortletResourceActions((String)resourceName));
            if (sourceRoleIdsToActionIds.isEmpty()) continue;
            List roleIds = TransformUtil.transform((Collection)ListUtil.filter((List)this._roleLocalService.getGroupRelatedRoles(targetLayout.getGroupId()), role -> !Objects.equals("Administrator", role.getName())), RoleModel::getRoleId);
            HashMap<Long, String[]> targetRoleIdsToActionIds = new HashMap<Long, String[]>();
            for (Map.Entry entry : sourceRoleIdsToActionIds.entrySet()) {
                Long roleId = (Long)entry.getKey();
                if (!roleIds.contains(roleId)) continue;
                Set sourceActionIds = (Set)entry.getValue();
                targetRoleIdsToActionIds.put(roleId, sourceActionIds.toArray(new String[0]));
            }
            this._resourcePermissionLocalService.setResourcePermissions(targetLayout.getCompanyId(), resourceName, 4, PortletPermissionUtil.getPrimaryKey((long)targetLayout.getPlid(), (String)portletId), targetRoleIdsToActionIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _copyPortletPreferences(Map<String, String> instanceIdsMap, boolean masterLayoutCopy, List<String> portletIds, Layout sourceLayout, Layout targetLayout) {
        boolean stagingAdvicesThreadLocalEnabled = StagingAdvicesThreadLocal.isEnabled();
        try {
            StagingAdvicesThreadLocal.setEnabled((boolean)false);
            for (String portletId : portletIds) {
                com.liferay.portal.kernel.model.PortletPreferences targetPortletPreferences;
                String instanceId;
                PortletPreferencesIds portletPreferencesIds;
                PortletPreferences jxPortletPreferences;
                Portlet portlet = this._portletLocalService.getPortletById(portletId);
                if (portlet == null || portlet.isUndeployedPortlet() || (jxPortletPreferences = this._portletPreferencesLocalService.fetchPreferences(portletPreferencesIds = this._portletPreferencesFactory.getPortletPreferencesIds(sourceLayout.getCompanyId(), sourceLayout.getGroupId(), 0L, sourceLayout.getPlid(), portletId))) == null) continue;
                String newPortletId = portletId;
                if (masterLayoutCopy && portlet.isInstanceable() && Validator.isNotNull((String)(instanceId = instanceIdsMap.get(PortletIdCodec.decodeInstanceId((String)portletId))))) {
                    newPortletId = PortletIdCodec.encode((String)portlet.getPortletName(), (String)instanceId);
                }
                if ((targetPortletPreferences = this._portletPreferencesLocalService.fetchPortletPreferences(portletPreferencesIds.getOwnerId(), portletPreferencesIds.getOwnerType(), targetLayout.getPlid(), portletId)) != null) {
                    this._portletPreferencesLocalService.updatePreferences(targetPortletPreferences.getOwnerId(), targetPortletPreferences.getOwnerType(), targetPortletPreferences.getPlid(), newPortletId, jxPortletPreferences);
                    continue;
                }
                this._portletPreferencesLocalService.addPortletPreferences(targetLayout.getCompanyId(), portletPreferencesIds.getOwnerId(), portletPreferencesIds.getOwnerType(), targetLayout.getPlid(), newPortletId, portlet, PortletPreferencesFactoryUtil.toXML((PortletPreferences)jxPortletPreferences));
            }
        }
        finally {
            StagingAdvicesThreadLocal.setEnabled((boolean)stagingAdvicesThreadLocalEnabled);
        }
    }

    private void _deleteLayoutClassedModelUsages(long[] classNameIds, List<LayoutClassedModelUsage> sourceLayoutLayoutClassedModelUsages, Layout targetLayout) {
        for (LayoutClassedModelUsage targetLayoutClassedModelUsage : this._layoutClassedModelUsageLocalService.getLayoutClassedModelUsagesByPlid(targetLayout.getPlid())) {
            if (ArrayUtil.contains((long[])classNameIds, (long)targetLayoutClassedModelUsage.getContainerType()) || this._hasLayoutClassedModelUsage(sourceLayoutLayoutClassedModelUsages, targetLayoutClassedModelUsage)) continue;
            this._layoutClassedModelUsageLocalService.deleteLayoutClassedModelUsage(targetLayoutClassedModelUsage);
        }
    }

    private List<String> _deletePortletPermissions(Layout layout, long[] segmentsExperiencesIds) throws Exception {
        List<String> portletIds = this._getLayoutPortletIds(layout, segmentsExperiencesIds);
        for (String portletId : portletIds) {
            this._resourcePermissionLocalService.deleteResourcePermissions(layout.getCompanyId(), PortletIdCodec.decodePortletName((String)portletId), 4, PortletPermissionUtil.getPrimaryKey((long)layout.getPlid(), (String)portletId));
        }
        return portletIds;
    }

    private Layout _fetchLayoutByFriendlyURL(long groupId, boolean privateLayout, String friendlyURL) {
        FriendlyURLEntry friendlyURLEntry = this._friendlyURLEntryLocalService.fetchFriendlyURLEntry(groupId, this._layoutFriendlyURLEntryHelper.getClassNameId(privateLayout), friendlyURL);
        if (friendlyURLEntry == null) {
            return null;
        }
        Layout layout = this.fetchLayout(friendlyURLEntry.getClassPK());
        if (layout != null) {
            return layout;
        }
        return null;
    }

    private Map<Long, FragmentEntryLink> _getFragmentEntryLinksMap(Layout sourceLayout, long[] sourceSegmentsExperiencesIds, Layout targetLayout) {
        HashMap<Long, FragmentEntryLink> fragmentEntryLinksMap = new HashMap<Long, FragmentEntryLink>();
        for (FragmentEntryLink fragmentEntryLink : this._fragmentEntryLinkLocalService.getFragmentEntryLinksBySegmentsExperienceId(sourceLayout.getGroupId(), sourceSegmentsExperiencesIds, sourceLayout.getPlid())) {
            if (fragmentEntryLink.isDeleted()) {
                FragmentEntryLink targetLayoutFragmentEntryLink = this._fragmentEntryLinkLocalService.getFragmentEntryLink(targetLayout.getGroupId(), fragmentEntryLink.getExternalReferenceCode(), targetLayout.getPlid());
                if (targetLayoutFragmentEntryLink == null) continue;
                this._fragmentEntryLinkLocalService.deleteFragmentEntryLink(targetLayoutFragmentEntryLink);
                continue;
            }
            fragmentEntryLinksMap.put(fragmentEntryLink.getFragmentEntryLinkId(), fragmentEntryLink);
        }
        return fragmentEntryLinksMap;
    }

    private List<String> _getLayoutPortletIds(Layout layout, long[] segmentsExperiencesIds) {
        ArrayList<String> layoutPortletIds = new ArrayList<String>();
        for (FragmentEntryLink fragmentEntryLink : this._fragmentEntryLinkLocalService.getFragmentEntryLinksBySegmentsExperienceId(layout.getGroupId(), segmentsExperiencesIds, layout.getPlid(), false)) {
            layoutPortletIds.addAll(this._portletRegistry.getFragmentEntryLinkPortletIds(fragmentEntryLink));
        }
        return layoutPortletIds;
    }

    private Map<Long, Long> _getSegmentsExperienceIds(long[] segmentsExperiencesIds, Layout targetLayout, User user) {
        HashMap<Long, Long> segmentsExperienceIdsMap = new HashMap<Long, Long>();
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        int minPriority = Integer.MIN_VALUE;
        for (long segmentsExperienceId : segmentsExperiencesIds) {
            SegmentsExperience sourceSegmentsExperience = this._segmentsExperienceLocalService.fetchSegmentsExperience(segmentsExperienceId);
            SegmentsExperience targetSegmentsExperience = this._segmentsExperienceLocalService.fetchSegmentsExperience(targetLayout.getGroupId(), sourceSegmentsExperience.getSegmentsExperienceKey(), targetLayout.getPlid());
            if (targetSegmentsExperience != null) {
                segmentsExperienceIdsMap.put(sourceSegmentsExperience.getSegmentsExperienceId(), targetSegmentsExperience.getSegmentsExperienceId());
                if (Objects.equals("DEFAULT", targetSegmentsExperience.getSegmentsExperienceKey())) continue;
                targetSegmentsExperience.setSegmentsEntryERC(sourceSegmentsExperience.getSegmentsEntryERC());
                targetSegmentsExperience.setSegmentsEntryScopeERC(sourceSegmentsExperience.getSegmentsEntryScopeERC());
                targetSegmentsExperience.setPriority(minPriority++);
                this._segmentsExperienceLocalService.updateSegmentsExperience(targetSegmentsExperience);
                continue;
            }
            SegmentsExperience newSegmentsExperience = (SegmentsExperience)sourceSegmentsExperience.clone();
            newSegmentsExperience.setUuid(serviceContext.getUuid());
            newSegmentsExperience.setExternalReferenceCode(null);
            newSegmentsExperience.setSegmentsExperienceId(this._counterLocalService.increment());
            newSegmentsExperience.setUserId(user.getUserId());
            newSegmentsExperience.setUserName(user.getFullName());
            newSegmentsExperience.setCreateDate(serviceContext.getCreateDate(new Date()));
            newSegmentsExperience.setModifiedDate(serviceContext.getModifiedDate(new Date()));
            newSegmentsExperience.setSegmentsExperienceKey(sourceSegmentsExperience.getSegmentsExperienceKey());
            newSegmentsExperience.setPlid(targetLayout.getPlid());
            newSegmentsExperience.setPriority(minPriority++);
            this._segmentsExperienceLocalService.addSegmentsExperience(newSegmentsExperience);
            segmentsExperienceIdsMap.put(sourceSegmentsExperience.getSegmentsExperienceId(), newSegmentsExperience.getSegmentsExperienceId());
        }
        return segmentsExperienceIdsMap;
    }

    private Set<Long> _getTargetFragmentEntryLinkIds(long[] segmentsExperiencesIds, Layout targetLayout) {
        return new HashSet<Long>(ListUtil.toList((List)this._fragmentEntryLinkLocalService.getFragmentEntryLinksBySegmentsExperienceId(targetLayout.getGroupId(), segmentsExperiencesIds, targetLayout.getPlid()), (Accessor)FragmentEntryLink.FRAGMENT_ENTRY_LINK_ID_ACCESSOR));
    }

    private String _getTypeSettings(Layout sourceLayout, Layout targetLayout) {
        if (!sourceLayout.isDraftLayout() && !targetLayout.isDraftLayout()) {
            return sourceLayout.getTypeSettings();
        }
        if (targetLayout.isDraftLayout()) {
            UnicodeProperties typeSettingsUnicodeProperties = UnicodePropertiesBuilder.create((boolean)true).fastLoad(sourceLayout.getTypeSettings()).build();
            return UnicodePropertiesBuilder.create((boolean)true).fastLoad(sourceLayout.getTypeSettings()).setProperty("published", Boolean.FALSE.toString()).setProperty("query-string", typeSettingsUnicodeProperties.getProperty("query-string")).setProperty("target", typeSettingsUnicodeProperties.getProperty("target")).setProperty("targetType", typeSettingsUnicodeProperties.getProperty("targetType")).buildString();
        }
        UnicodeProperties typeSettingsUnicodeProperties = UnicodePropertiesBuilder.create((boolean)true).fastLoad(targetLayout.getTypeSettings()).build();
        return UnicodePropertiesBuilder.create((boolean)true).fastLoad(sourceLayout.getTypeSettings()).setProperty("query-string", typeSettingsUnicodeProperties.getProperty("query-string")).setProperty("target", typeSettingsUnicodeProperties.getProperty("target")).setProperty("targetType", typeSettingsUnicodeProperties.getProperty("targetType")).buildString();
    }

    private User _getUser(long sourceLayoutUserId, long targetLayoutUserId, ServiceContext serviceContext) throws PortalException {
        User user = null;
        if (targetLayoutUserId > 0L) {
            user = this._userLocalService.fetchUser(targetLayoutUserId);
        }
        if (user != null) {
            return user;
        }
        if (sourceLayoutUserId > 0L) {
            user = this._userLocalService.fetchUser(sourceLayoutUserId);
        }
        if (user != null) {
            return user;
        }
        if (serviceContext != null) {
            user = serviceContext.fetchUser();
        }
        if (user != null) {
            return user;
        }
        return GuestOrUserUtil.getGuestOrUser();
    }

    private boolean _hasLayoutClassedModelUsage(List<LayoutClassedModelUsage> layoutClassedModelUsages, LayoutClassedModelUsage targetLayoutClassedModelUsage) {
        for (LayoutClassedModelUsage layoutClassedModelUsage : layoutClassedModelUsages) {
            if (layoutClassedModelUsage.getClassNameId() != targetLayoutClassedModelUsage.getClassNameId() || layoutClassedModelUsage.getClassPK() != targetLayoutClassedModelUsage.getClassPK() || !Objects.equals(layoutClassedModelUsage.getContainerKey(), targetLayoutClassedModelUsage.getContainerKey()) || layoutClassedModelUsage.getContainerType() != targetLayoutClassedModelUsage.getContainerType()) continue;
            return true;
        }
        return false;
    }

    private JSONObject _processDataJSONObject(Map<String, String> instanceIdsMap, LayoutStructure layoutStructure, boolean masterLayoutCopy, Layout sourceLayout, Map<Long, FragmentEntryLink> sourceLayoutFragmentEntryLinksMap, Layout targetLayout, Set<Long> targetLayoutFragmentEntryLinkIds, long targetSegmentsExperienceId, User user) throws Exception {
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        for (LayoutStructureItem layoutStructureItem : layoutStructure.getLayoutStructureItems()) {
            FragmentStyledLayoutStructureItem fragmentStyledLayoutStructureItem;
            FragmentEntryLink sourceLayoutFragmentEntryLink;
            if (!(layoutStructureItem instanceof FragmentStyledLayoutStructureItem) || (sourceLayoutFragmentEntryLink = sourceLayoutFragmentEntryLinksMap.get((fragmentStyledLayoutStructureItem = (FragmentStyledLayoutStructureItem)layoutStructureItem).getFragmentEntryLinkId())) == null) continue;
            String namespace = sourceLayoutFragmentEntryLink.getNamespace();
            JSONObject editableValuesJSONObject = sourceLayoutFragmentEntryLink.getEditableValuesJSONObject();
            if (masterLayoutCopy && sourceLayoutFragmentEntryLink.isTypePortlet() && Validator.isNotNull((String)editableValuesJSONObject.getString("instanceId"))) {
                namespace = instanceIdsMap.get(editableValuesJSONObject.getString("instanceId"));
                if (Validator.isNull((String)namespace)) {
                    namespace = StringUtil.randomId();
                    instanceIdsMap.put(sourceLayoutFragmentEntryLink.getNamespace(), namespace);
                }
                editableValuesJSONObject = JSONUtil.put((String)"instanceId", (Object)namespace).put("portletId", editableValuesJSONObject.getString("portletId"));
            }
            FragmentEntryLink newFragmentEntryLink = null;
            FragmentEntryLink originalFragmentEntryLink = this._fragmentEntryLinkLocalService.fetchFragmentEntryLink(fragmentStyledLayoutStructureItem.getFragmentEntryLinkId());
            FragmentEntryLink targetLayoutFragmentEntryLink = this._fragmentEntryLinkLocalService.getFragmentEntryLink(targetLayout.getGroupId(), originalFragmentEntryLink.getExternalReferenceCode(), targetLayout.getPlid());
            if (targetLayoutFragmentEntryLink != null) {
                targetLayoutFragmentEntryLink.setUserId(user.getUserId());
                targetLayoutFragmentEntryLink.setUserName(user.getFullName());
                targetLayoutFragmentEntryLink.setModifiedDate(serviceContext.getModifiedDate(new Date()));
                if (sourceLayout.getClassPK() == targetLayout.getPlid()) {
                    targetLayoutFragmentEntryLink.setOriginalFragmentEntryLinkERC(sourceLayoutFragmentEntryLink.getExternalReferenceCode());
                } else {
                    targetLayoutFragmentEntryLink.setOriginalFragmentEntryLinkERC(null);
                }
                targetLayoutFragmentEntryLink.setSegmentsExperienceId(targetSegmentsExperienceId);
                targetLayoutFragmentEntryLink.setClassPK(targetLayout.getPlid());
                targetLayoutFragmentEntryLink.setPlid(targetLayout.getPlid());
                targetLayoutFragmentEntryLink.setCss(sourceLayoutFragmentEntryLink.getCss());
                targetLayoutFragmentEntryLink.setHtml(sourceLayoutFragmentEntryLink.getHtml());
                targetLayoutFragmentEntryLink.setJs(sourceLayoutFragmentEntryLink.getJs());
                targetLayoutFragmentEntryLink.setConfiguration(sourceLayoutFragmentEntryLink.getConfiguration());
                targetLayoutFragmentEntryLink.setEditableValues(editableValuesJSONObject.toString());
                targetLayoutFragmentEntryLink.setNamespace(namespace);
                targetLayoutFragmentEntryLink.setLastPropagationDate(sourceLayoutFragmentEntryLink.getLastPropagationDate());
                newFragmentEntryLink = this._fragmentEntryLinkLocalService.updateFragmentEntryLink(targetLayoutFragmentEntryLink);
                this._commentManager.deleteDiscussion(FragmentEntryLink.class.getName(), newFragmentEntryLink.getFragmentEntryLinkId());
                this._fragmentEntryLinkCache.removeFragmentEntryLinkCache(newFragmentEntryLink);
            } else {
                newFragmentEntryLink = (FragmentEntryLink)sourceLayoutFragmentEntryLink.clone();
                newFragmentEntryLink.setUuid(serviceContext.getUuid());
                newFragmentEntryLink.setExternalReferenceCode(null);
                newFragmentEntryLink.setFragmentEntryLinkId(this._counterLocalService.increment());
                newFragmentEntryLink.setUserId(user.getUserId());
                newFragmentEntryLink.setUserName(user.getFullName());
                newFragmentEntryLink.setCreateDate(serviceContext.getCreateDate(new Date()));
                newFragmentEntryLink.setModifiedDate(serviceContext.getModifiedDate(new Date()));
                if (sourceLayout.getClassPK() == targetLayout.getPlid()) {
                    newFragmentEntryLink.setOriginalFragmentEntryLinkERC(sourceLayoutFragmentEntryLink.getExternalReferenceCode());
                } else {
                    newFragmentEntryLink.setOriginalFragmentEntryLinkERC(null);
                }
                newFragmentEntryLink.setSegmentsExperienceId(targetSegmentsExperienceId);
                newFragmentEntryLink.setClassNameId(this._portal.getClassNameId(Layout.class));
                newFragmentEntryLink.setClassPK(targetLayout.getPlid());
                newFragmentEntryLink.setPlid(targetLayout.getPlid());
                newFragmentEntryLink.setEditableValues(editableValuesJSONObject.toString());
                newFragmentEntryLink.setNamespace(namespace);
                newFragmentEntryLink.setLastPropagationDate(sourceLayoutFragmentEntryLink.getLastPropagationDate());
                newFragmentEntryLink = this._fragmentEntryLinkLocalService.addFragmentEntryLink(newFragmentEntryLink);
            }
            fragmentStyledLayoutStructureItem.setFragmentEntryLinkId(newFragmentEntryLink.getFragmentEntryLinkId());
            targetLayoutFragmentEntryLinkIds.remove(newFragmentEntryLink.getFragmentEntryLinkId());
            this._commentManager.copyDiscussion(user.getUserId(), targetLayout.getGroupId(), FragmentEntryLink.class.getName(), sourceLayoutFragmentEntryLink.getFragmentEntryLinkId(), newFragmentEntryLink.getFragmentEntryLinkId(), className -> serviceContext);
        }
        for (DeletedLayoutStructureItem deletedLayoutStructureItem : layoutStructure.getDeletedLayoutStructureItems()) {
            layoutStructure.deleteLayoutStructureItem(deletedLayoutStructureItem.getItemId());
        }
        return layoutStructure.toJSONObject();
    }

    private void _updateLayoutPageTemplateStructureData(String data, Map<String, String> instanceIdsMap, boolean masterLayoutCopy, Layout sourceLayout, long sourceSegmentsExperienceId, Layout targetLayout, long targetSegmentsExperienceId, User user) throws Exception {
        Set<Long> targetFragmentEntryLinkIds = this._getTargetFragmentEntryLinkIds(new long[]{targetSegmentsExperienceId}, targetLayout);
        LayoutStructure layoutStructure = LayoutStructure.of((String)data);
        for (DeletedLayoutStructureItem deletedLayoutStructureItem : layoutStructure.getDeletedLayoutStructureItems()) {
            layoutStructure.deleteLayoutStructureItem(deletedLayoutStructureItem.getItemId());
        }
        JSONObject dataJSONObject = this._processDataJSONObject(instanceIdsMap, layoutStructure, masterLayoutCopy, sourceLayout, this._getFragmentEntryLinksMap(sourceLayout, new long[]{sourceSegmentsExperienceId}, targetLayout), targetLayout, targetFragmentEntryLinkIds, targetSegmentsExperienceId, user);
        this._layoutPageTemplateStructureLocalService.updateLayoutPageTemplateStructureData(user.getUserId(), targetLayout.getGroupId(), targetLayout.getPlid(), targetSegmentsExperienceId, dataJSONObject.toString());
        this._fragmentEntryLinkLocalService.deleteFragmentEntryLinks(ArrayUtil.toLongArray(targetFragmentEntryLinkIds));
    }

    private class CopyLayoutCallable
    implements Callable<Layout> {
        private final boolean _copySegmentsExperience;
        private final Layout _sourceLayout;
        private final long[] _sourceSegmentsExperiencesIds;
        private final Layout _targetLayout;
        private final long[] _targetSegmentsExperiencesIds;
        private final User _user;

        @Override
        public Layout call() throws Exception {
            boolean masterLayoutCopy = this._isMasterLayoutCopy();
            if (Objects.equals(this._sourceLayout.getType(), "portlet")) {
                LayoutLocalServiceWrapper.this._sites.copyPortletPermissions(this._targetLayout, this._sourceLayout);
            } else {
                List<String> oldPortletIds = LayoutLocalServiceWrapper.this._deletePortletPermissions(this._targetLayout, this._targetSegmentsExperiencesIds);
                HashMap<String, String> instanceIdsMap = new HashMap<String, String>();
                if (this._copySegmentsExperience) {
                    LayoutLocalServiceWrapper.this._copyLayoutPageTemplateStructureFromSegmentsExperience(instanceIdsMap, masterLayoutCopy, this._sourceLayout, this._sourceSegmentsExperiencesIds[0], this._targetLayout, this._targetSegmentsExperiencesIds[0], this._user);
                } else {
                    LayoutLocalServiceWrapper.this._copyLayoutPageTemplateStructure(instanceIdsMap, masterLayoutCopy, this._sourceLayout, this._sourceSegmentsExperiencesIds, this._targetLayout, this._targetSegmentsExperiencesIds, this._user);
                }
                List<String> portletIds = LayoutLocalServiceWrapper.this._getLayoutPortletIds(this._sourceLayout, this._sourceSegmentsExperiencesIds);
                LayoutLocalServiceWrapper.this._copyPortletPermissions(portletIds, this._sourceLayout, this._targetLayout);
                LayoutLocalServiceWrapper.this._copyPortletPreferences(instanceIdsMap, masterLayoutCopy, portletIds, this._sourceLayout, this._targetLayout);
                this._deleteOrphanPortletPreferences(portletIds, oldPortletIds);
            }
            LayoutLocalServiceWrapper.this._copyLayoutClassedModelUsages(this._sourceLayout, this._targetLayout);
            LayoutLocalServiceWrapper.this._sites.copyExpandoBridgeAttributes(this._sourceLayout, this._targetLayout);
            if (!masterLayoutCopy) {
                LayoutLocalServiceWrapper.this._sites.copyPortletSetups(this._sourceLayout, this._targetLayout);
            }
            LayoutLocalServiceWrapper.this._copyAssetCategoryIdsAndAssetTagNames(this._sourceLayout, this._targetLayout, this._user.getUserId());
            LayoutLocalServiceWrapper.this._copyLayoutSEOEntry(this._sourceLayout, this._targetLayout, this._user.getUserId());
            this._copyLayoutClientExtensions(this._sourceLayout, this._targetLayout, this._user.getUserId());
            Image image = LayoutLocalServiceWrapper.this._imageLocalService.getImage(this._sourceLayout.getIconImageId());
            byte[] imageBytes = null;
            if (image != null) {
                imageBytes = image.getTextObj();
            }
            return LayoutLocalServiceWrapper.this.updateLayout(this._targetLayout.getGroupId(), this._targetLayout.isPrivateLayout(), this._targetLayout.getLayoutId(), LayoutLocalServiceWrapper.this._getTypeSettings(this._sourceLayout, this._targetLayout), imageBytes, this._sourceLayout.getThemeId(), this._sourceLayout.getColorSchemeId(), this._sourceLayout.getStyleBookEntryERC(), this._sourceLayout.getCss(), this._sourceLayout.getFaviconFileEntryERC(), this._sourceLayout.getFaviconFileEntryScopeERC(), this._sourceLayout.getMasterLayoutPageTemplateEntryERC());
        }

        private CopyLayoutCallable(boolean copySegmentsExperience, Layout sourceLayout, long[] sourceSegmentsExperiencesIds, Layout targetLayout, long[] targetSegmentsExperiencesIds, User user) {
            this._copySegmentsExperience = copySegmentsExperience;
            this._sourceLayout = sourceLayout;
            this._sourceSegmentsExperiencesIds = sourceSegmentsExperiencesIds;
            this._targetLayout = targetLayout;
            this._targetSegmentsExperiencesIds = targetSegmentsExperiencesIds;
            this._user = user;
        }

        private void _copyLayoutClientExtensions(Layout sourceLayout, Layout targetLayout, long userId) throws Exception {
            long classNameId = LayoutLocalServiceWrapper.this._portal.getClassNameId(Layout.class);
            LayoutLocalServiceWrapper.this._clientExtensionEntryRelLocalService.deleteClientExtensionEntryRels(classNameId, targetLayout.getPlid());
            List clientExtensionEntryRels = LayoutLocalServiceWrapper.this._clientExtensionEntryRelLocalService.getClientExtensionEntryRels(classNameId, sourceLayout.getPlid());
            for (ClientExtensionEntryRel clientExtensionEntryRel : clientExtensionEntryRels) {
                LayoutLocalServiceWrapper.this._clientExtensionEntryRelLocalService.addClientExtensionEntryRel(userId, targetLayout.getGroupId(), classNameId, targetLayout.getPlid(), clientExtensionEntryRel.getCETExternalReferenceCode(), clientExtensionEntryRel.getType(), clientExtensionEntryRel.getTypeSettings(), ServiceContextThreadLocal.getServiceContext());
            }
        }

        private void _deleteOrphanPortletPreferences(List<String> portletIds, List<String> oldPortletIds) {
            Object[] deletedPortletIds = (String[])TransformUtil.transformToArray(oldPortletIds, portletId -> {
                if (portletIds.contains(portletId)) {
                    return null;
                }
                return portletId;
            }, String.class);
            if (ArrayUtil.isEmpty((Object[])deletedPortletIds)) {
                return;
            }
            LayoutPageTemplateEntry layoutPageTemplateEntry = LayoutLocalServiceWrapper.this._layoutPageTemplateEntryLocalService.fetchLayoutPageTemplateEntryByPlid(this._targetLayout.getPlid());
            if (layoutPageTemplateEntry == null || !Objects.equals(layoutPageTemplateEntry.getType(), 3)) {
                return;
            }
            for (Object portletId2 : deletedPortletIds) {
                for (com.liferay.portal.kernel.model.PortletPreferences portletPreferences : LayoutLocalServiceWrapper.this._portletPreferencesLocalService.getPortletPreferencesByPortletId((String)portletId2)) {
                    try {
                        LayoutLocalServiceWrapper.this._portletPreferencesLocalService.deletePortletPreferences(portletPreferences);
                    }
                    catch (Exception exception) {
                        if (!_log.isDebugEnabled()) continue;
                        _log.debug((Throwable)exception);
                    }
                }
            }
        }

        private boolean _isMasterLayoutCopy() {
            if (this._sourceLayout.getClassPK() == this._targetLayout.getPlid() || this._sourceLayout.getPlid() == this._targetLayout.getClassPK() || Validator.isNotNull((String)this._targetLayout.getMasterLayoutPageTemplateEntryERC())) {
                return false;
            }
            LayoutPageTemplateEntry layoutPageTemplateEntry = LayoutLocalServiceWrapper.this._layoutPageTemplateEntryLocalService.fetchLayoutPageTemplateEntryByPlid(this._targetLayout.getPlid());
            if (layoutPageTemplateEntry == null) {
                layoutPageTemplateEntry = LayoutLocalServiceWrapper.this._layoutPageTemplateEntryLocalService.fetchLayoutPageTemplateEntryByPlid(this._targetLayout.getClassPK());
            }
            return layoutPageTemplateEntry != null && layoutPageTemplateEntry.getType() == 3;
        }
    }
}

