/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.service.impl;

import com.liferay.layout.model.LayoutClassedModelUsage;
import com.liferay.layout.model.LayoutClassedModelUsageModel;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalService;
import com.liferay.layout.service.base.LayoutClassedModelUsageLocalServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.mass.delete.MassDeleteCacheThreadLocal;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.layout.model.LayoutClassedModelUsage"}, service={AopService.class})
public class LayoutClassedModelUsageLocalServiceImpl
extends LayoutClassedModelUsageLocalServiceBaseImpl {
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPageTemplateEntryLocalService _layoutPageTemplateEntryLocalService;

    public LayoutClassedModelUsage addLayoutClassedModelUsage(long groupId, String classExternalReferenceCode, long classNameId, long classPK, String containerKey, long containerType, long plid, ServiceContext serviceContext) {
        long layoutClassedModelUsageId = this.counterLocalService.increment();
        LayoutClassedModelUsage layoutClassedModelUsage = this.layoutClassedModelUsagePersistence.create(layoutClassedModelUsageId);
        layoutClassedModelUsage.setUuid(serviceContext.getUuid());
        layoutClassedModelUsage.setGroupId(groupId);
        long companyId = serviceContext.getCompanyId();
        Group group = this._groupLocalService.fetchGroup(groupId);
        if (group != null) {
            companyId = group.getCompanyId();
        }
        layoutClassedModelUsage.setCompanyId(companyId);
        layoutClassedModelUsage.setClassExternalReferenceCode(classExternalReferenceCode);
        layoutClassedModelUsage.setClassNameId(classNameId);
        layoutClassedModelUsage.setClassPK(classPK);
        layoutClassedModelUsage.setContainerKey(containerKey);
        layoutClassedModelUsage.setContainerType(containerType);
        layoutClassedModelUsage.setPlid(plid);
        layoutClassedModelUsage.setType(this._getType(plid));
        return (LayoutClassedModelUsage)this.layoutClassedModelUsagePersistence.update((BaseModel)layoutClassedModelUsage);
    }

    public void deleteLayoutClassedModelUsages(long classNameId, long classPK) {
        Map partitionLayoutClassedModelUsages = (Map)MassDeleteCacheThreadLocal.getMassDeleteCache((String)(LayoutClassedModelUsageLocalServiceImpl.class.getName() + ".deleteLayoutClassedModelUsages#" + classNameId), () -> MapUtil.toPartitionMap((List)this.layoutClassedModelUsagePersistence.findByC_CN(CompanyThreadLocal.getCompanyId().longValue(), classNameId), LayoutClassedModelUsageModel::getClassPK));
        if (partitionLayoutClassedModelUsages == null) {
            this.layoutClassedModelUsagePersistence.removeByCN_CPK(classNameId, classPK);
            return;
        }
        List layoutClassedModelUsages = (List)partitionLayoutClassedModelUsages.remove(classPK);
        ListUtil.isNotEmptyForEach((List)layoutClassedModelUsages, layoutClassedModelUsage -> this.layoutClassedModelUsagePersistence.remove((BaseModel)layoutClassedModelUsage));
    }

    public void deleteLayoutClassedModelUsages(String containerKey, long containerType, long plid) {
        this.layoutClassedModelUsagePersistence.removeByCK_CT_P(containerKey, containerType, plid);
    }

    public void deleteLayoutClassedModelUsagesByPlid(long plid) {
        this.layoutClassedModelUsagePersistence.removeByPlid(plid);
    }

    public LayoutClassedModelUsage fetchLayoutClassedModelUsage(long groupId, String classExternalReferenceCode, long classNameId, long classPK, String containerKey, long containerType, long plid) {
        return this.layoutClassedModelUsagePersistence.fetchByG_CERC_CN_CPK_CK_CT_P(groupId, classExternalReferenceCode, classNameId, classPK, containerKey, containerType, plid);
    }

    public List<LayoutClassedModelUsage> getLayoutClassedModelUsages(long classNameId, long classPK) {
        return this.layoutClassedModelUsagePersistence.findByCN_CPK(classNameId, classPK);
    }

    public List<LayoutClassedModelUsage> getLayoutClassedModelUsages(long classNameId, long classPK, int type, int start, int end, OrderByComparator<LayoutClassedModelUsage> orderByComparator) {
        return this.layoutClassedModelUsagePersistence.findByCN_CPK_T(classNameId, classPK, type, start, end, orderByComparator);
    }

    public List<LayoutClassedModelUsage> getLayoutClassedModelUsages(long classNameId, long classPK, int start, int end, OrderByComparator<LayoutClassedModelUsage> orderByComparator) {
        return this.layoutClassedModelUsagePersistence.findByCN_CPK(classNameId, classPK, start, end, orderByComparator);
    }

    public List<LayoutClassedModelUsage> getLayoutClassedModelUsages(long companyId, long classNameId, long containerType) {
        return this.layoutClassedModelUsagePersistence.findByC_CN_CT(companyId, classNameId, containerType);
    }

    public List<LayoutClassedModelUsage> getLayoutClassedModelUsagesByPlid(long plid) {
        return this.layoutClassedModelUsagePersistence.findByPlid(plid);
    }

    public int getLayoutClassedModelUsagesCount(long classNameId, long classPK) {
        return this.layoutClassedModelUsagePersistence.countByCN_CPK(classNameId, classPK);
    }

    public int getLayoutClassedModelUsagesCount(long classNameId, long classPK, int type) {
        return this.layoutClassedModelUsagePersistence.countByCN_CPK_T(classNameId, classPK, type);
    }

    public LayoutClassedModelUsage updateLayoutClassedModelUsage(long classNameId, long classPK, String containerKey, long containerType, long layoutClassedModelUsageId, long plid) throws PortalException {
        LayoutClassedModelUsage layoutClassedModelUsage = this.layoutClassedModelUsagePersistence.findByPrimaryKey(layoutClassedModelUsageId);
        layoutClassedModelUsage.setClassNameId(classNameId);
        layoutClassedModelUsage.setClassPK(classPK);
        layoutClassedModelUsage.setContainerKey(containerKey);
        layoutClassedModelUsage.setContainerType(containerType);
        layoutClassedModelUsage.setPlid(plid);
        return (LayoutClassedModelUsage)this.layoutClassedModelUsagePersistence.update((BaseModel)layoutClassedModelUsage);
    }

    private int _getType(long plid) {
        LayoutPageTemplateEntry layoutPageTemplateEntry;
        if (plid <= 0L) {
            return 0;
        }
        Layout layout = this._layoutLocalService.fetchLayout(plid);
        if (layout == null) {
            return 0;
        }
        if (layout.isDraftLayout()) {
            plid = layout.getClassPK();
        }
        if ((layoutPageTemplateEntry = this._layoutPageTemplateEntryLocalService.fetchLayoutPageTemplateEntryByPlid(plid)) == null) {
            return 2;
        }
        if (layoutPageTemplateEntry.getType() == 1) {
            return 1;
        }
        return 3;
    }
}

