/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.upgrade.v1_4_4;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.PortalPreferencesLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portlet.PortalPreferencesImpl;
import com.liferay.portlet.PortalPreferencesWrapper;
import com.liferay.release.feature.flag.ReleaseFeatureFlag;
import com.liferay.release.feature.flag.ReleaseFeatureFlagManager;
import com.liferay.release.feature.flag.ReleaseFeatureFlagManagerUtil;

public class LayoutPrivateLayoutsUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(LayoutPrivateLayoutsUpgradeProcess.class);
    private final CompanyLocalService _companyLocalService;
    private final PortalPreferencesLocalService _portalPreferencesLocalService;
    private final ReleaseFeatureFlagManager _releaseFeatureFlagManager;

    public LayoutPrivateLayoutsUpgradeProcess(CompanyLocalService companyLocalService, PortalPreferencesLocalService portalPreferencesLocalService, ReleaseFeatureFlagManager releaseFeatureFlagManager) {
        this._companyLocalService = companyLocalService;
        this._portalPreferencesLocalService = portalPreferencesLocalService;
        this._releaseFeatureFlagManager = releaseFeatureFlagManager;
    }

    protected void doUpgrade() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            String value = ReleaseFeatureFlagManagerUtil.isEnabled((ReleaseFeatureFlag)ReleaseFeatureFlag.DISABLE_PRIVATE_LAYOUTS) ? Boolean.FALSE.toString() : Boolean.TRUE.toString();
            this._companyLocalService.forEachCompanyId(companyId -> {
                try {
                    PortalPreferencesWrapper portalPreferencesWrapper = (PortalPreferencesWrapper)this._portalPreferencesLocalService.getPreferences(companyId.longValue(), 1);
                    PortalPreferencesImpl portalPreferences = portalPreferencesWrapper.getPortalPreferencesImpl();
                    portalPreferences.setValue("feature.flag", "LPD-38869", value);
                    this._portalPreferencesLocalService.updatePreferences(companyId.longValue(), 1, (PortalPreferences)portalPreferences);
                }
                catch (Exception exception) {
                    _log.error((Throwable)exception);
                }
            });
        }
    }
}

