/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.service;

import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.client.extension.model.ClientExtensionEntryRel;
import com.liferay.client.extension.service.ClientExtensionEntryRelLocalService;
import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.fragment.cache.FragmentEntryLinkCache;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.processor.PortletRegistry;
import com.liferay.fragment.service.FragmentEntryLinkLocalService;
import com.liferay.friendly.url.model.FriendlyURLEntry;
import com.liferay.friendly.url.service.FriendlyURLEntryLocalService;
import com.liferay.layout.friendly.url.LayoutFriendlyURLEntryHelper;
import com.liferay.layout.model.LayoutClassedModelUsage;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.model.LayoutPageTemplateStructure;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalService;
import com.liferay.layout.page.template.service.LayoutPageTemplateStructureLocalService;
import com.liferay.layout.seo.model.LayoutSEOEntry;
import com.liferay.layout.seo.service.LayoutSEOEntryLocalService;
import com.liferay.layout.service.LayoutClassedModelUsageLocalService;
import com.liferay.layout.util.structure.DeletedLayoutStructureItem;
import com.liferay.layout.util.structure.FragmentStyledLayoutStructureItem;
import com.liferay.layout.util.structure.LayoutStructure;
import com.liferay.layout.util.structure.LayoutStructureItem;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.comment.CommentManager;
import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletPreferences;
import com.liferay.portal.kernel.model.PortletPreferencesIds;
import com.liferay.portal.kernel.model.RoleModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactory;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.security.auth.GuestOrUserUtil;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.ImageLocalService;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.service.PortletPreferencesLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.ServiceWrapper;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.exportimport.staging.StagingAdvicesThreadLocal;
import com.liferay.segments.model.SegmentsExperience;
import com.liferay.segments.model.SegmentsExperienceModel;
import com.liferay.segments.service.SegmentsExperienceLocalService;
import com.liferay.sites.kernel.util.Sites;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ServiceWrapper.class})
public class LayoutLocalServiceWrapper
extends com.liferay.portal.kernel.service.LayoutLocalServiceWrapper {
    private static final Log _log = LogFactoryUtil.getLog(LayoutLocalServiceWrapper.class);
    private static final TransactionConfig _transactionConfig = TransactionConfig.Factory.create((Propagation)Propagation.REQUIRED, (Class[])new Class[]{Exception.class}, (Class[])new Class[0]);
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private AssetTagLocalService _assetTagLocalService;
    @Reference
    private ClientExtensionEntryRelLocalService _clientExtensionEntryRelLocalService;
    @Reference
    private CommentManager _commentManager;
    @Reference
    private CounterLocalService _counterLocalService;
    @Reference
    private FragmentEntryLinkCache _fragmentEntryLinkCache;
    @Reference
    private FragmentEntryLinkLocalService _fragmentEntryLinkLocalService;
    @Reference
    private FriendlyURLEntryLocalService _friendlyURLEntryLocalService;
    @Reference
    private ImageLocalService _imageLocalService;
    @Reference
    private LayoutClassedModelUsageLocalService _layoutClassedModelUsageLocalService;
    @Reference
    private LayoutFriendlyURLEntryHelper _layoutFriendlyURLEntryHelper;
    @Reference
    private LayoutPageTemplateEntryLocalService _layoutPageTemplateEntryLocalService;
    @Reference
    private LayoutPageTemplateStructureLocalService _layoutPageTemplateStructureLocalService;
    @Reference
    private LayoutSEOEntryLocalService _layoutSEOEntryLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private PortletLocalService _portletLocalService;
    @Reference
    private PortletPreferencesFactory _portletPreferencesFactory;
    @Reference
    private PortletPreferencesLocalService _portletPreferencesLocalService;
    @Reference
    private PortletRegistry _portletRegistry;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private SegmentsExperienceLocalService _segmentsExperienceLocalService;
    @Reference
    private Sites _sites;
    @Reference
    private UserLocalService _userLocalService;

    public Layout copyLayoutContent(Layout sourceLayout, Layout targetLayout) throws Exception {
        return this.copyLayoutContent(TransformUtil.transformToLongArray((Collection)this._segmentsExperienceLocalService.getSegmentsExperiences(sourceLayout.getGroupId(), sourceLayout.getPlid()), SegmentsExperienceModel::getSegmentsExperienceId), sourceLayout, targetLayout);
    }

    public Layout copyLayoutContent(long segmentsExperienceId, Layout sourceLayout, Layout targetLayout) throws Exception {
        return this._copyLayoutContent(true, sourceLayout, new long[]{segmentsExperienceId}, targetLayout, new long[]{this._segmentsExperienceLocalService.fetchDefaultSegmentsExperienceId(targetLayout.getPlid())});
    }

    public Layout copyLayoutContent(long[] segmentsExperiencesIds, Layout sourceLayout, Layout targetLayout) throws Exception {
        return this._copyLayoutContent(false, sourceLayout, segmentsExperiencesIds, targetLayout, segmentsExperiencesIds);
    }

    public Layout fetchLayoutByFriendlyURL(long groupId, boolean privateLayout, String friendlyURL) {
        Layout layout = super.fetchLayoutByFriendlyURL(groupId, privateLayout, friendlyURL);
        if (layout != null) {
            return layout;
        }
        return this._fetchLayoutByFriendlyURL(groupId, privateLayout, friendlyURL);
    }

    public Layout getFriendlyURLLayout(long groupId, boolean privateLayout, String friendlyURL) throws PortalException {
        try {
            return super.getFriendlyURLLayout(groupId, privateLayout, friendlyURL);
        }
        catch (NoSuchLayoutException noSuchLayoutException) {
            Layout layout = this._fetchLayoutByFriendlyURL(groupId, privateLayout, friendlyURL);
            if (layout != null) {
                return layout;
            }
            throw noSuchLayoutException;
        }
    }

    private void _copyAssetCategoryIdsAndAssetTagNames(Layout sourceLayout, Layout targetLayout, long userId) throws Exception {
        if (sourceLayout.isDraftLayout() || targetLayout.isDraftLayout()) {
            return;
        }
        this.updateAsset(userId, targetLayout, this._assetCategoryLocalService.getCategoryIds(Layout.class.getName(), sourceLayout.getPlid()), this._assetTagLocalService.getTagNames(Layout.class.getName(), sourceLayout.getPlid()));
    }

    private void _copyLayoutClassedModelUsages(Layout sourceLayout, Layout targetLayout) {
        List sourceLayoutLayoutClassedModelUsages = this._layoutClassedModelUsageLocalService.getLayoutClassedModelUsagesByPlid(sourceLayout.getPlid());
        this._deleteLayoutClassedModelUsages(sourceLayoutLayoutClassedModelUsages, targetLayout);
        List targetLayoutLayoutClassedModelUsages = this._layoutClassedModelUsageLocalService.getLayoutClassedModelUsagesByPlid(targetLayout.getPlid());
        for (LayoutClassedModelUsage sourceLayoutLayoutClassedModelUsage : sourceLayoutLayoutClassedModelUsages) {
            if (this._hasLayoutClassedModelUsage(targetLayoutLayoutClassedModelUsages, sourceLayoutLayoutClassedModelUsage)) continue;
            String containerKey = sourceLayoutLayoutClassedModelUsage.getContainerKey();
            long containerType = sourceLayoutLayoutClassedModelUsage.getContainerType();
            if (containerType == this._portal.getClassNameId(FragmentEntryLink.class.getName())) {
                long fragmentEntryLinkId = GetterUtil.getLong((String)sourceLayoutLayoutClassedModelUsage.getContainerKey());
                FragmentEntryLink fragmentEntryLink = this._fragmentEntryLinkLocalService.getFragmentEntryLink(sourceLayout.getGroupId(), fragmentEntryLinkId, targetLayout.getPlid());
                if (fragmentEntryLink != null) {
                    containerKey = String.valueOf(fragmentEntryLink.getFragmentEntryLinkId());
                    LayoutClassedModelUsage layoutClassedModelUsage = this._layoutClassedModelUsageLocalService.fetchLayoutClassedModelUsage(targetLayout.getGroupId(), sourceLayoutLayoutClassedModelUsage.getClassNameId(), sourceLayoutLayoutClassedModelUsage.getClassPK(), sourceLayoutLayoutClassedModelUsage.getClassedModelExternalReferenceCode(), containerKey, sourceLayoutLayoutClassedModelUsage.getContainerType(), targetLayout.getPlid());
                    if (layoutClassedModelUsage != null) continue;
                }
            }
            this._layoutClassedModelUsageLocalService.addLayoutClassedModelUsage(sourceLayoutLayoutClassedModelUsage.getGroupId(), sourceLayoutLayoutClassedModelUsage.getClassNameId(), sourceLayoutLayoutClassedModelUsage.getClassPK(), sourceLayoutLayoutClassedModelUsage.getClassedModelExternalReferenceCode(), containerKey, sourceLayoutLayoutClassedModelUsage.getContainerType(), targetLayout.getPlid(), ServiceContextThreadLocal.getServiceContext());
        }
    }

    /*
     * Exception decompiling
     */
    private Layout _copyLayoutContent(boolean copySegmentsExperience, Layout sourceLayout, long[] sourceSegmentsExperiencesIds, Layout targetLayout, long[] targetSegmentsExperiencesIds) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void _copyLayoutPageTemplateStructure(long[] segmentsExperiencesIds, Layout sourceLayout, Layout targetLayout, User user) throws Exception {
        Map<Long, FragmentEntryLink> fragmentEntryLinksMap = this._getFragmentEntryLinksMap(sourceLayout, segmentsExperiencesIds, targetLayout);
        LayoutPageTemplateStructure layoutPageTemplateStructure = this._layoutPageTemplateStructureLocalService.fetchLayoutPageTemplateStructure(sourceLayout.getGroupId(), sourceLayout.getPlid());
        Set<Long> targetFragmentEntryLinkIds = this._getTargetFragmentEntryLinkIds(segmentsExperiencesIds, targetLayout);
        LayoutPageTemplateStructure targetLayoutPageTemplateStructure = this._layoutPageTemplateStructureLocalService.fetchLayoutPageTemplateStructure(targetLayout.getGroupId(), targetLayout.getPlid());
        if (targetLayoutPageTemplateStructure == null) {
            this._layoutPageTemplateStructureLocalService.addLayoutPageTemplateStructure(user.getUserId(), targetLayout.getGroupId(), targetLayout.getPlid(), this._segmentsExperienceLocalService.fetchDefaultSegmentsExperienceId(targetLayout.getPlid()), null, ServiceContextThreadLocal.getServiceContext());
        }
        Map<Long, Long> segmentsExperienceIdsMap = this._getSegmentsExperienceIds(segmentsExperiencesIds, sourceLayout, targetLayout, user);
        for (Map.Entry<Long, Long> entry : segmentsExperienceIdsMap.entrySet()) {
            String data = layoutPageTemplateStructure.getData(entry.getKey().longValue());
            if (Validator.isNull((String)data)) {
                this._segmentsExperienceLocalService.deleteSegmentsExperience(entry.getKey().longValue());
                continue;
            }
            JSONObject dataJSONObject = this._processDataJSONObject(LayoutStructure.of((String)data), sourceLayout, targetLayout, fragmentEntryLinksMap, targetFragmentEntryLinkIds, entry.getValue(), user);
            this._layoutPageTemplateStructureLocalService.updateLayoutPageTemplateStructureData(targetLayout.getGroupId(), targetLayout.getPlid(), entry.getValue().longValue(), dataJSONObject.toString());
        }
        this._fragmentEntryLinkLocalService.deleteFragmentEntryLinks(ArrayUtil.toLongArray(targetFragmentEntryLinkIds));
    }

    private void _copyLayoutPageTemplateStructureFromSegmentsExperience(Layout sourceLayout, long sourceSegmentsExperienceId, Layout targetLayout, long targetSegmentsExperienceId, User user) throws Exception {
        LayoutPageTemplateStructure layoutPageTemplateStructure = this._layoutPageTemplateStructureLocalService.fetchLayoutPageTemplateStructure(sourceLayout.getGroupId(), sourceLayout.getPlid());
        String data = layoutPageTemplateStructure.getData(sourceSegmentsExperienceId);
        if (Validator.isNull((String)data)) {
            return;
        }
        Set<Long> targetFragmentEntryLinkIds = this._getTargetFragmentEntryLinkIds(new long[]{sourceSegmentsExperienceId}, targetLayout);
        LayoutStructure layoutStructure = LayoutStructure.of((String)data);
        for (DeletedLayoutStructureItem deletedLayoutStructureItem : layoutStructure.getDeletedLayoutStructureItems()) {
            layoutStructure.deleteLayoutStructureItem(deletedLayoutStructureItem.getItemId());
        }
        JSONObject dataJSONObject = this._processDataJSONObject(layoutStructure, sourceLayout, targetLayout, this._getFragmentEntryLinksMap(sourceLayout, new long[]{sourceSegmentsExperienceId}, targetLayout), targetFragmentEntryLinkIds, targetSegmentsExperienceId, user);
        this._layoutPageTemplateStructureLocalService.updateLayoutPageTemplateStructureData(targetLayout.getGroupId(), targetLayout.getPlid(), targetSegmentsExperienceId, dataJSONObject.toString());
        this._fragmentEntryLinkLocalService.deleteFragmentEntryLinks(ArrayUtil.toLongArray(targetFragmentEntryLinkIds));
    }

    private void _copyLayoutSEOEntry(Layout sourceLayout, Layout targetLayout, long userId) throws Exception {
        if (sourceLayout.isDraftLayout() || targetLayout.isDraftLayout()) {
            return;
        }
        LayoutSEOEntry layoutSEOEntry = this._layoutSEOEntryLocalService.fetchLayoutSEOEntry(sourceLayout.getGroupId(), sourceLayout.isPrivateLayout(), sourceLayout.getLayoutId());
        if (layoutSEOEntry == null) {
            LayoutSEOEntry targetLayoutSEOEntry = this._layoutSEOEntryLocalService.fetchLayoutSEOEntry(targetLayout.getGroupId(), targetLayout.isPrivateLayout(), targetLayout.getLayoutId());
            if (targetLayoutSEOEntry != null) {
                this._layoutSEOEntryLocalService.deleteLayoutSEOEntry(targetLayout.getGroupId(), targetLayout.isPrivateLayout(), targetLayout.getLayoutId());
            }
            return;
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        serviceContext.setAttribute("layout.instanceable.allowed", (Serializable)Boolean.TRUE);
        this._layoutSEOEntryLocalService.copyLayoutSEOEntry(userId, targetLayout.getGroupId(), targetLayout.isPrivateLayout(), targetLayout.getLayoutId(), layoutSEOEntry.isCanonicalURLEnabled(), layoutSEOEntry.getCanonicalURLMap(), layoutSEOEntry.getDDMStorageId(), layoutSEOEntry.isOpenGraphDescriptionEnabled(), layoutSEOEntry.getOpenGraphDescriptionMap(), layoutSEOEntry.getOpenGraphImageAltMap(), layoutSEOEntry.getOpenGraphImageFileEntryId(), layoutSEOEntry.isOpenGraphTitleEnabled(), layoutSEOEntry.getOpenGraphTitleMap(), serviceContext);
    }

    private void _copyPortletPermissions(List<String> portletIds, Layout sourceLayout, Layout targetLayout) throws Exception {
        for (String portletId : portletIds) {
            String resourceName = PortletIdCodec.decodePortletName((String)portletId);
            String sourceResourcePrimKey = PortletPermissionUtil.getPrimaryKey((long)sourceLayout.getPlid(), (String)portletId);
            Map sourceRoleIdsToActionIds = this._resourcePermissionLocalService.getAvailableResourcePermissionActionIds(targetLayout.getCompanyId(), resourceName, 4, sourceResourcePrimKey, (Collection)ResourceActionsUtil.getPortletResourceActions((String)resourceName));
            if (sourceRoleIdsToActionIds.isEmpty()) continue;
            List roleIds = TransformUtil.transform((Collection)ListUtil.filter((List)this._roleLocalService.getGroupRelatedRoles(targetLayout.getGroupId()), role -> !Objects.equals("Administrator", role.getName())), RoleModel::getRoleId);
            HashMap<Long, String[]> targetRoleIdsToActionIds = new HashMap<Long, String[]>();
            for (Map.Entry entry : sourceRoleIdsToActionIds.entrySet()) {
                Long roleId = (Long)entry.getKey();
                if (!roleIds.contains(roleId)) continue;
                Set sourceActionIds = (Set)entry.getValue();
                targetRoleIdsToActionIds.put(roleId, sourceActionIds.toArray(new String[0]));
            }
            this._resourcePermissionLocalService.setResourcePermissions(targetLayout.getCompanyId(), resourceName, 4, PortletPermissionUtil.getPrimaryKey((long)targetLayout.getPlid(), (String)portletId), targetRoleIdsToActionIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _copyPortletPreferences(List<String> portletIds, Layout sourceLayout, Layout targetLayout) {
        boolean stagingAdvicesThreadLocalEnabled = StagingAdvicesThreadLocal.isEnabled();
        try {
            StagingAdvicesThreadLocal.setEnabled((boolean)false);
            for (String portletId : portletIds) {
                PortletPreferencesIds portletPreferencesIds;
                javax.portlet.PortletPreferences jxPortletPreferences;
                Portlet portlet = this._portletLocalService.getPortletById(portletId);
                if (portlet == null || portlet.isUndeployedPortlet() || (jxPortletPreferences = this._portletPreferencesLocalService.fetchPreferences(portletPreferencesIds = this._portletPreferencesFactory.getPortletPreferencesIds(sourceLayout.getCompanyId(), sourceLayout.getGroupId(), 0L, sourceLayout.getPlid(), portletId))) == null) continue;
                PortletPreferences targetPortletPreferences = this._portletPreferencesLocalService.fetchPortletPreferences(portletPreferencesIds.getOwnerId(), portletPreferencesIds.getOwnerType(), targetLayout.getPlid(), portletId);
                if (targetPortletPreferences != null) {
                    this._portletPreferencesLocalService.updatePreferences(targetPortletPreferences.getOwnerId(), targetPortletPreferences.getOwnerType(), targetPortletPreferences.getPlid(), targetPortletPreferences.getPortletId(), jxPortletPreferences);
                    continue;
                }
                this._portletPreferencesLocalService.addPortletPreferences(targetLayout.getCompanyId(), portletPreferencesIds.getOwnerId(), portletPreferencesIds.getOwnerType(), targetLayout.getPlid(), portletId, portlet, PortletPreferencesFactoryUtil.toXML((javax.portlet.PortletPreferences)jxPortletPreferences));
            }
        }
        finally {
            StagingAdvicesThreadLocal.setEnabled((boolean)stagingAdvicesThreadLocalEnabled);
        }
    }

    private void _deleteLayoutClassedModelUsages(List<LayoutClassedModelUsage> sourceLayoutLayoutClassedModelUsages, Layout targetLayout) {
        for (LayoutClassedModelUsage targetLayoutClassedModelUsage : this._layoutClassedModelUsageLocalService.getLayoutClassedModelUsagesByPlid(targetLayout.getPlid())) {
            if (this._hasLayoutClassedModelUsage(sourceLayoutLayoutClassedModelUsages, targetLayoutClassedModelUsage)) continue;
            this._layoutClassedModelUsageLocalService.deleteLayoutClassedModelUsage(targetLayoutClassedModelUsage);
        }
    }

    private List<String> _deletePortletPermissions(Layout layout, long[] segmentsExperiencesIds) throws Exception {
        List<String> portletIds = this._getLayoutPortletIds(layout, segmentsExperiencesIds);
        for (String portletId : portletIds) {
            this._resourcePermissionLocalService.deleteResourcePermissions(layout.getCompanyId(), PortletIdCodec.decodePortletName((String)portletId), 4, PortletPermissionUtil.getPrimaryKey((long)layout.getPlid(), (String)portletId));
        }
        return portletIds;
    }

    private Layout _fetchLayoutByFriendlyURL(long groupId, boolean privateLayout, String friendlyURL) {
        Layout layout;
        FriendlyURLEntry friendlyURLEntry = this._friendlyURLEntryLocalService.fetchFriendlyURLEntry(groupId, this._layoutFriendlyURLEntryHelper.getClassNameId(privateLayout), friendlyURL);
        if (friendlyURLEntry != null && (layout = this.fetchLayout(friendlyURLEntry.getClassPK())) != null) {
            return layout;
        }
        return null;
    }

    private Map<Long, FragmentEntryLink> _getFragmentEntryLinksMap(Layout sourceLayout, long[] segmentsExperiencesIds, Layout targetLayout) {
        HashMap<Long, FragmentEntryLink> fragmentEntryLinksMap = new HashMap<Long, FragmentEntryLink>();
        for (FragmentEntryLink fragmentEntryLink : this._fragmentEntryLinkLocalService.getFragmentEntryLinksBySegmentsExperienceId(sourceLayout.getGroupId(), segmentsExperiencesIds, sourceLayout.getPlid())) {
            if (fragmentEntryLink.isDeleted()) {
                FragmentEntryLink targetLayoutFragmentEntryLink = this._fragmentEntryLinkLocalService.getFragmentEntryLink(targetLayout.getGroupId(), fragmentEntryLink.getFragmentEntryLinkId(), targetLayout.getPlid());
                if (targetLayoutFragmentEntryLink == null) continue;
                this._fragmentEntryLinkLocalService.deleteFragmentEntryLink(targetLayoutFragmentEntryLink);
                continue;
            }
            fragmentEntryLinksMap.put(fragmentEntryLink.getFragmentEntryLinkId(), fragmentEntryLink);
        }
        return fragmentEntryLinksMap;
    }

    private List<String> _getLayoutPortletIds(Layout layout, long[] segmentsExperiencesIds) {
        ArrayList<String> layoutPortletIds = new ArrayList<String>();
        for (FragmentEntryLink fragmentEntryLink : this._fragmentEntryLinkLocalService.getFragmentEntryLinksBySegmentsExperienceId(layout.getGroupId(), segmentsExperiencesIds, layout.getPlid(), false)) {
            layoutPortletIds.addAll(this._portletRegistry.getFragmentEntryLinkPortletIds(fragmentEntryLink));
        }
        return layoutPortletIds;
    }

    private Map<Long, Long> _getSegmentsExperienceIds(long[] segmentsExperiencesIds, Layout sourceLayout, Layout targetLayout, User user) {
        HashMap<Long, Long> segmentsExperienceIdsMap = new HashMap<Long, Long>();
        if (sourceLayout.isDraftLayout() || targetLayout.isDraftLayout()) {
            for (long segmentsExperienceId : segmentsExperiencesIds) {
                SegmentsExperience segmentsExperience = this._segmentsExperienceLocalService.fetchSegmentsExperience(segmentsExperienceId);
                if (Objects.equals(segmentsExperience.getSegmentsExperienceKey(), "DEFAULT")) {
                    segmentsExperienceIdsMap.put(segmentsExperience.getSegmentsExperienceId(), this._segmentsExperienceLocalService.fetchDefaultSegmentsExperienceId(targetLayout.getPlid()));
                    continue;
                }
                segmentsExperienceIdsMap.put(segmentsExperienceId, segmentsExperienceId);
            }
            return segmentsExperienceIdsMap;
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        for (long segmentsExperienceId : segmentsExperiencesIds) {
            SegmentsExperience segmentsExperience = this._segmentsExperienceLocalService.fetchSegmentsExperience(segmentsExperienceId);
            if (Objects.equals(segmentsExperience.getSegmentsExperienceKey(), "DEFAULT")) {
                segmentsExperienceIdsMap.put(segmentsExperience.getSegmentsExperienceId(), this._segmentsExperienceLocalService.fetchDefaultSegmentsExperienceId(targetLayout.getPlid()));
                continue;
            }
            SegmentsExperience newSegmentsExperience = (SegmentsExperience)segmentsExperience.clone();
            newSegmentsExperience.setUuid(serviceContext.getUuid());
            newSegmentsExperience.setSegmentsExperienceId(this._counterLocalService.increment());
            newSegmentsExperience.setUserId(user.getUserId());
            newSegmentsExperience.setUserName(user.getFullName());
            newSegmentsExperience.setCreateDate(serviceContext.getCreateDate(new Date()));
            newSegmentsExperience.setModifiedDate(serviceContext.getModifiedDate(new Date()));
            newSegmentsExperience.setSegmentsExperienceKey(String.valueOf(this._counterLocalService.increment()));
            newSegmentsExperience.setPlid(targetLayout.getPlid());
            this._segmentsExperienceLocalService.addSegmentsExperience(newSegmentsExperience);
            segmentsExperienceIdsMap.put(segmentsExperience.getSegmentsExperienceId(), newSegmentsExperience.getSegmentsExperienceId());
        }
        return segmentsExperienceIdsMap;
    }

    private Set<Long> _getTargetFragmentEntryLinkIds(long[] segmentsExperiencesIds, Layout targetLayout) {
        return new HashSet<Long>(ListUtil.toList((List)this._fragmentEntryLinkLocalService.getFragmentEntryLinksBySegmentsExperienceId(targetLayout.getGroupId(), segmentsExperiencesIds, targetLayout.getPlid()), (Accessor)FragmentEntryLink.FRAGMENT_ENTRY_LINK_ID_ACCESSOR));
    }

    private String _getTypeSettings(Layout sourceLayout, Layout targetLayout) {
        if (!sourceLayout.isDraftLayout() && !targetLayout.isDraftLayout()) {
            return sourceLayout.getTypeSettings();
        }
        if (targetLayout.isDraftLayout()) {
            UnicodeProperties typeSettingsUnicodeProperties = UnicodePropertiesBuilder.create((boolean)true).fastLoad(sourceLayout.getTypeSettings()).build();
            return UnicodePropertiesBuilder.create((boolean)true).fastLoad(sourceLayout.getTypeSettings()).setProperty("published", Boolean.FALSE.toString()).setProperty("query-string", typeSettingsUnicodeProperties.getProperty("query-string")).setProperty("target", typeSettingsUnicodeProperties.getProperty("target")).setProperty("targetType", typeSettingsUnicodeProperties.getProperty("targetType")).buildString();
        }
        UnicodeProperties typeSettingsUnicodeProperties = UnicodePropertiesBuilder.create((boolean)true).fastLoad(targetLayout.getTypeSettings()).build();
        return UnicodePropertiesBuilder.create((boolean)true).fastLoad(sourceLayout.getTypeSettings()).setProperty("query-string", typeSettingsUnicodeProperties.getProperty("query-string")).setProperty("target", typeSettingsUnicodeProperties.getProperty("target")).setProperty("targetType", typeSettingsUnicodeProperties.getProperty("targetType")).buildString();
    }

    private User _getUser(Layout sourceLayout, Layout targetLayout, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.fetchUser(targetLayout.getUserId());
        if (user != null) {
            return user;
        }
        user = this._userLocalService.fetchUser(sourceLayout.getUserId());
        if (user != null) {
            return user;
        }
        if (serviceContext != null) {
            user = serviceContext.fetchUser();
        }
        if (user != null) {
            return user;
        }
        return GuestOrUserUtil.getGuestOrUser();
    }

    private boolean _hasLayoutClassedModelUsage(List<LayoutClassedModelUsage> layoutClassedModelUsages, LayoutClassedModelUsage targetLayoutClassedModelUsage) {
        for (LayoutClassedModelUsage layoutClassedModelUsage : layoutClassedModelUsages) {
            if (layoutClassedModelUsage.getClassNameId() != targetLayoutClassedModelUsage.getClassNameId() || layoutClassedModelUsage.getClassPK() != targetLayoutClassedModelUsage.getClassPK() || !Objects.equals(layoutClassedModelUsage.getContainerKey(), targetLayoutClassedModelUsage.getContainerKey()) || layoutClassedModelUsage.getContainerType() != targetLayoutClassedModelUsage.getContainerType()) continue;
            return true;
        }
        return false;
    }

    private JSONObject _processDataJSONObject(LayoutStructure layoutStructure, Layout sourceLayout, Layout targetLayout, Map<Long, FragmentEntryLink> sourceFragmentEntryLinksMap, Set<Long> targetFragmentEntryLinkIds, long targetSegmentsExperienceId, User user) throws Exception {
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        for (LayoutStructureItem layoutStructureItem : layoutStructure.getLayoutStructureItems()) {
            FragmentStyledLayoutStructureItem fragmentStyledLayoutStructureItem;
            FragmentEntryLink sourceLayoutfragmentEntryLink;
            if (!(layoutStructureItem instanceof FragmentStyledLayoutStructureItem) || (sourceLayoutfragmentEntryLink = sourceFragmentEntryLinksMap.get((fragmentStyledLayoutStructureItem = (FragmentStyledLayoutStructureItem)layoutStructureItem).getFragmentEntryLinkId())) == null) continue;
            FragmentEntryLink newFragmentEntryLink = null;
            FragmentEntryLink targetLayoutFragmentEntryLink = this._fragmentEntryLinkLocalService.getFragmentEntryLink(targetLayout.getGroupId(), fragmentStyledLayoutStructureItem.getFragmentEntryLinkId(), targetLayout.getPlid());
            if (targetLayoutFragmentEntryLink != null) {
                targetLayoutFragmentEntryLink.setUserId(user.getUserId());
                targetLayoutFragmentEntryLink.setUserName(user.getFullName());
                targetLayoutFragmentEntryLink.setModifiedDate(serviceContext.getModifiedDate(new Date()));
                if (sourceLayout.getClassPK() == targetLayout.getPlid()) {
                    targetLayoutFragmentEntryLink.setOriginalFragmentEntryLinkId(sourceLayoutfragmentEntryLink.getFragmentEntryLinkId());
                } else {
                    targetLayoutFragmentEntryLink.setOriginalFragmentEntryLinkId(0L);
                }
                targetLayoutFragmentEntryLink.setSegmentsExperienceId(targetSegmentsExperienceId);
                targetLayoutFragmentEntryLink.setClassPK(targetLayout.getPlid());
                targetLayoutFragmentEntryLink.setPlid(targetLayout.getPlid());
                targetLayoutFragmentEntryLink.setCss(sourceLayoutfragmentEntryLink.getCss());
                targetLayoutFragmentEntryLink.setHtml(sourceLayoutfragmentEntryLink.getHtml());
                targetLayoutFragmentEntryLink.setJs(sourceLayoutfragmentEntryLink.getJs());
                targetLayoutFragmentEntryLink.setConfiguration(sourceLayoutfragmentEntryLink.getConfiguration());
                targetLayoutFragmentEntryLink.setEditableValues(sourceLayoutfragmentEntryLink.getEditableValues());
                targetLayoutFragmentEntryLink.setLastPropagationDate(sourceLayoutfragmentEntryLink.getLastPropagationDate());
                newFragmentEntryLink = this._fragmentEntryLinkLocalService.updateFragmentEntryLink(targetLayoutFragmentEntryLink);
                this._commentManager.deleteDiscussion(FragmentEntryLink.class.getName(), newFragmentEntryLink.getFragmentEntryLinkId());
                this._fragmentEntryLinkCache.removeFragmentEntryLinkCache(newFragmentEntryLink);
            } else {
                newFragmentEntryLink = (FragmentEntryLink)sourceLayoutfragmentEntryLink.clone();
                newFragmentEntryLink.setUuid(serviceContext.getUuid());
                newFragmentEntryLink.setExternalReferenceCode(null);
                newFragmentEntryLink.setFragmentEntryLinkId(this._counterLocalService.increment());
                newFragmentEntryLink.setUserId(user.getUserId());
                newFragmentEntryLink.setUserName(user.getFullName());
                newFragmentEntryLink.setCreateDate(serviceContext.getCreateDate(new Date()));
                newFragmentEntryLink.setModifiedDate(serviceContext.getModifiedDate(new Date()));
                if (sourceLayout.getClassPK() == targetLayout.getPlid()) {
                    newFragmentEntryLink.setOriginalFragmentEntryLinkId(sourceLayoutfragmentEntryLink.getFragmentEntryLinkId());
                } else {
                    newFragmentEntryLink.setOriginalFragmentEntryLinkId(0L);
                }
                newFragmentEntryLink.setSegmentsExperienceId(targetSegmentsExperienceId);
                newFragmentEntryLink.setClassNameId(this._portal.getClassNameId(Layout.class));
                newFragmentEntryLink.setClassPK(targetLayout.getPlid());
                newFragmentEntryLink.setPlid(targetLayout.getPlid());
                newFragmentEntryLink.setLastPropagationDate(sourceLayoutfragmentEntryLink.getLastPropagationDate());
                newFragmentEntryLink = this._fragmentEntryLinkLocalService.addFragmentEntryLink(newFragmentEntryLink);
            }
            fragmentStyledLayoutStructureItem.setFragmentEntryLinkId(newFragmentEntryLink.getFragmentEntryLinkId());
            targetFragmentEntryLinkIds.remove(newFragmentEntryLink.getFragmentEntryLinkId());
            this._commentManager.copyDiscussion(user.getUserId(), targetLayout.getGroupId(), FragmentEntryLink.class.getName(), sourceLayoutfragmentEntryLink.getFragmentEntryLinkId(), newFragmentEntryLink.getFragmentEntryLinkId(), className -> serviceContext);
        }
        return layoutStructure.toJSONObject();
    }

    private class CopyLayoutCallable
    implements Callable<Layout> {
        private final boolean _copySegmentsExperience;
        private final Layout _sourceLayout;
        private final long[] _sourceSegmentsExperiencesIds;
        private final Layout _targetLayout;
        private final long[] _targetSegmentsExperiencesIds;
        private final User _user;

        @Override
        public Layout call() throws Exception {
            if (Objects.equals(this._sourceLayout.getType(), "portlet")) {
                LayoutLocalServiceWrapper.this._sites.copyPortletPermissions(this._targetLayout, this._sourceLayout);
            } else {
                List oldPortletIds = LayoutLocalServiceWrapper.this._deletePortletPermissions(this._targetLayout, this._targetSegmentsExperiencesIds);
                if (this._copySegmentsExperience) {
                    LayoutLocalServiceWrapper.this._copyLayoutPageTemplateStructureFromSegmentsExperience(this._sourceLayout, this._sourceSegmentsExperiencesIds[0], this._targetLayout, this._targetSegmentsExperiencesIds[0], this._user);
                } else {
                    LayoutLocalServiceWrapper.this._copyLayoutPageTemplateStructure(this._sourceSegmentsExperiencesIds, this._sourceLayout, this._targetLayout, this._user);
                }
                List portletIds = LayoutLocalServiceWrapper.this._getLayoutPortletIds(this._sourceLayout, this._sourceSegmentsExperiencesIds);
                LayoutLocalServiceWrapper.this._copyPortletPermissions(portletIds, this._sourceLayout, this._targetLayout);
                LayoutLocalServiceWrapper.this._copyPortletPreferences(portletIds, this._sourceLayout, this._targetLayout);
                this._deleteOrphanPortletPreferences(portletIds, oldPortletIds);
            }
            LayoutLocalServiceWrapper.this._copyLayoutClassedModelUsages(this._sourceLayout, this._targetLayout);
            LayoutLocalServiceWrapper.this._sites.copyExpandoBridgeAttributes(this._sourceLayout, this._targetLayout);
            LayoutLocalServiceWrapper.this._sites.copyPortletSetups(this._sourceLayout, this._targetLayout);
            LayoutLocalServiceWrapper.this._copyAssetCategoryIdsAndAssetTagNames(this._sourceLayout, this._targetLayout, this._user.getUserId());
            LayoutLocalServiceWrapper.this._copyLayoutSEOEntry(this._sourceLayout, this._targetLayout, this._user.getUserId());
            this._copyLayoutClientExtensions(this._sourceLayout, this._targetLayout, this._user.getUserId());
            Image image = LayoutLocalServiceWrapper.this._imageLocalService.getImage(this._sourceLayout.getIconImageId());
            byte[] imageBytes = null;
            if (image != null) {
                imageBytes = image.getTextObj();
            }
            return LayoutLocalServiceWrapper.this.updateLayout(this._targetLayout.getGroupId(), this._targetLayout.isPrivateLayout(), this._targetLayout.getLayoutId(), LayoutLocalServiceWrapper.this._getTypeSettings(this._sourceLayout, this._targetLayout), imageBytes, this._sourceLayout.getThemeId(), this._sourceLayout.getColorSchemeId(), this._sourceLayout.getStyleBookEntryId(), this._sourceLayout.getCss(), this._sourceLayout.getFaviconFileEntryId(), this._sourceLayout.getMasterLayoutPlid());
        }

        private CopyLayoutCallable(boolean copySegmentsExperience, Layout sourceLayout, long[] sourceSegmentsExperiencesIds, Layout targetLayout, long[] targetSegmentsExperiencesIds, User user) {
            this._copySegmentsExperience = copySegmentsExperience;
            this._sourceLayout = sourceLayout;
            this._sourceSegmentsExperiencesIds = sourceSegmentsExperiencesIds;
            this._targetLayout = targetLayout;
            this._targetSegmentsExperiencesIds = targetSegmentsExperiencesIds;
            this._user = user;
        }

        private void _copyLayoutClientExtensions(Layout sourceLayout, Layout targetLayout, long userId) throws Exception {
            long classNameId = LayoutLocalServiceWrapper.this._portal.getClassNameId(Layout.class);
            LayoutLocalServiceWrapper.this._clientExtensionEntryRelLocalService.deleteClientExtensionEntryRels(classNameId, targetLayout.getPlid());
            List clientExtensionEntryRels = LayoutLocalServiceWrapper.this._clientExtensionEntryRelLocalService.getClientExtensionEntryRels(classNameId, sourceLayout.getPlid());
            for (ClientExtensionEntryRel clientExtensionEntryRel : clientExtensionEntryRels) {
                LayoutLocalServiceWrapper.this._clientExtensionEntryRelLocalService.addClientExtensionEntryRel(userId, targetLayout.getGroupId(), classNameId, targetLayout.getPlid(), clientExtensionEntryRel.getCETExternalReferenceCode(), clientExtensionEntryRel.getType(), clientExtensionEntryRel.getTypeSettings(), ServiceContextThreadLocal.getServiceContext());
            }
        }

        private void _deleteOrphanPortletPreferences(List<String> portletIds, List<String> oldPortletIds) {
            Object[] deletedPortletIds = (String[])TransformUtil.transformToArray(oldPortletIds, portletId -> {
                if (portletIds.contains(portletId)) {
                    return null;
                }
                return portletId;
            }, String.class);
            if (ArrayUtil.isEmpty((Object[])deletedPortletIds)) {
                return;
            }
            LayoutPageTemplateEntry layoutPageTemplateEntry = LayoutLocalServiceWrapper.this._layoutPageTemplateEntryLocalService.fetchLayoutPageTemplateEntryByPlid(this._targetLayout.getPlid());
            if (layoutPageTemplateEntry == null || !Objects.equals(layoutPageTemplateEntry.getType(), 3)) {
                return;
            }
            for (Object portletId2 : deletedPortletIds) {
                for (PortletPreferences portletPreferences : LayoutLocalServiceWrapper.this._portletPreferencesLocalService.getPortletPreferencesByPortletId((String)portletId2)) {
                    try {
                        LayoutLocalServiceWrapper.this._portletPreferencesLocalService.deletePortletPreferences(portletPreferences);
                    }
                    catch (Exception exception) {
                        if (!_log.isDebugEnabled()) continue;
                        _log.debug((Throwable)exception);
                    }
                }
            }
        }
    }
}

