/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.upgrade.v1_0_0;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourceLocalServiceUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.version.Version;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class LayoutPermissionsUpgradeProcess
extends UpgradeProcess {
    private static final Version _VERSION = Version.parseVersion((String)"1.0.0");

    protected void doUpgrade() throws Exception {
        String sql = SQLTransformer.transform((String)StringBundler.concat((Object[])new Object[]{"select Layout.companyId, Layout.plid, Layout.privateLayout", ", Layout.groupId, Layout.userId from Layout left join ", "ResourcePermission on (ResourcePermission.companyId = ", "Layout.companyId and ResourcePermission.name = '", Layout.class.getName(), "' and ResourcePermission.scope = ", 4, " and ResourcePermission.primKeyId = Layout.plid) where ", "ResourcePermission.resourcePermissionId is null"}));
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement preparedStatement = this.connection.prepareStatement(sql);
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                long companyId = resultSet.getLong("companyId");
                long groupId = resultSet.getLong("groupId");
                long plid = resultSet.getLong("plid");
                boolean privateLayout = resultSet.getBoolean("privateLayout");
                long userId = resultSet.getLong("userId");
                boolean addGroupPermission = true;
                boolean addGuestPermission = true;
                if (privateLayout) {
                    addGuestPermission = false;
                    Group group = GroupLocalServiceUtil.getGroup((long)groupId);
                    if (group.isUser() || group.isUserGroup()) {
                        addGroupPermission = false;
                    }
                }
                ResourceLocalServiceUtil.addResources((long)companyId, (long)groupId, (long)userId, (String)Layout.class.getName(), (long)plid, (boolean)false, (boolean)addGroupPermission, (boolean)addGuestPermission);
            }
        }
    }

    protected boolean isSkipUpgradeProcess() throws Exception {
        block36: {
            try (PreparedStatement preparedStatement = this.connection.prepareStatement("select schemaVersion from Release_ where servletContextName = 'com.liferay.layout.impl'");){
                boolean bl;
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    if (!resultSet.next()) {
                        boolean bl2 = false;
                        return bl2;
                    }
                    Version version = Version.parseVersion((String)resultSet.getString("schemaVersion"));
                    if (_VERSION.compareTo(version) > 0) break block36;
                    bl = true;
                }
                return bl;
            }
        }
        return false;
    }
}

