/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.upgrade.v1_3_1;

import com.liferay.change.tracking.model.CTCollection;
import com.liferay.change.tracking.model.CTCollectionTable;
import com.liferay.change.tracking.model.CTEntry;
import com.liferay.change.tracking.model.CTEntryTable;
import com.liferay.change.tracking.service.CTCollectionLocalService;
import com.liferay.change.tracking.service.CTEntryLocalService;
import com.liferay.layout.model.LayoutLocalization;
import com.liferay.layout.model.LayoutLocalizationTable;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.Portal;
import java.util.List;

public class LayoutLocalizationUpgradeProcess
extends UpgradeProcess {
    private final CTCollectionLocalService _ctCollectionLocalService;
    private final CTEntryLocalService _ctEntryLocalService;
    private final Portal _portal;

    public LayoutLocalizationUpgradeProcess(CTCollectionLocalService ctCollectionLocalService, CTEntryLocalService ctEntryLocalService, Portal portal) {
        this._ctCollectionLocalService = ctCollectionLocalService;
        this._ctEntryLocalService = ctEntryLocalService;
        this._portal = portal;
    }

    protected void doUpgrade() throws Exception {
        this.runSQL("delete from LayoutLocalization where plid not in (select plid from Layout)");
        for (CTCollection ctCollection : (List)this._ctCollectionLocalService.dslQuery((DSLQuery)DSLQueryFactoryUtil.select((Table)CTCollectionTable.INSTANCE).from((Table)CTCollectionTable.INSTANCE).where(CTCollectionTable.INSTANCE.status.eq((Object)2)))) {
            SafeCloseable safeCloseable = CTCollectionThreadLocal.setCTCollectionIdWithSafeCloseable((long)ctCollection.getCtCollectionId());
            Throwable throwable = null;
            try {
                for (CTEntry ctEntry : (List)this._ctEntryLocalService.dslQuery((DSLQuery)DSLQueryFactoryUtil.select((Table)CTEntryTable.INSTANCE).from((Table)CTEntryTable.INSTANCE).where(CTEntryTable.INSTANCE.modelClassNameId.eq((Object)this._portal.getClassNameId(LayoutLocalization.class.getName())).and((Expression)CTEntryTable.INSTANCE.modelClassPK.notIn((DSLQuery)DSLQueryFactoryUtil.select((Expression[])new Expression[]{LayoutLocalizationTable.INSTANCE.layoutLocalizationId}).from((Table)LayoutLocalizationTable.INSTANCE)))))) {
                    this._ctEntryLocalService.deleteCTEntry(ctEntry);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (safeCloseable == null) continue;
                if (throwable != null) {
                    try {
                        safeCloseable.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                safeCloseable.close();
            }
        }
    }
}

