/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.upgrade.v1_4_2;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.PortalUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class LayoutUpgradeProcess
extends UpgradeProcess {
    private final LayoutLocalService _layoutLocalService;

    public LayoutUpgradeProcess(LayoutLocalService layoutLocalService) {
        this._layoutLocalService = layoutLocalService;
    }

    protected void doUpgrade() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement preparedStatement1 = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select groupId, plid from Layout where privateLayout = ? ", "and (plid IN (select plid from LayoutPageTemplateEntry ", "where type_ = ?) OR (classPK IN (select plid from ", "LayoutPageTemplateEntry where type_ = ?) and classNameId ", "= ?))"}));
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.autoBatch((Connection)this.connection, (String)"update Layout set privateLayout = ?, layoutId = ? where plid = ?");
             PreparedStatement preparedStatement3 = AutoBatchPreparedStatementUtil.autoBatch((Connection)this.connection, (String)"update LayoutFriendlyURL set privateLayout = ? where plid = ?");){
            preparedStatement1.setBoolean(1, false);
            preparedStatement1.setLong(2, 3L);
            preparedStatement1.setLong(3, 3L);
            preparedStatement1.setLong(4, PortalUtil.getClassNameId((String)Layout.class.getName()));
            try (ResultSet resultSet = preparedStatement1.executeQuery();){
                while (resultSet.next()) {
                    long groupId = resultSet.getLong("groupId");
                    long plid = resultSet.getLong("plid");
                    preparedStatement2.setBoolean(1, true);
                    preparedStatement2.setLong(2, this._layoutLocalService.getNextLayoutId(groupId, true));
                    preparedStatement2.setLong(3, plid);
                    preparedStatement2.addBatch();
                    preparedStatement3.setBoolean(1, true);
                    preparedStatement3.setLong(2, plid);
                    preparedStatement3.addBatch();
                }
            }
            preparedStatement2.executeBatch();
            preparedStatement3.executeBatch();
        }
    }
}

